/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.cs;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import javax.units.ConversionException;
import javax.units.Converter;
import javax.units.SI;
import javax.units.Unit;
import org.geotools.measure.Measure;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.operation.GeneralMatrix;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.resources.Utilities;
import org.geotools.resources.cts.Resources;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.operation.Matrix;
import org.opengis.spatialschema.geometry.MismatchedDimensionException;

public class AbstractCS
extends AbstractIdentifiedObject
implements CoordinateSystem {
    private static final long serialVersionUID = 6757665252533744744L;
    private final CoordinateSystemAxis[] axis;
    private transient Unit distanceUnit;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AbstractCS(String name, CoordinateSystemAxis[] axis) {
        this(Collections.singletonMap("name", name), axis);
    }

    public AbstractCS(Map properties, CoordinateSystemAxis[] axis) {
        super(properties);
        AbstractCS.ensureNonNull("axis", axis);
        this.axis = (CoordinateSystemAxis[])axis.clone();
        for (int i = 0; i < axis.length; ++i) {
            AbstractCS.ensureNonNull("axis", axis, i);
            AxisDirection check = axis[i].getDirection();
            AbstractCS.ensureNonNull("direction", check);
            if (!this.isCompatibleDirection(check)) {
                throw new IllegalArgumentException(Resources.format(84, check.name(), Utilities.getShortClassName(this)));
            }
            if ((check = check.absolute()).equals(AxisDirection.OTHER)) continue;
            int j = i;
            while (--j >= 0) {
                if (!check.equals(axis[j].getDirection().absolute())) continue;
                String nameI = axis[i].getDirection().name();
                String nameJ = axis[j].getDirection().name();
                throw new IllegalArgumentException(Resources.format(73, nameI, nameJ));
            }
        }
    }

    protected boolean isCompatibleDirection(AxisDirection direction) {
        return true;
    }

    public int getDimension() {
        return this.axis.length;
    }

    public CoordinateSystemAxis getAxis(int dimension) throws IndexOutOfBoundsException {
        return this.axis[dimension];
    }

    private static AxisDirection[] getAxisDirections(CoordinateSystem cs) {
        AxisDirection[] axis = new AxisDirection[cs.getDimension()];
        for (int i = 0; i < axis.length; ++i) {
            axis[i] = cs.getAxis(i).getDirection();
        }
        return axis;
    }

    public static Matrix swapAndScaleAxis(CoordinateSystem sourceCS, CoordinateSystem targetCS) throws IllegalArgumentException, ConversionException {
        if (!Utilities.sameInterfaces(sourceCS.getClass(), targetCS.getClass(), CoordinateSystem.class)) {
            throw new IllegalArgumentException("Incompatible type of coordinate systems.");
        }
        Object[] sourceAxis = AbstractCS.getAxisDirections(sourceCS);
        Object[] targetAxis = AbstractCS.getAxisDirections(targetCS);
        GeneralMatrix matrix = new GeneralMatrix((AxisDirection[])sourceAxis, (AxisDirection[])targetAxis);
        if (!$assertionsDisabled && Arrays.equals(sourceAxis, targetAxis) != matrix.isIdentity()) {
            throw new AssertionError((Object)matrix);
        }
        int sourceDim = matrix.getNumCol() - 1;
        int targetDim = matrix.getNumRow() - 1;
        if (!$assertionsDisabled && sourceDim != sourceCS.getDimension()) {
            throw new AssertionError(sourceCS);
        }
        if (!$assertionsDisabled && targetDim != targetCS.getDimension()) {
            throw new AssertionError(targetCS);
        }
        for (int j = 0; j < targetDim; ++j) {
            Unit targetUnit = targetCS.getAxis(j).getUnit();
            for (int i = 0; i < sourceDim; ++i) {
                Unit sourceUnit;
                double element = matrix.getElement(j, i);
                if (element == 0.0 || Utilities.equals(sourceUnit = sourceCS.getAxis(i).getUnit(), targetUnit)) continue;
                Converter converter = sourceUnit.getConverterTo(targetUnit);
                if (!converter.isLinear()) {
                    throw new ConversionException("Unit conversion is non-linear");
                }
                double offset = converter.convert(0.0);
                double scale = converter.derivative(0.0);
                matrix.setElement(j, i, element * scale);
                matrix.setElement(j, sourceDim, matrix.getElement(j, sourceDim) + element * offset);
            }
        }
        return matrix;
    }

    final Unit getDistanceUnit() throws ConversionException {
        Unit unit = this.distanceUnit;
        if (unit == null) {
            for (int i = 0; i < this.axis.length; ++i) {
                Unit candidate = this.axis[i].getUnit();
                if (candidate == null || candidate.isCompatible(SI.RADIAN)) continue;
                if (unit != null) {
                    Converter converter = candidate.getConverterTo(unit);
                    if (!converter.isLinear()) {
                        throw new ConversionException("Unit conversion is non-linear");
                    }
                    if (Math.abs(converter.derivative(0.0)) <= 1.0) continue;
                }
                unit = candidate;
            }
            this.distanceUnit = unit;
        }
        return unit;
    }

    final void ensureDimensionMatch(String name, double[] coordinates) throws MismatchedDimensionException {
        if (coordinates.length != this.axis.length) {
            throw new MismatchedDimensionException(Resources.format(99, name, new Integer(coordinates.length), new Integer(this.axis.length)));
        }
    }

    public Measure distance(double[] coord1, double[] coord2) throws UnsupportedOperationException, MismatchedDimensionException {
        throw new UnsupportedOperationException();
    }

    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, compareMetadata)) {
            AbstractCS that = (AbstractCS)object;
            return AbstractCS.equals((IdentifiedObject[])this.axis, (IdentifiedObject[])that.axis, compareMetadata);
        }
        return false;
    }

    public int hashCode() {
        int code = 1480995944;
        for (int i = 0; i < this.axis.length; ++i) {
            code = code * 37 + this.axis[i].hashCode();
        }
        return code;
    }

    protected String formatWKT(Formatter formatter) {
        for (int i = 0; i < this.axis.length; ++i) {
            formatter.append((IdentifiedObject)this.axis[i]);
        }
        formatter.setInvalidWKT();
        return super.formatWKT(formatter);
    }

    static {
        $assertionsDisabled = !AbstractCS.class.desiredAssertionStatus();
    }
}

