/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.cs;

import java.util.Map;
import org.geotools.measure.Measure;
import org.geotools.referencing.cs.AbstractCS;
import org.geotools.referencing.cs.DefaultCoordinateSystemAxis;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.spatialschema.geometry.MismatchedDimensionException;

public class DefaultTimeCS
extends AbstractCS
implements TimeCS {
    private static final long serialVersionUID = 5222911412381303989L;
    public static DefaultTimeCS DAYS = new DefaultTimeCS("Temporal", (CoordinateSystemAxis)DefaultCoordinateSystemAxis.TIME);

    public DefaultTimeCS(String name, CoordinateSystemAxis axis) {
        super(name, new CoordinateSystemAxis[]{axis});
        DefaultTimeCS.ensureTimeUnit(this.getAxis(0).getUnit());
    }

    public DefaultTimeCS(Map properties, CoordinateSystemAxis axis) {
        super(properties, new CoordinateSystemAxis[]{axis});
        DefaultTimeCS.ensureTimeUnit(this.getAxis(0).getUnit());
    }

    protected boolean isCompatibleDirection(AxisDirection direction) {
        return AxisDirection.FUTURE.equals(direction.absolute());
    }

    public Measure distance(double[] coord1, double[] coord2) throws MismatchedDimensionException {
        this.ensureDimensionMatch("coord1", coord1);
        this.ensureDimensionMatch("coord2", coord2);
        return new Measure(Math.abs(coord1[0] - coord2[0]), this.getDistanceUnit());
    }
}

