/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.epsg;

import java.sql.Connection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.geotools.referencing.factory.FactoryGroup;
import org.geotools.referencing.factory.epsg.FactoryUsingSQL;

public class FactoryUsingAnsiSQL
extends FactoryUsingSQL {
    private static final String[] ANSI = new String[]{"[Alias]", "epsg_alias", "[Area]", "epsg_area", "[Coordinate Axis]", "epsg_coordinateaxis", "[Coordinate Axis Name]", "epsg_coordinateaxisname", "[Coordinate_Operation]", "epsg_coordoperation", "[Coordinate_Operation Method]", "epsg_coordoperationmethod", "[Coordinate_Operation Parameter]", "epsg_coordoperationparam", "[Coordinate_Operation Parameter Usage]", "epsg_coordoperationparamusage", "[Coordinate_Operation Parameter Value]", "epsg_coordoperationparamvalue", "[Coordinate Reference System]", "epsg_coordinatereferencesystem", "[Coordinate System]", "epsg_coordinatesystem", "[Datum]", "epsg_datum", "[Ellipsoid]", "epsg_ellipsoid", "[Naming System]", "epsg_namingsystem", "[Prime Meridian]", "epsg_primemeridian", "[Unit of Measure]", "epsg_unitofmeasure", "[Version History]", "epsg_versionhistory", "[CA.ORDER]", "coord_axis_order"};
    protected final Map map = new LinkedHashMap();

    public FactoryUsingAnsiSQL(FactoryGroup factories, Connection connection) {
        super(factories, connection);
        for (int i = 0; i < ANSI.length; ++i) {
            this.map.put(ANSI[i], ANSI[++i]);
        }
    }

    protected String adaptSQL(String statement) {
        StringBuffer modified = new StringBuffer(statement);
        Iterator it = this.map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String oldName = (String)entry.getKey();
            String newName = (String)entry.getValue();
            int start = 0;
            while ((start = modified.indexOf(oldName, start)) >= 0) {
                modified.replace(start, start + oldName.length(), newName);
                start += newName.length();
            }
        }
        return modified.toString();
    }
}

