/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation;

import java.awt.geom.AffineTransform;
import java.text.FieldPosition;
import java.text.NumberFormat;
import javax.vecmath.GMatrix;
import org.geotools.resources.Utilities;
import org.geotools.resources.cts.Resources;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.operation.Matrix;
import org.opengis.spatialschema.geometry.Envelope;
import org.opengis.spatialschema.geometry.MismatchedDimensionException;

public class GeneralMatrix
extends GMatrix
implements Matrix {
    private static final long serialVersionUID = 2315556279279988442L;
    static final /* synthetic */ boolean $assertionsDisabled;

    public GeneralMatrix(int size) {
        super(size, size);
    }

    public GeneralMatrix(int numRow, int numCol) {
        super(numRow, numCol);
    }

    public GeneralMatrix(int numRow, int numCol, double[] matrix) {
        super(numRow, numCol, matrix);
        if (numRow * numCol != matrix.length) {
            throw new IllegalArgumentException(String.valueOf(matrix.length));
        }
    }

    public GeneralMatrix(double[][] matrix) throws IllegalArgumentException {
        super(matrix.length, matrix.length != 0 ? matrix[0].length : 0);
        int numRow = this.getNumRow();
        int numCol = this.getNumCol();
        for (int j = 0; j < numRow; ++j) {
            if (matrix[j].length != numCol) {
                throw new IllegalArgumentException(Resources.format(97));
            }
            this.setRow(j, matrix[j]);
        }
    }

    public GeneralMatrix(Matrix matrix) {
        this(matrix.getNumRow(), matrix.getNumCol());
        int height = this.getNumRow();
        int width = this.getNumCol();
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                this.setElement(j, i, matrix.getElement(j, i));
            }
        }
    }

    public GeneralMatrix(GMatrix matrix) {
        super(matrix);
    }

    public GeneralMatrix(AffineTransform transform) {
        super(3, 3, new double[]{transform.getScaleX(), transform.getShearX(), transform.getTranslateX(), transform.getShearY(), transform.getScaleY(), transform.getTranslateY(), 0.0, 0.0, 1.0});
        if (!$assertionsDisabled && !this.isAffine()) {
            throw new AssertionError((Object)this);
        }
    }

    public GeneralMatrix(Envelope srcRegion, Envelope dstRegion) {
        super(dstRegion.getDimension() + 1, srcRegion.getDimension() + 1);
        int srcDim = srcRegion.getDimension();
        int dstDim = dstRegion.getDimension();
        int i = Math.min(srcDim, dstDim);
        while (--i >= 0) {
            double scale = dstRegion.getLength(i) / srcRegion.getLength(i);
            double translate = dstRegion.getMinimum(i) - srcRegion.getMinimum(i) * scale;
            this.setElement(i, i, scale);
            this.setElement(i, srcDim, translate);
        }
        this.setElement(dstDim, srcDim, 1.0);
        if (!$assertionsDisabled && srcDim == dstDim && !this.isAffine()) {
            throw new AssertionError((Object)this);
        }
    }

    public GeneralMatrix(AxisDirection[] srcAxis, AxisDirection[] dstAxis) {
        this(null, srcAxis, null, dstAxis, false);
    }

    public GeneralMatrix(Envelope srcRegion, AxisDirection[] srcAxis, Envelope dstRegion, AxisDirection[] dstAxis) {
        this(srcRegion, srcAxis, dstRegion, dstAxis, true);
    }

    private GeneralMatrix(Envelope srcRegion, AxisDirection[] srcAxis, Envelope dstRegion, AxisDirection[] dstAxis, boolean validRegions) {
        super(dstAxis.length + 1, srcAxis.length + 1);
        if (validRegions) {
            GeneralMatrix.ensureDimensionMatch("srcRegion", srcRegion, srcAxis.length);
            GeneralMatrix.ensureDimensionMatch("dstRegion", dstRegion, dstAxis.length);
        }
        this.setZero();
        for (int dstIndex = 0; dstIndex < dstAxis.length; ++dstIndex) {
            boolean hasFound = false;
            AxisDirection dstAxe = dstAxis[dstIndex];
            AxisDirection search = dstAxe.absolute();
            for (int srcIndex = 0; srcIndex < srcAxis.length; ++srcIndex) {
                AxisDirection srcAxe = srcAxis[srcIndex];
                if (!search.equals(srcAxe.absolute())) continue;
                if (hasFound) {
                    throw new IllegalArgumentException(Resources.format(73, srcAxe.name(), dstAxe.name()));
                }
                hasFound = true;
                boolean normal = srcAxe.equals(dstAxe);
                double scale = normal ? 1.0 : -1.0;
                double translate = 0.0;
                if (validRegions) {
                    translate = normal ? dstRegion.getMinimum(dstIndex) : dstRegion.getMaximum(dstIndex);
                    translate -= srcRegion.getMinimum(srcIndex) * (scale *= dstRegion.getLength(dstIndex) / srcRegion.getLength(srcIndex));
                }
                this.setElement(dstIndex, srcIndex, scale);
                this.setElement(dstIndex, srcAxis.length, translate);
            }
            if (hasFound) continue;
            throw new IllegalArgumentException(Resources.format(111, dstAxis[dstIndex].name()));
        }
        this.setElement(dstAxis.length, srcAxis.length, 1.0);
        if (!$assertionsDisabled && srcAxis.length == dstAxis.length && !this.isAffine()) {
            throw new AssertionError((Object)this);
        }
    }

    private static void ensureDimensionMatch(String name, Envelope envelope, int dimension) throws MismatchedDimensionException {
        int dim = envelope.getDimension();
        if (dimension != dim) {
            throw new MismatchedDimensionException(Resources.format(99, name, new Integer(dim), new Integer(dimension)));
        }
    }

    public static double[][] getElements(Matrix matrix) {
        if (matrix instanceof GeneralMatrix) {
            return ((GeneralMatrix)matrix).getElements();
        }
        int numCol = matrix.getNumCol();
        double[][] rows = new double[matrix.getNumRow()][];
        for (int j = 0; j < rows.length; ++j) {
            double[] row = new double[numCol];
            rows[j] = row;
            for (int i = 0; i < row.length; ++i) {
                row[i] = matrix.getElement(j, i);
            }
        }
        return rows;
    }

    public final double[][] getElements() {
        int numCol = this.getNumCol();
        double[][] rows = new double[this.getNumRow()][];
        for (int j = 0; j < rows.length; ++j) {
            rows[j] = new double[numCol];
            this.getRow(j, rows[j]);
        }
        return rows;
    }

    public final boolean isAffine() {
        int dimension = this.getNumRow();
        if (dimension != this.getNumCol()) {
            return false;
        }
        --dimension;
        for (int i = 0; i <= dimension; ++i) {
            if (this.getElement(dimension, i) == (double)(i == dimension ? 1 : 0)) continue;
            return false;
        }
        return true;
    }

    public final boolean isIdentity() {
        int numCol;
        int numRow = this.getNumRow();
        if (numRow != (numCol = this.getNumCol())) {
            return false;
        }
        for (int j = 0; j < numRow; ++j) {
            for (int i = 0; i < numCol; ++i) {
                if (this.getElement(j, i) == (double)(i == j ? 1 : 0)) continue;
                return false;
            }
        }
        if (!$assertionsDisabled && !this.isAffine()) {
            throw new AssertionError((Object)this);
        }
        return true;
    }

    public final AffineTransform toAffineTransform2D() throws IllegalStateException {
        int check = this.getNumRow();
        if (check != 3 || (check = this.getNumCol()) != 3) {
            throw new IllegalStateException(Resources.format(108, new Integer(check - 1)));
        }
        if (this.isAffine()) {
            return new AffineTransform(this.getElement(0, 0), this.getElement(1, 0), this.getElement(0, 1), this.getElement(1, 1), this.getElement(0, 2), this.getElement(1, 2));
        }
        throw new IllegalStateException(Resources.format(106));
    }

    public String toString() {
        int numRow = this.getNumRow();
        int numCol = this.getNumCol();
        StringBuffer buffer = new StringBuffer();
        int columnWidth = 12;
        String lineSeparator = System.getProperty("line.separator", "\n");
        FieldPosition dummy = new FieldPosition(0);
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMinimumFractionDigits(6);
        format.setMaximumFractionDigits(6);
        for (int j = 0; j < numRow; ++j) {
            for (int i = 0; i < numCol; ++i) {
                int position = buffer.length();
                buffer = format.format(this.getElement(j, i), buffer, dummy);
                buffer.insert(position, Utilities.spaces(12 - (buffer.length() - position)));
            }
            buffer.append(lineSeparator);
        }
        return buffer.toString();
    }

    static {
        $assertionsDisabled = !GeneralMatrix.class.desiredAssertionStatus();
    }
}

