/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import java.util.Collection;
import org.geotools.referencing.operation.projection.Orthographic;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.geotools.resources.cts.Resources;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;

public class OrthographicPolar
extends Orthographic {
    private final boolean northPole;
    static final /* synthetic */ boolean $assertionsDisabled;

    OrthographicPolar(ParameterValueGroup parameters, Collection expected) throws ParameterNotFoundException {
        super(parameters, expected);
        if (!$assertionsDisabled && !(Math.abs(Math.abs(this.latitudeOfOrigin) - 1.5707963267948966) < 1.0E-6)) {
            throw new AssertionError(this.latitudeOfOrigin);
        }
        this.northPole = this.latitudeOfOrigin > 0.0;
        double d = this.latitudeOfOrigin = this.northPole ? 1.5707963267948966 : -1.5707963267948966;
        if (!$assertionsDisabled && !this.isSpherical) {
            throw new AssertionError();
        }
    }

    protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        if (Math.abs(y - this.latitudeOfOrigin) - 1.0E-6 > 1.5707963267948966) {
            throw new ProjectionException(Resources.format(118));
        }
        double cosphi = Math.cos(y);
        double coslam = Math.cos(x);
        if (this.northPole) {
            coslam = -coslam;
        }
        y = cosphi * coslam;
        x = cosphi * Math.sin(x);
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double rho = Math.sqrt(x * x + y * y);
        double sinc = rho;
        if (sinc > 1.0) {
            if (sinc - 1.0 > 1.0E-6) {
                throw new ProjectionException(Resources.format(118));
            }
            sinc = 1.0;
        }
        if (rho <= 1.0E-6) {
            y = this.latitudeOfOrigin;
            x = 0.0;
        } else {
            double phi;
            if (this.northPole) {
                y = -y;
                phi = Math.acos(sinc);
            } else {
                phi = -Math.acos(sinc);
            }
            x = Math.atan2(x, y);
            y = phi;
        }
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    static {
        $assertionsDisabled = !OrthographicPolar.class.desiredAssertionStatus();
    }
}

