/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.List;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.geotools.referencing.operation.projection.Stereographic;
import org.geotools.resources.cts.Resources;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;

public class StereographicPolar
extends Stereographic {
    private final double k0;
    protected double latitudeTrueScale;
    protected final boolean southPole;
    static /* synthetic */ Class class$org$geotools$referencing$operation$projection$StereographicPolar;

    protected StereographicPolar(ParameterValueGroup parameters, Collection expected, double latitudeOfOrigin, short stereoType) throws ParameterNotFoundException {
        super(parameters, expected);
        this.stereoType = stereoType;
        if (!Double.isNaN(latitudeOfOrigin)) {
            this.latitudeOfOrigin = latitudeOfOrigin;
        }
        this.southPole = this.latitudeOfOrigin < 0.0;
        this.latitudeOfOrigin = this.southPole ? -1.5707963267948966 : 1.5707963267948966;
        this.latitudeTrueScale = StereographicPolar.doubleValue(expected, Stereographic.Provider_Polar_B.LATITUDE_TRUE_SCALE, parameters);
        if (Double.isNaN(this.latitudeTrueScale)) {
            this.latitudeTrueScale = this.latitudeOfOrigin;
        }
        StereographicPolar.ensureLatitudeInRange(Stereographic.Provider_Polar_B.LATITUDE_TRUE_SCALE, this.latitudeTrueScale, true);
        if (Math.abs(Math.abs(this.latitudeTrueScale) - 1.5707963267948966) >= 1.0E-6) {
            double latTrueScale = this.southPole ? -this.latitudeTrueScale : this.latitudeTrueScale;
            double t = Math.sin(latTrueScale);
            this.k0 = this.msfn(t, Math.cos(latTrueScale)) / this.tsfn(latTrueScale, t);
        } else {
            this.k0 = 2.0 / Math.sqrt(Math.pow(1.0 + this.excentricity, 1.0 + this.excentricity) * Math.pow(1.0 - this.excentricity, 1.0 - this.excentricity));
        }
    }

    protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double sinlat = Math.sin(y);
        double coslon = Math.cos(x);
        double sinlon = Math.sin(x);
        if (this.southPole) {
            double rho = this.k0 * this.tsfn(-y, -sinlat);
            x = rho * sinlon;
            y = rho * coslon;
        } else {
            double rho = this.k0 * this.tsfn(y, sinlat);
            x = rho * sinlon;
            y = -rho * coslon;
        }
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double phi;
        double rho;
        block3: {
            rho = Math.sqrt(x * x + y * y);
            if (this.southPole) {
                y = -y;
            }
            double t = rho / this.k0;
            double halfe = this.excentricity / 2.0;
            double phi0 = 0.0;
            int i = 15;
            do {
                double esinphi;
                if (Math.abs((phi = 1.5707963267948966 - 2.0 * Math.atan(t * Math.pow((1.0 - (esinphi = this.excentricity * Math.sin(phi0))) / (1.0 + esinphi), halfe))) - phi0) < 1.0E-10) break block3;
                phi0 = phi;
            } while (--i >= 0);
            throw new ProjectionException(Resources.format(109));
        }
        x = Math.abs(rho) < 1.0E-6 ? 0.0 : Math.atan2(x, -y);
        y = this.southPole ? -phi : phi;
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    public ParameterValueGroup getParameterValues() {
        ParameterValueGroup values = super.getParameterValues();
        switch (this.stereoType) {
            case 3: 
            case 4: 
            case 5: {
                List expected = this.getParameterDescriptors().descriptors();
                StereographicPolar.set(expected, Stereographic.Provider_Polar_B.LATITUDE_TRUE_SCALE, values, this.latitudeTrueScale);
            }
        }
        return values;
    }

    public int hashCode() {
        long code = Double.doubleToLongBits(this.k0);
        return ((int)code ^ (int)(code >>> 32)) + 37 * super.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            StereographicPolar that = (StereographicPolar)object;
            return this.southPole == that.southPole && StereographicPolar.equals(this.k0, that.k0) && StereographicPolar.equals(this.latitudeTrueScale, that.latitudeTrueScale);
        }
        return false;
    }

    static final class Series
    extends StereographicPolar {
        private final double A;
        private final double B;
        private double C;
        private double D;
        private final double k0;
        static final /* synthetic */ boolean $assertionsDisabled;

        protected Series(ParameterValueGroup parameters, Collection expected, double latitudeOfOrigin, short stereoType) throws ParameterNotFoundException {
            super(parameters, expected, latitudeOfOrigin, stereoType);
            double e4 = this.excentricitySquared * this.excentricitySquared;
            double e6 = this.excentricitySquared * this.excentricitySquared * this.excentricitySquared;
            double e8 = this.excentricitySquared * this.excentricitySquared * this.excentricitySquared * this.excentricitySquared;
            this.C = 7.0 * e6 / 120.0 + 81.0 * e8 / 1120.0;
            this.D = 4279.0 * e8 / 161280.0;
            this.A = this.excentricitySquared / 2.0 + 5.0 * e4 / 24.0 + e6 / 12.0 + 13.0 * e8 / 360.0 - this.C;
            this.B = 2.0 * (7.0 * e4 / 48.0 + 29.0 * e6 / 240.0 + 811.0 * e8 / 11520.0) - 4.0 * this.D;
            this.C *= 4.0;
            this.D *= 8.0;
            if (Math.abs(Math.abs(this.latitudeTrueScale) - 1.5707963267948966) >= 1.0E-6) {
                double latTrueScale = this.southPole ? -this.latitudeTrueScale : this.latitudeTrueScale;
                double t = Math.sin(latTrueScale);
                this.k0 = this.msfn(t, Math.cos(latTrueScale)) * Math.sqrt(Math.pow(1.0 + this.excentricity, 1.0 + this.excentricity) * Math.pow(1.0 - this.excentricity, 1.0 - this.excentricity)) / (2.0 * this.tsfn(latTrueScale, t));
            } else {
                this.k0 = 1.0;
            }
        }

        protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
            if (!$assertionsDisabled && (ptDst = super.inverseTransformNormalized(x, y, ptDst)) == null) {
                throw new AssertionError();
            }
            double rho = Math.sqrt(x * x + y * y);
            if (this.southPole) {
                y = -y;
            }
            double t = rho / this.k0 * Math.sqrt(Math.pow(1.0 + this.excentricity, 1.0 + this.excentricity) * Math.pow(1.0 - this.excentricity, 1.0 - this.excentricity)) / 2.0;
            double chi = 1.5707963267948966 - 2.0 * Math.atan(t);
            x = Math.abs(rho) < 1.0E-6 ? 0.0 : Math.atan2(x, -y);
            double sin2chi = Math.sin(2.0 * chi);
            double cos2chi = Math.cos(2.0 * chi);
            y = chi + sin2chi * (this.A + cos2chi * (this.B + cos2chi * (this.C + this.D * cos2chi)));
            double d = y = this.southPole ? -y : y;
            if (!$assertionsDisabled && !(Math.abs(ptDst.getX() - x) <= 1.0E-6)) {
                throw new AssertionError(x);
            }
            if (!$assertionsDisabled && !(Math.abs(ptDst.getY() - y) <= 1.0E-6)) {
                throw new AssertionError(y);
            }
            if (ptDst != null) {
                ptDst.setLocation(x, y);
                return ptDst;
            }
            return new Point2D.Double(x, y);
        }

        static {
            $assertionsDisabled = !(class$org$geotools$referencing$operation$projection$StereographicPolar == null ? (class$org$geotools$referencing$operation$projection$StereographicPolar = StereographicPolar.class$("org.geotools.referencing.operation.projection.StereographicPolar")) : class$org$geotools$referencing$operation$projection$StereographicPolar).desiredAssertionStatus();
        }
    }

    static final class Spherical
    extends StereographicPolar {
        private final double k0;
        static final /* synthetic */ boolean $assertionsDisabled;

        protected Spherical(ParameterValueGroup parameters, Collection expected, double latitudeOfOrigin, short stereoType) throws ParameterNotFoundException {
            super(parameters, expected, latitudeOfOrigin, stereoType);
            if (!$assertionsDisabled && !this.isSpherical) {
                throw new AssertionError();
            }
            this.k0 = Math.abs(Math.abs(this.latitudeTrueScale) - 1.5707963267948966) >= 1.0E-6 ? (this.southPole ? 1.0 - Math.sin(this.latitudeTrueScale) : 1.0 + Math.sin(this.latitudeTrueScale)) : 2.0;
        }

        protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
            if (!$assertionsDisabled && (ptDst = super.transformNormalized(x, y, ptDst)) == null) {
                throw new AssertionError();
            }
            double coslat = Math.cos(y);
            double sinlat = Math.sin(y);
            double coslon = Math.cos(x);
            double sinlon = Math.sin(x);
            if (this.southPole) {
                if (Math.abs(1.0 - sinlat) < 1.0E-6) {
                    throw new ProjectionException(Resources.format(127));
                }
                double f = this.k0 * coslat / (1.0 - sinlat);
                x = f * sinlon;
                y = f * coslon;
            } else {
                if (Math.abs(1.0 + sinlat) < 1.0E-6) {
                    throw new ProjectionException(Resources.format(127));
                }
                double f = this.k0 * coslat / (1.0 + sinlat);
                x = f * sinlon;
                y = -f * coslon;
            }
            if (!$assertionsDisabled && !(Math.abs(ptDst.getX() - x) <= 1.0E-6 * this.globalScale)) {
                throw new AssertionError(x);
            }
            if (!$assertionsDisabled && !(Math.abs(ptDst.getY() - y) <= 1.0E-6 * this.globalScale)) {
                throw new AssertionError(y);
            }
            if (ptDst != null) {
                ptDst.setLocation(x, y);
                return ptDst;
            }
            return new Point2D.Double(x, y);
        }

        protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
            if (!$assertionsDisabled && (ptDst = super.inverseTransformNormalized(x, y, ptDst)) == null) {
                throw new AssertionError();
            }
            double rho = Math.sqrt(x * x + y * y);
            if (!this.southPole) {
                y = -y;
            }
            double d = x = Math.abs(x) < 1.0E-6 && Math.abs(y) < 1.0E-6 ? 0.0 : Math.atan2(x, y);
            if (Math.abs(rho) < 1.0E-6) {
                y = this.latitudeOfOrigin;
            } else {
                double c = 2.0 * Math.atan(rho / this.k0);
                double cosc = Math.cos(c);
                double d2 = y = this.southPole ? Math.asin(-cosc) : Math.asin(cosc);
            }
            if (!$assertionsDisabled && !(Math.abs(ptDst.getX() - x) <= 1.0E-6)) {
                throw new AssertionError(x);
            }
            if (!$assertionsDisabled && !(Math.abs(ptDst.getY() - y) <= 1.0E-6)) {
                throw new AssertionError(y);
            }
            if (ptDst != null) {
                ptDst.setLocation(x, y);
                return ptDst;
            }
            return new Point2D.Double(x, y);
        }

        static {
            $assertionsDisabled = !(class$org$geotools$referencing$operation$projection$StereographicPolar == null ? (class$org$geotools$referencing$operation$projection$StereographicPolar = StereographicPolar.class$("org.geotools.referencing.operation.projection.StereographicPolar")) : class$org$geotools$referencing$operation$projection$StereographicPolar).desiredAssertionStatus();
        }
    }
}

