/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Polygon;
import org.geotools.renderer.lite.LiteCoordinateSequence;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class Decimator {
    private double spanx = -1.0;
    private double spany = -1.0;

    public Decimator(MathTransform screenToWorld) {
        if (screenToWorld != null) {
            double[] original = new double[]{0.0, 0.0, 1.0, 1.0};
            double[] coords = new double[4];
            try {
                screenToWorld.transform(original, 0, coords, 0, 2);
            }
            catch (TransformException e) {
                return;
            }
            this.spanx = Math.abs(coords[0] - coords[2]);
            this.spany = Math.abs(coords[1] - coords[3]);
        } else {
            this.spanx = 1.0;
            this.spany = 1.0;
        }
    }

    public void decimate(Geometry geom) {
        block6: {
            block7: {
                block5: {
                    if (this.spanx == -1.0) {
                        return;
                    }
                    if (geom instanceof MultiPoint) {
                        return;
                    }
                    if (!(geom instanceof GeometryCollection)) break block5;
                    GeometryCollection collection = (GeometryCollection)geom;
                    for (int i = 0; i < collection.getNumGeometries(); ++i) {
                        this.decimate(collection.getGeometryN(i));
                    }
                    break block6;
                }
                if (!(geom instanceof LineString)) break block7;
                LineString line = (LineString)geom;
                LiteCoordinateSequence seq = (LiteCoordinateSequence)line.getCoordinateSequence();
                if (this.decimateOnEnvelope((Geometry)line, seq)) {
                    return;
                }
                this.decimate(seq);
                break block6;
            }
            if (!(geom instanceof Polygon)) break block6;
            Polygon line = (Polygon)geom;
            this.decimate((Geometry)line.getExteriorRing());
            for (int i = 0; i < line.getNumInteriorRing(); ++i) {
                this.decimate((Geometry)line.getInteriorRingN(i));
            }
        }
    }

    private boolean decimateOnEnvelope(Geometry geom, LiteCoordinateSequence seq) {
        Envelope env = geom.getEnvelopeInternal();
        if (env.getWidth() <= this.spanx && env.getHeight() <= this.spany) {
            double[] coords = seq.getArray();
            int dim = seq.getDimension();
            double[] newcoords = new double[dim * 2];
            for (int i = 0; i < dim; ++i) {
                newcoords[i] = coords[i];
                newcoords[dim + i] = coords[coords.length - dim + i];
            }
            seq.setArray(coords);
            return true;
        }
        return false;
    }

    private void decimate(LiteCoordinateSequence seq) {
        double[] coords = seq.getArray();
        int numDoubles = coords.length;
        int dim = seq.getDimension();
        int readDoubles = 0;
        for (int currentDoubles = 0; currentDoubles < coords.length; currentDoubles += dim) {
            if (currentDoubles >= dim && currentDoubles < coords.length - 1) {
                double prevx = coords[readDoubles - dim];
                double currx = coords[currentDoubles];
                double diffx = Math.abs(prevx - currx);
                double prevy = coords[readDoubles - dim + 1];
                double curry = coords[currentDoubles + 1];
                double diffy = Math.abs(prevy - curry);
                if (!(diffx > this.spanx) && !(diffy > this.spany)) continue;
                readDoubles = this.copyCoordinate(coords, dim, readDoubles, currentDoubles);
                continue;
            }
            readDoubles = this.copyCoordinate(coords, dim, readDoubles, currentDoubles);
        }
        double[] newCoords = new double[readDoubles];
        System.arraycopy(coords, 0, newCoords, 0, readDoubles);
        seq.setArray(newCoords);
    }

    private int copyCoordinate(double[] coords, int dimension, int readDoubles, int currentDoubles) {
        for (int i = 0; i < dimension; ++i) {
            coords[readDoubles + i] = coords[currentDoubles + i];
        }
        return readDoubles += dimension;
    }
}

