/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLDecoder;

public class TestData {
    public static final BufferedReader getReader(Class caller, String name) throws IOException {
        URL url = TestData.getResource(caller, name);
        if (url == null) {
            return null;
        }
        return new BufferedReader(new InputStreamReader(url.openStream()));
    }

    public static final BufferedReader getReader(Object host, String name) throws IOException {
        return TestData.getReader(host.getClass(), name);
    }

    public static final URL getResource(Class caller, String name) {
        name = name == null ? "test-data" : "test-data/" + name;
        return caller.getResource(name);
    }

    public static final URL getResource(Object caller, String name) {
        return TestData.getResource(caller.getClass(), name);
    }

    public static final File file(Object caller, String path) throws IOException {
        File file;
        URL url = TestData.getResource(caller, path);
        if (url != null && (file = new File(URLDecoder.decode(url.getFile(), "UTF-8"))).exists()) {
            return file;
        }
        throw new FileNotFoundException("Could not locate test-data: " + path);
    }

    public static final File file(Class caller, String path) throws IOException {
        File file;
        URL url = TestData.getResource(caller, path);
        if (url != null && (file = new File(URLDecoder.decode(url.getFile(), "UTF-8"))).exists()) {
            return file;
        }
        throw new FileNotFoundException("Could not locate test-data: " + path);
    }

    public static final File temp(Object caller, String name) throws IOException {
        File testData = TestData.file(caller, null);
        int split = name.lastIndexOf(46);
        String prefix = split == -1 ? name : name.substring(0, split);
        String suffix = split == -1 ? null : name.substring(split + 1);
        File tmp = File.createTempFile(prefix, "." + suffix, testData);
        tmp.deleteOnExit();
        return tmp;
    }
}

