/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.geotools.filter.Filter;
import org.geotools.resources.Utilities;
import org.geotools.styling.Graphic;
import org.geotools.styling.Rule;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.Symbolizer;
import org.opengis.util.Cloneable;

public class RuleImpl
implements Rule,
Cloneable {
    private List symbolizers = new ArrayList();
    private List graphics = new ArrayList();
    private String name = "name";
    private String title = "title";
    private String abstractStr = "Abstract";
    private Filter filter = null;
    private boolean hasElseFilter = false;
    private double maxScaleDenominator = Double.POSITIVE_INFINITY;
    private double minScaleDenominator = 0.0;

    protected RuleImpl() {
    }

    protected RuleImpl(Symbolizer[] symbolizers) {
        this.symbolizers.addAll(Arrays.asList(symbolizers));
    }

    public Graphic[] getLegendGraphic() {
        return this.graphics.toArray(new Graphic[0]);
    }

    public void addLegendGraphic(Graphic graphic) {
        this.graphics.add(graphic);
    }

    public void setLegendGraphic(Graphic[] graphics) {
        this.graphics.clear();
        for (int i = 0; i < graphics.length; ++i) {
            this.addLegendGraphic(graphics[i]);
        }
    }

    public void addSymbolizer(Symbolizer symb) {
        this.symbolizers.add(symb);
    }

    public void setSymbolizers(Symbolizer[] syms) {
        this.symbolizers.clear();
        for (int i = 0; i < syms.length; ++i) {
            this.addSymbolizer(syms[i]);
        }
    }

    public Symbolizer[] getSymbolizers() {
        return this.symbolizers.toArray(new Symbolizer[this.symbolizers.size()]);
    }

    public String getAbstract() {
        return this.abstractStr;
    }

    public void setAbstract(String abstractStr) {
        this.abstractStr = abstractStr;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public boolean hasElseFilter() {
        return this.hasElseFilter;
    }

    public void setIsElseFilter(boolean flag) {
        this.hasElseFilter = flag;
    }

    public void setHasElseFilter() {
        this.hasElseFilter = true;
    }

    public double getMaxScaleDenominator() {
        return this.maxScaleDenominator;
    }

    public void setMaxScaleDenominator(double maxScaleDenominator) {
        this.maxScaleDenominator = maxScaleDenominator;
    }

    public double getMinScaleDenominator() {
        return this.minScaleDenominator;
    }

    public void setMinScaleDenominator(double minScaleDenominator) {
        this.minScaleDenominator = minScaleDenominator;
    }

    public void accept(StyleVisitor visitor) {
        visitor.visit(this);
    }

    public Object clone() {
        try {
            RuleImpl clone = (RuleImpl)super.clone();
            clone.graphics = new ArrayList();
            clone.symbolizers = new ArrayList();
            Graphic[] legends = new Graphic[this.graphics.size()];
            for (int i = 0; i < legends.length; ++i) {
                Graphic legend = (Graphic)this.graphics.get(i);
                legends[i] = (Graphic)((Cloneable)legend).clone();
            }
            clone.setLegendGraphic(legends);
            Symbolizer[] symbArray = new Symbolizer[this.symbolizers.size()];
            for (int i = 0; i < symbArray.length; ++i) {
                Symbolizer symb = (Symbolizer)this.symbolizers.get(i);
                symbArray[i] = (Symbolizer)((Cloneable)symb).clone();
            }
            clone.setSymbolizers(symbArray);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("This will never happen", e);
        }
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        result = 1000003 * result + ((Object)this.symbolizers).hashCode();
        if (this.graphics != null) {
            result = 1000003 * result + ((Object)this.graphics).hashCode();
        }
        if (this.name != null) {
            result = 1000003 * result + this.name.hashCode();
        }
        if (this.title != null) {
            result = 1000003 * result + this.title.hashCode();
        }
        if (this.abstractStr != null) {
            result = 1000003 * result + this.abstractStr.hashCode();
        }
        if (this.filter != null) {
            result = 1000003 * result + this.filter.hashCode();
        }
        result = 1000003 * result + (this.hasElseFilter ? 1 : 0);
        long temp = Double.doubleToLongBits(this.maxScaleDenominator);
        result = 1000003 * result + (int)(temp >>> 32);
        result = 1000003 * result + (int)(temp & 0xFFFFFFFFFFFFFFFFL);
        temp = Double.doubleToLongBits(this.minScaleDenominator);
        result = 1000003 * result + (int)(temp >>> 32);
        result = 1000003 * result + (int)(temp & 0xFFFFFFFFFFFFFFFFL);
        return result;
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth instanceof RuleImpl) {
            RuleImpl other = (RuleImpl)oth;
            return Utilities.equals(this.name, other.name) && Utilities.equals(this.title, other.title) && Utilities.equals(this.abstractStr, other.abstractStr) && Utilities.equals(this.filter, other.filter) && this.hasElseFilter == other.hasElseFilter && Utilities.equals(this.graphics, other.graphics) && Utilities.equals(this.symbolizers, other.symbolizers) && Double.doubleToLongBits(this.maxScaleDenominator) == Double.doubleToLongBits(other.maxScaleDenominator) && Double.doubleToLongBits(this.minScaleDenominator) == Double.doubleToLongBits(other.minScaleDenominator);
        }
        return false;
    }
}

