/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.geotools.resources.Utilities;
import org.geotools.util.AbstractInternationalString;
import org.opengis.util.InternationalString;

public abstract class GenericName
implements org.opengis.util.GenericName,
Serializable {
    private static final long serialVersionUID = 8685047583179337259L;
    public static final char DEFAULT_SEPARATOR = ':';

    protected GenericName() {
    }

    static CharSequence validate(CharSequence name) {
        return name == null || name instanceof InternationalString ? name : ((Object)name).toString();
    }

    public abstract org.opengis.util.GenericName getScope();

    public abstract List getParsedNames();

    char getSeparator() {
        return ':';
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        List parsedNames = this.getParsedNames();
        char separator = this.getSeparator();
        Iterator it = parsedNames.iterator();
        while (it.hasNext()) {
            if (buffer.length() != 0) {
                buffer.append(separator);
            }
            buffer.append(it.next());
        }
        return buffer.toString();
    }

    public InternationalString toInternationalString() {
        return new International(this.getParsedNames(), this.getSeparator());
    }

    public int compareTo(Object object) {
        org.opengis.util.GenericName that = (org.opengis.util.GenericName)object;
        Iterator thisNames = this.getParsedNames().iterator();
        Iterator thatNames = that.getParsedNames().iterator();
        while (thisNames.hasNext()) {
            if (!thatNames.hasNext()) {
                return 1;
            }
            Comparable thisNext = (Comparable)thisNames.next();
            Comparable thatNext = (Comparable)thatNames.next();
            if (thisNext == this && thatNext == that) {
                throw new IllegalStateException();
            }
            int compare = thisNext.compareTo(thatNext);
            if (compare == 0) continue;
            return compare;
        }
        return thatNames.hasNext() ? -1 : 0;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            GenericName that = (GenericName)object;
            return Utilities.equals(this.getParsedNames(), that.getParsedNames()) && this.getSeparator() == that.getSeparator();
        }
        return false;
    }

    public int hashCode() {
        return 0xF4C4EE2B ^ ((Object)this.getParsedNames()).hashCode();
    }

    private static final class International
    extends AbstractInternationalString
    implements Serializable {
        private static final long serialVersionUID = -4234089612436334148L;
        private final List parsedNames;
        private final char separator;

        public International(List parsedNames, char separator) {
            this.parsedNames = parsedNames;
            this.separator = separator;
        }

        public String toString(Locale locale) {
            StringBuffer buffer = new StringBuffer();
            Iterator it = this.parsedNames.iterator();
            while (it.hasNext()) {
                if (buffer.length() != 0) {
                    buffer.append(this.separator);
                }
                buffer.append(((org.opengis.util.GenericName)it.next()).toInternationalString().toString(locale));
            }
            return buffer.toString();
        }

        public boolean equals(Object object) {
            if (object != null && object.getClass().equals(this.getClass())) {
                International that = (International)object;
                return Utilities.equals(this.parsedNames, that.parsedNames) && this.separator == that.separator;
            }
            return false;
        }

        public int hashCode() {
            return 0x3F8F99BC ^ ((Object)this.parsedNames).hashCode();
        }
    }
}

