/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.handlers.xsi;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.geotools.xml.SchemaFactory;
import org.geotools.xml.XSIElementHandler;
import org.geotools.xml.handlers.xsi.AttributeGroupHandler;
import org.geotools.xml.handlers.xsi.AttributeHandler;
import org.geotools.xml.handlers.xsi.ComplexTypeHandler;
import org.geotools.xml.handlers.xsi.ElementTypeHandler;
import org.geotools.xml.handlers.xsi.GroupHandler;
import org.geotools.xml.handlers.xsi.ImportHandler;
import org.geotools.xml.handlers.xsi.IncludeHandler;
import org.geotools.xml.handlers.xsi.RedefineHandler;
import org.geotools.xml.handlers.xsi.SimpleTypeHandler;
import org.geotools.xml.schema.All;
import org.geotools.xml.schema.Attribute;
import org.geotools.xml.schema.AttributeGroup;
import org.geotools.xml.schema.Choice;
import org.geotools.xml.schema.ComplexType;
import org.geotools.xml.schema.Element;
import org.geotools.xml.schema.ElementGrouping;
import org.geotools.xml.schema.Facet;
import org.geotools.xml.schema.Group;
import org.geotools.xml.schema.Schema;
import org.geotools.xml.schema.Sequence;
import org.geotools.xml.schema.SimpleType;
import org.geotools.xml.schema.Type;
import org.geotools.xml.xsi.XSISimpleTypes;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SchemaHandler
extends XSIElementHandler {
    public static final String namespaceURI = "http://www.w3.org/2001/XMLSchema";
    public static final String LOCALNAME = "schema";
    private String id;
    private String prefix;
    private URI targetNamespace;
    private String version;
    private boolean elementFormDefault;
    private boolean attributeFormDefault;
    private int finalDefault;
    private int blockDefault;
    private List includes;
    private List imports;
    private List redefines;
    private List attributes;
    private List attributeGroups;
    private List complexTypes;
    private List elements;
    private List groups;
    private List simpleTypes;
    private URI uri;
    private Schema schema = null;
    private HashMap prefixCache;

    public int hashCode() {
        return LOCALNAME.hashCode() * (this.id == null ? 1 : this.id.hashCode()) * (this.version == null ? 1 : this.version.hashCode()) * (this.targetNamespace == null ? 1 : this.targetNamespace.hashCode());
    }

    public void startPrefixMapping(String pref, String uri1) {
        if (this.targetNamespace == null) {
            if (this.prefixCache == null) {
                this.prefixCache = new HashMap();
            }
            this.prefixCache.put(uri1, pref);
            if (this.uri == null && (pref == null || "".equals(pref))) {
                try {
                    this.uri = new URI(uri1);
                }
                catch (URISyntaxException e) {
                    logger.warning(e.getMessage());
                }
            }
        } else if (this.targetNamespace.equals(uri1.toString())) {
            this.prefix = pref;
        }
    }

    public void startElement(String namespaceURI1, String localName, Attributes atts) throws SAXException {
        String attributeFormDefault1;
        String targetNamespace1 = atts.getValue("", "targetNamespace");
        if (targetNamespace1 == null) {
            targetNamespace1 = atts.getValue(namespaceURI1, "targetNamespace");
        }
        try {
            this.targetNamespace = new URI(targetNamespace1);
        }
        catch (URISyntaxException e) {
            logger.warning(e.toString());
            throw new SAXException(e);
        }
        if (this.prefixCache != null && targetNamespace1 != null && !targetNamespace1.equals("")) {
            Iterator i = this.prefixCache.keySet().iterator();
            while (i != null && i.hasNext()) {
                String uriT = (String)i.next();
                if (!targetNamespace1.equals(uriT)) continue;
                this.prefix = (String)this.prefixCache.get(uriT);
                i = null;
            }
        }
        if ((attributeFormDefault1 = atts.getValue("", "attributeFormDefault")) == null) {
            attributeFormDefault1 = atts.getValue(namespaceURI1, "attributeFormDefault");
        }
        this.attributeFormDefault = "qualified".equalsIgnoreCase(attributeFormDefault1);
        String blockDefault1 = atts.getValue("", "blockDefault");
        if (blockDefault1 == null) {
            blockDefault1 = atts.getValue(namespaceURI1, "blockDefault");
        }
        this.blockDefault = ComplexTypeHandler.findBlock(blockDefault1);
        String elementFormDefault1 = atts.getValue("", "elementFormDefault");
        if (elementFormDefault1 == null) {
            elementFormDefault1 = atts.getValue(namespaceURI1, "elementFormDefault");
        }
        this.elementFormDefault = "qualified".equalsIgnoreCase(elementFormDefault1);
        String finalDefault1 = atts.getValue("", "finalDefault");
        if (finalDefault1 == null) {
            finalDefault1 = atts.getValue(namespaceURI1, "finalDefault");
        }
        this.finalDefault = SimpleTypeHandler.findFinal(finalDefault1);
        this.id = atts.getValue("", "id");
        if (this.id == null) {
            this.id = atts.getValue(namespaceURI1, "id");
        }
        this.version = atts.getValue("", "version");
        if (this.version == null) {
            this.version = atts.getValue(namespaceURI1, "version");
        }
    }

    public XSIElementHandler getHandler(String namespaceURI1, String localName) {
        if (namespaceURI.equalsIgnoreCase(namespaceURI1)) {
            if ("complexType".equalsIgnoreCase(localName)) {
                if (this.complexTypes == null) {
                    this.complexTypes = new LinkedList();
                }
                ComplexTypeHandler cth = new ComplexTypeHandler();
                this.complexTypes.add(cth);
                return cth;
            }
            if ("simpleType".equalsIgnoreCase(localName)) {
                if (this.simpleTypes == null) {
                    this.simpleTypes = new LinkedList();
                }
                SimpleTypeHandler sth = new SimpleTypeHandler();
                this.simpleTypes.add(sth);
                return sth;
            }
            if ("element".equalsIgnoreCase(localName)) {
                if (this.elements == null) {
                    this.elements = new LinkedList();
                }
                ElementTypeHandler eth = new ElementTypeHandler();
                this.elements.add(eth);
                return eth;
            }
            if ("attribute".equalsIgnoreCase(localName)) {
                if (this.attributes == null) {
                    this.attributes = new LinkedList();
                }
                AttributeHandler ah = new AttributeHandler();
                this.attributes.add(ah);
                return ah;
            }
            if ("include".equalsIgnoreCase(localName)) {
                if (this.includes == null) {
                    this.includes = new LinkedList();
                }
                IncludeHandler ih = new IncludeHandler();
                this.includes.add(ih);
                return ih;
            }
            if ("import".equalsIgnoreCase(localName)) {
                if (this.imports == null) {
                    this.imports = new LinkedList();
                }
                ImportHandler ih = new ImportHandler();
                this.imports.add(ih);
                return ih;
            }
            if ("group".equalsIgnoreCase(localName)) {
                if (this.groups == null) {
                    this.groups = new LinkedList();
                }
                GroupHandler gh = new GroupHandler();
                this.groups.add(gh);
                return gh;
            }
            if ("redefine".equalsIgnoreCase(localName)) {
                if (this.redefines == null) {
                    this.redefines = new LinkedList();
                }
                RedefineHandler rh = new RedefineHandler();
                this.redefines.add(rh);
                return rh;
            }
            if ("attributeGroup".equalsIgnoreCase(localName)) {
                if (this.attributeGroups == null) {
                    this.attributeGroups = new LinkedList();
                }
                AttributeGroupHandler agh = new AttributeGroupHandler();
                this.attributeGroups.add(agh);
                return agh;
            }
        }
        return null;
    }

    public String getLocalName() {
        return LOCALNAME;
    }

    protected Schema compress(URI thisURI) throws SAXException {
        TreeSet tmp;
        XSIElementHandler tt;
        Object t;
        HashSet<Object> cache;
        if (this.schema != null) {
            return this.schema;
        }
        if (this.uri == null) {
            this.uri = thisURI;
        } else if (thisURI != null) {
            this.uri = thisURI.resolve(this.uri);
        }
        if (this.prefix == null && this.prefixCache != null) {
            this.prefix = (String)this.prefixCache.get(this.targetNamespace);
        }
        Iterator it = null;
        if (this.includes != null) {
            it = this.includes.iterator();
            while (it.hasNext()) {
                IncludeHandler inc = (IncludeHandler)it.next();
                logger.finest("compressing include " + inc.getSchemaLocation());
                if (inc == null || inc.getSchemaLocation() == null) continue;
                URI incURI = null;
                if (thisURI == null) {
                    try {
                        incURI = new URI(inc.getSchemaLocation());
                    }
                    catch (URISyntaxException e) {
                        logger.warning(e.getMessage());
                    }
                } else {
                    incURI = thisURI.normalize().resolve(inc.getSchemaLocation());
                }
                Schema cs = SchemaFactory.getInstance(this.targetNamespace, incURI, logger.getLevel());
                this.uri = this.uri != null ? incURI.resolve(this.uri) : incURI;
                this.addSchema(cs);
            }
        }
        this.includes = null;
        if (this.imports != null) {
            LinkedList<Schema> imports1 = new LinkedList<Schema>();
            it = this.imports.iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                if (obj instanceof ImportHandler) {
                    ImportHandler imp = (ImportHandler)obj;
                    URI incURI = null;
                    if (imp.getSchemaLocation() != null) {
                        incURI = thisURI != null ? thisURI.normalize().resolve(imp.getSchemaLocation()) : imp.getSchemaLocation();
                    }
                    Schema cs = SchemaFactory.getInstance(imp.getNamespace(), incURI, logger.getLevel());
                    imports1.add(cs);
                    continue;
                }
                imports1.add((Schema)obj);
            }
            this.imports = imports1;
        }
        DefaultSchema schema1 = new DefaultSchema();
        schema1.attributeFormDefault = this.attributeFormDefault;
        schema1.elementFormDefault = this.elementFormDefault;
        schema1.finalDefault = this.finalDefault;
        schema1.blockDefault = this.blockDefault;
        schema1.id = this.id;
        schema1.prefix = this.prefix;
        schema1.targetNamespace = this.targetNamespace;
        schema1.version = this.version;
        schema1.uri = this.uri;
        if (this.imports != null) {
            TreeSet tmp2 = new TreeSet(SchemaComparator.getInstance());
            tmp2.addAll(this.imports);
            schema1.imports = tmp2.toArray(new Schema[tmp2.size()]);
        }
        if (this.simpleTypes != null) {
            it = this.simpleTypes.iterator();
            cache = new HashSet<Object>();
            while (it.hasNext()) {
                t = it.next();
                if (!(t instanceof SimpleTypeHandler)) continue;
                tt = (SimpleTypeHandler)t;
                cache.add(((SimpleTypeHandler)tt).compress(this));
                it.remove();
            }
            it = cache.iterator();
            while (it.hasNext()) {
                this.simpleTypes.add(it.next());
            }
            tmp = new TreeSet(SchemaComparator.getInstance());
            tmp.addAll(this.simpleTypes);
            schema1.simpleTypes = tmp.toArray(new SimpleType[tmp.size()]);
        }
        if (this.attributeGroups != null) {
            it = this.attributeGroups.iterator();
            cache = new HashSet();
            while (it.hasNext()) {
                t = it.next();
                if (!(t instanceof AttributeGroupHandler)) continue;
                tt = (AttributeGroupHandler)t;
                cache.add(((AttributeGroupHandler)tt).compress(this));
                it.remove();
            }
            it = cache.iterator();
            while (it.hasNext()) {
                this.attributeGroups.add(it.next());
            }
            tmp = new TreeSet(SchemaComparator.getInstance());
            tmp.addAll(this.attributeGroups);
            schema1.attributeGroups = tmp.toArray(new AttributeGroup[tmp.size()]);
        }
        if (this.attributes != null) {
            it = this.attributes.iterator();
            cache = new HashSet();
            while (it.hasNext()) {
                t = it.next();
                if (!(t instanceof AttributeHandler)) continue;
                tt = (AttributeHandler)t;
                cache.add(((AttributeHandler)tt).compress(this));
                it.remove();
            }
            it = cache.iterator();
            while (it.hasNext()) {
                this.attributes.add(it.next());
            }
            tmp = new TreeSet(SchemaComparator.getInstance());
            tmp.addAll(this.attributes);
            schema1.attributes = tmp.toArray(new Attribute[tmp.size()]);
        }
        if (this.complexTypes != null) {
            it = this.complexTypes.iterator();
            cache = new HashSet();
            while (it.hasNext()) {
                t = it.next();
                if (!(t instanceof ComplexTypeHandler)) continue;
                tt = (ComplexTypeHandler)t;
                cache.add(((ComplexTypeHandler)tt).compress(this));
                it.remove();
            }
            it = cache.iterator();
            while (it.hasNext()) {
                this.complexTypes.add(it.next());
            }
            tmp = new TreeSet(SchemaComparator.getInstance());
            tmp.addAll(this.complexTypes);
            schema1.complexTypes = tmp.toArray(new ComplexType[tmp.size()]);
        }
        if (this.elements != null) {
            it = this.elements.iterator();
            cache = new HashSet();
            while (it.hasNext()) {
                t = it.next();
                if (!(t instanceof ElementTypeHandler)) continue;
                tt = (ElementTypeHandler)t;
                cache.add(((ElementTypeHandler)tt).compress(this));
                it.remove();
            }
            it = cache.iterator();
            while (it.hasNext()) {
                this.elements.add(it.next());
            }
            tmp = new TreeSet(SchemaComparator.getInstance());
            tmp.addAll(this.elements);
            schema1.elements = tmp.toArray(new Element[tmp.size()]);
        }
        if (this.groups != null) {
            it = this.groups.iterator();
            cache = new HashSet();
            while (it.hasNext()) {
                t = it.next();
                if (!(t instanceof GroupHandler)) continue;
                tt = (GroupHandler)t;
                cache.add(((GroupHandler)tt).compress(this));
                it.remove();
            }
            it = cache.iterator();
            while (it.hasNext()) {
                this.groups.add(it.next());
            }
            tmp = new TreeSet(SchemaComparator.getInstance());
            tmp.addAll(this.groups);
            schema1.groups = tmp.toArray(new Group[tmp.size()]);
        }
        this.redefines = null;
        this.includes = null;
        this.imports = null;
        this.groups = null;
        this.elements = null;
        this.simpleTypes = null;
        this.complexTypes = null;
        this.attributes = null;
        this.attributeGroups = null;
        return schema1;
    }

    private SimpleType lookUpSimpleType(String localName, Schema s, TreeSet targets) {
        int i;
        if (s == null) {
            return null;
        }
        targets.add(s.getTargetNamespace());
        if (s.getSimpleTypes() != null) {
            SimpleType[] sts = s.getSimpleTypes();
            for (i = 0; sts != null && i < sts.length; ++i) {
                if (!localName.equalsIgnoreCase(sts[i].getName())) continue;
                return sts[i];
            }
        }
        if (s.getImports() != null) {
            Schema[] ss = s.getImports();
            for (i = 0; ss != null && i < ss.length; ++i) {
                SimpleType st;
                if (targets.contains(ss[i].getTargetNamespace()) || (st = this.lookUpSimpleType(localName, ss[i], targets)) == null) continue;
                return st;
            }
        }
        return null;
    }

    protected SimpleType lookUpSimpleType(String qname) {
        SimpleType sti;
        Iterator it;
        int index = qname.indexOf(":");
        String prefix1 = null;
        String localName = null;
        if (index >= 0) {
            localName = qname.substring(index + 1);
            prefix1 = qname.substring(0, index);
        } else {
            prefix1 = "";
            localName = qname;
        }
        logger.finest("prefix is " + prefix1);
        logger.finest("localName is " + localName);
        if (this.prefix == null && prefix1 == null || this.prefix != null && this.prefix.equals(prefix1)) {
            if (this.schema != null) {
                return this.lookUpSimpleType(localName, this.schema, new TreeSet());
            }
        } else if (this.imports != null) {
            it = this.imports.iterator();
            while (it.hasNext()) {
                SimpleType st;
                String prefixLookup;
                Schema s = (Schema)it.next();
                String ns = s.getTargetNamespace().toString();
                String string = prefixLookup = this.prefixCache != null ? (String)this.prefixCache.get(ns) : null;
                if (prefix1 != null && prefixLookup != null && !prefix1.equals(prefixLookup) || (st = this.lookUpSimpleType(localName, s, new TreeSet())) == null) continue;
                return st;
            }
        }
        if (this.simpleTypes != null) {
            it = this.simpleTypes.iterator();
            while (it.hasNext()) {
                Object sst;
                Object o = it.next();
                if (o instanceof SimpleTypeHandler) {
                    sst = (SimpleTypeHandler)o;
                    if (!localName.equalsIgnoreCase(((SimpleTypeHandler)sst).getName())) continue;
                    return ((SimpleTypeHandler)sst).compress(this);
                }
                sst = (SimpleType)o;
                if (!localName.equalsIgnoreCase(sst.getName())) continue;
                return sst;
            }
        }
        if ((sti = XSISimpleTypes.find(localName)) != null) {
            return sti;
        }
        return null;
    }

    private ComplexType lookUpComplexType(String localName, Schema s, TreeSet targets) {
        int i;
        if (s == null) {
            return null;
        }
        targets.add(s.getTargetNamespace());
        if (s.getComplexTypes() != null) {
            ComplexType[] sts = s.getComplexTypes();
            for (i = 0; sts != null && i < sts.length; ++i) {
                if (!localName.equalsIgnoreCase(sts[i].getName())) continue;
                return sts[i];
            }
        }
        if (s.getImports() != null) {
            Schema[] ss = s.getImports();
            for (i = 0; ss != null && i < ss.length; ++i) {
                ComplexType st;
                if (targets.contains(ss[i].getTargetNamespace()) || (st = this.lookUpComplexType(localName, ss[i], targets)) == null) continue;
                return st;
            }
        }
        return null;
    }

    protected ComplexType lookUpComplexType(String qname) throws SAXException {
        Iterator it;
        int index = qname.indexOf(":");
        String prefix1 = null;
        String localName = null;
        if (index >= 0) {
            localName = qname.substring(index + 1);
            prefix1 = qname.substring(0, index);
        } else {
            prefix1 = "";
            localName = qname;
        }
        logger.finest("prefix is " + prefix1);
        logger.finest("localName is " + localName);
        if (this.prefix == null && prefix1 == null || this.prefix != null && this.prefix.equals(prefix1)) {
            if (this.schema != null) {
                return this.lookUpComplexType(localName, this.schema, new TreeSet());
            }
        } else if (this.imports != null) {
            it = this.imports.iterator();
            while (it.hasNext()) {
                ComplexType ct;
                String prefixLookup;
                Schema s = (Schema)it.next();
                String ns = s.getTargetNamespace().toString();
                String string = prefixLookup = this.prefixCache != null ? (String)this.prefixCache.get(ns) : null;
                if (prefix1 != null && prefixLookup != null && !prefix1.equals(prefixLookup) || (ct = this.lookUpComplexType(localName, s, new TreeSet())) == null) continue;
                return ct;
            }
        }
        if (this.complexTypes != null) {
            it = this.complexTypes.iterator();
            while (it.hasNext()) {
                Object sst;
                Object o = it.next();
                if (o instanceof ComplexTypeHandler) {
                    sst = (ComplexTypeHandler)o;
                    if (!localName.equalsIgnoreCase(((ComplexTypeHandler)sst).getName())) continue;
                    return ((ComplexTypeHandler)sst).compress(this);
                }
                sst = (ComplexType)o;
                if (!localName.equalsIgnoreCase(sst.getName())) continue;
                return sst;
            }
        }
        return null;
    }

    private Element lookupElement(String localName, Schema s, TreeSet targets) {
        int i;
        if (s == null) {
            return null;
        }
        logger.finest("looking for element in " + s.getTargetNamespace());
        targets.add(s.getTargetNamespace());
        if (s.getElements() != null) {
            Element[] sts = s.getElements();
            for (i = 0; sts != null && i < sts.length; ++i) {
                logger.finest("checking element " + sts[i].getName());
                if (!localName.equalsIgnoreCase(sts[i].getName())) continue;
                return sts[i];
            }
        }
        if (s.getImports() != null) {
            Schema[] ss = s.getImports();
            for (i = 0; ss != null && i < ss.length; ++i) {
                Element st;
                if (targets.contains(ss[i].getTargetNamespace()) || (st = this.lookupElement(localName, ss[i], targets)) == null) continue;
                return st;
            }
        }
        return null;
    }

    protected Element lookUpElement(String qname) throws SAXException {
        Iterator it;
        int index = qname.indexOf(":");
        String prefix1 = null;
        String localName = null;
        if (index >= 0) {
            localName = qname.substring(index + 1);
            prefix1 = qname.substring(0, index);
        } else {
            prefix1 = "";
            localName = qname;
        }
        logger.finest("prefix is " + prefix1);
        logger.finest("localName is " + localName);
        if (this.prefix == null && prefix1 == null || this.prefix != null && this.prefix.equals(prefix1)) {
            if (this.schema != null) {
                return this.lookupElement(localName, this.schema, new TreeSet());
            }
        } else {
            Element ct;
            String prefixLookup;
            String ns;
            Schema s;
            if (this.imports != null) {
                it = this.imports.iterator();
                while (it.hasNext()) {
                    s = (Schema)it.next();
                    ns = s.getTargetNamespace().toString();
                    String string = prefixLookup = this.prefixCache != null ? (String)this.prefixCache.get(ns) : null;
                    if (prefix1 != null && prefixLookup != null && !prefix1.equals(prefixLookup) || (ct = this.lookupElement(localName, s, new TreeSet())) == null) continue;
                    return ct;
                }
            }
            if (this.includes != null) {
                it = this.includes.iterator();
                while (it.hasNext()) {
                    s = (Schema)it.next();
                    ns = s.getTargetNamespace().toString();
                    String string = prefixLookup = this.prefixCache != null ? (String)this.prefixCache.get(ns) : null;
                    if (prefix1 != null && prefixLookup != null && !prefix1.equals(prefixLookup) || (ct = this.lookupElement(localName, s, new TreeSet())) == null) continue;
                    return ct;
                }
            }
        }
        it = this.elements.iterator();
        while (it.hasNext()) {
            Object sst;
            Object o = it.next();
            if (o instanceof ElementTypeHandler) {
                sst = (ElementTypeHandler)o;
                if (!localName.equalsIgnoreCase(((ElementTypeHandler)sst).getName())) continue;
                return (Element)((ElementTypeHandler)sst).compress(this);
            }
            sst = (Element)o;
            if (!localName.equalsIgnoreCase(sst.getName())) continue;
            return sst;
        }
        return null;
    }

    private Group lookUpGroup(String localName, Schema s, TreeSet targets) {
        int i;
        if (s == null) {
            return null;
        }
        targets.add(s.getTargetNamespace());
        if (s.getGroups() != null) {
            Group[] sts = s.getGroups();
            for (i = 0; sts != null && i < sts.length; ++i) {
                if (!localName.equalsIgnoreCase(sts[i].getName())) continue;
                return sts[i];
            }
        }
        if (s.getImports() != null) {
            Schema[] ss = s.getImports();
            for (i = 0; ss != null && i < ss.length; ++i) {
                Group st;
                if (targets.contains(ss[i].getTargetNamespace()) || (st = this.lookUpGroup(localName, ss[i], targets)) == null) continue;
                return st;
            }
        }
        return null;
    }

    protected Group lookUpGroup(String qname) throws SAXException {
        Iterator it;
        int index = qname.indexOf(":");
        String prefix1 = null;
        String localName = null;
        if (index >= 0) {
            localName = qname.substring(index + 1);
            prefix1 = qname.substring(0, index);
        } else {
            prefix1 = "";
            localName = qname;
        }
        logger.finest("prefix is " + prefix1);
        logger.finest("localName is " + localName);
        if (this.prefix == null && prefix1 == null || this.prefix != null && this.prefix.equals(prefix1)) {
            if (this.schema != null) {
                return this.lookUpGroup(localName, this.schema, new TreeSet());
            }
        } else if (this.imports != null) {
            it = this.imports.iterator();
            while (it.hasNext()) {
                Group ct;
                String prefixLookup;
                Schema s = (Schema)it.next();
                String ns = s.getTargetNamespace().toString();
                String string = prefixLookup = this.prefixCache != null ? (String)this.prefixCache.get(ns) : null;
                if (prefix1 != null && prefixLookup != null && !prefix1.equals(prefixLookup) || (ct = this.lookUpGroup(localName, s, new TreeSet())) == null) continue;
                return ct;
            }
        }
        if (this.groups != null) {
            it = this.groups.iterator();
            while (it.hasNext()) {
                Object sst;
                Object o = it.next();
                if (o instanceof GroupHandler) {
                    sst = (GroupHandler)o;
                    if (!localName.equalsIgnoreCase(((GroupHandler)sst).getName())) continue;
                    return (Group)((GroupHandler)sst).compress(this);
                }
                sst = (Group)o;
                if (!localName.equalsIgnoreCase(sst.getName())) continue;
                return sst;
            }
        }
        return null;
    }

    private AttributeGroup lookUpAttributeGroup(String localName, Schema s, TreeSet targets) {
        int i;
        if (s == null) {
            return null;
        }
        targets.add(s.getTargetNamespace());
        if (s.getAttributeGroups() != null) {
            AttributeGroup[] sts = s.getAttributeGroups();
            for (i = 0; sts != null && i < sts.length; ++i) {
                if (!localName.equalsIgnoreCase(sts[i].getName())) continue;
                return sts[i];
            }
        }
        if (s.getImports() != null) {
            Schema[] ss = s.getImports();
            for (i = 0; ss != null && i < ss.length; ++i) {
                AttributeGroup st;
                if (targets.contains(ss[i].getTargetNamespace()) || (st = this.lookUpAttributeGroup(localName, ss[i], targets)) == null) continue;
                return st;
            }
        }
        return null;
    }

    protected AttributeGroup lookUpAttributeGroup(String qname) throws SAXException {
        Iterator it;
        int index = qname.indexOf(":");
        String prefix1 = null;
        String localName = null;
        if (index >= 0) {
            localName = qname.substring(index + 1);
            prefix1 = qname.substring(0, index);
        } else {
            prefix1 = "";
            localName = qname;
        }
        logger.finest("prefix is " + prefix1);
        logger.finest("localName is " + localName);
        if (this.prefix == null && prefix1 == null || this.prefix != null && this.prefix.equals(prefix1)) {
            if (this.schema != null) {
                return this.lookUpAttributeGroup(localName, this.schema, new TreeSet());
            }
        } else if (this.imports != null) {
            it = this.imports.iterator();
            while (it.hasNext()) {
                AttributeGroup ct;
                String prefixLookup;
                Schema s = (Schema)it.next();
                String ns = s.getTargetNamespace().toString();
                String string = prefixLookup = this.prefixCache != null ? (String)this.prefixCache.get(ns) : null;
                if (prefix1 != null && prefixLookup != null && !prefix1.equals(prefixLookup) || (ct = this.lookUpAttributeGroup(localName, s, new TreeSet())) == null) continue;
                return ct;
            }
        }
        if (this.attributeGroups != null) {
            it = this.attributeGroups.iterator();
            while (it.hasNext()) {
                Object sst;
                Object o = it.next();
                if (o instanceof AttributeGroupHandler) {
                    sst = (AttributeGroupHandler)o;
                    if (!localName.equalsIgnoreCase(((AttributeGroupHandler)sst).getName())) continue;
                    return ((AttributeGroupHandler)sst).compress(this);
                }
                sst = (AttributeGroup)o;
                if (!localName.equalsIgnoreCase(sst.getName())) continue;
                return sst;
            }
        }
        return null;
    }

    private Attribute lookUpAttribute(String localName, Schema s, TreeSet targets) {
        int i;
        if (s == null) {
            return null;
        }
        targets.add(s.getTargetNamespace());
        if (s.getAttributes() != null) {
            Attribute[] sts = s.getAttributes();
            for (i = 0; sts != null && i < sts.length; ++i) {
                if (sts[i] == null || sts[i].getName() == null || !localName.equalsIgnoreCase(sts[i].getName())) continue;
                return sts[i];
            }
        }
        if (s.getImports() != null) {
            Schema[] ss = s.getImports();
            for (i = 0; ss != null && i < ss.length; ++i) {
                Attribute st;
                if (targets.contains(ss[i].getTargetNamespace()) || (st = this.lookUpAttribute(localName, ss[i], targets)) == null) continue;
                return st;
            }
        }
        return null;
    }

    protected Attribute lookUpAttribute(String qname) throws SAXException {
        Iterator it;
        int index = qname.indexOf(":");
        String prefix1 = null;
        String localName = null;
        if (index >= 0) {
            localName = qname.substring(index + 1);
            prefix1 = qname.substring(0, index);
        } else {
            prefix1 = "";
            localName = qname;
        }
        logger.finest("prefix is " + prefix1);
        logger.finest("localName is " + localName);
        if (this.prefix == null && prefix1 == null || this.prefix != null && this.prefix.equals(prefix1)) {
            if (this.schema != null) {
                return this.lookUpAttribute(localName, this.schema, new TreeSet());
            }
        } else if (this.imports != null) {
            it = this.imports.iterator();
            while (it.hasNext()) {
                Attribute ct;
                String prefixLookup;
                Schema s = (Schema)it.next();
                String ns = s.getTargetNamespace().toString();
                String string = prefixLookup = this.prefixCache != null ? (String)this.prefixCache.get(ns) : null;
                if (prefix1 != null && prefixLookup != null && !prefix1.equals(prefixLookup) || (ct = this.lookUpAttribute(localName, s, new TreeSet())) == null) continue;
                return ct;
            }
        }
        if (this.attributes != null) {
            it = this.attributes.iterator();
            while (it.hasNext()) {
                Object sst;
                Object o = it.next();
                if (o instanceof AttributeHandler) {
                    sst = (AttributeHandler)o;
                    if (!localName.equalsIgnoreCase(((AttributeHandler)sst).getName())) continue;
                    return ((AttributeHandler)sst).compress(this);
                }
                sst = (Attribute)o;
                if (!localName.equalsIgnoreCase(sst.getName())) continue;
                return sst;
            }
        }
        return null;
    }

    protected Type lookUpType(String qname) throws SAXException {
        if (qname == null) {
            return null;
        }
        ComplexType t = null;
        t = this.lookUpComplexType(qname);
        t = t == null ? this.lookUpSimpleType(qname) : t;
        return t;
    }

    private void addSchema(Schema s) {
        int i;
        Object[] objs = null;
        objs = s.getAttributes();
        if (objs != null) {
            if (this.attributes == null && objs.length > 0) {
                this.attributes = new LinkedList();
            }
            for (i = 0; i < objs.length; ++i) {
                this.attributes.add(objs[i]);
            }
        }
        if ((objs = s.getAttributeGroups()) != null) {
            if (this.attributeGroups == null && objs.length > 0) {
                this.attributeGroups = new LinkedList();
            }
            for (i = 0; i < objs.length; ++i) {
                this.attributeGroups.add(objs[i]);
            }
        }
        if ((objs = s.getComplexTypes()) != null) {
            if (this.complexTypes == null && objs.length > 0) {
                this.complexTypes = new LinkedList();
            }
            for (i = 0; i < objs.length; ++i) {
                this.complexTypes.add(objs[i]);
            }
        }
        if ((objs = s.getElements()) != null) {
            if (this.elements == null && objs.length > 0) {
                this.elements = new LinkedList();
            }
            for (i = 0; i < objs.length; ++i) {
                this.elements.add(objs[i]);
            }
        }
        if ((objs = s.getGroups()) != null) {
            if (this.groups == null && objs.length > 0) {
                this.groups = new LinkedList();
            }
            for (i = 0; i < objs.length; ++i) {
                this.groups.add(objs[i]);
            }
        }
        if ((objs = s.getImports()) != null) {
            if (this.imports == null && objs.length > 0) {
                this.imports = new LinkedList();
            }
            for (i = 0; i < objs.length; ++i) {
                this.imports.add(objs[i]);
            }
        }
        if ((objs = s.getSimpleTypes()) != null) {
            if (this.simpleTypes == null && objs.length > 0) {
                this.simpleTypes = new LinkedList();
            }
            for (i = 0; i < objs.length; ++i) {
                this.simpleTypes.add(objs[i]);
            }
        }
        URI tempuri = s.getURI();
        if (this.uri == null) {
            this.uri = tempuri;
        } else if (tempuri != null) {
            this.uri = tempuri.resolve(this.uri);
        }
    }

    public URI getTargetNamespace() {
        return this.targetNamespace;
    }

    public int getHandlerType() {
        return 0;
    }

    public void endElement(String namespaceURI1, String localName) {
    }

    private static class SchemaComparator
    implements Comparator {
        private static SchemaComparator instance = new SchemaComparator();

        private SchemaComparator() {
        }

        public static SchemaComparator getInstance() {
            return instance;
        }

        public int compare(Object arg0, Object arg1) {
            if (arg0 instanceof Attribute && arg1 instanceof Attribute) {
                return this.compareAttribute((Attribute)arg0, (Attribute)arg1);
            }
            if (arg0 instanceof AttributeGroup && arg1 instanceof AttributeGroup) {
                return this.compareAttributeGroup((AttributeGroup)arg0, (AttributeGroup)arg1);
            }
            if (arg0 instanceof ComplexType && arg1 instanceof ComplexType) {
                return this.compareComplexType((ComplexType)arg0, (ComplexType)arg1);
            }
            if (arg0 instanceof SimpleType && arg1 instanceof SimpleType) {
                return this.compareSimpleType((SimpleType)arg0, (SimpleType)arg1);
            }
            if (arg0 instanceof Group && arg1 instanceof Group) {
                return this.compareGroup((Group)arg0, (Group)arg1);
            }
            if (arg0 instanceof Element && arg1 instanceof Element) {
                return this.compareElement((Element)arg0, (Element)arg1);
            }
            if (arg0 instanceof Schema && arg1 instanceof Schema) {
                return this.compareImport((Schema)arg0, (Schema)arg1);
            }
            return -1;
        }

        private int compareAttribute(Attribute arg0, Attribute arg1) {
            int i;
            if (arg0 == arg1) {
                return 0;
            }
            if (arg0 == null) {
                return 1;
            }
            if (arg1 == null) {
                return -1;
            }
            int n = arg0.getName() == null ? (arg1.getName() == null ? 0 : 1) : (i = arg0.getName().compareTo(arg1.getName()));
            if (i != 0) {
                return i;
            }
            int n2 = arg0.getNamespace() == null ? (arg1.getNamespace() == null ? 0 : 1) : (i = arg0.getNamespace().compareTo(arg1.getNamespace()));
            if (i != 0) {
                return i;
            }
            i = arg0.getUse() - arg1.getUse();
            if (i != 0) {
                return i;
            }
            return this.compareSimpleType(arg0.getSimpleType(), arg1.getSimpleType());
        }

        private int compareAttributeGroup(AttributeGroup arg0, AttributeGroup arg1) {
            int i;
            if (arg0 == arg1) {
                return 0;
            }
            if (arg0 == null) {
                return 1;
            }
            if (arg1 == null) {
                return -1;
            }
            int n = arg0.getName() == null ? (arg1.getName() == null ? 0 : 1) : (i = arg0.getName().compareTo(arg1.getName()));
            if (i != 0) {
                return i;
            }
            int n2 = arg0.getNamespace() == null ? (arg1.getNamespace() == null ? 0 : 1) : (i = arg0.getNamespace().compareTo(arg1.getNamespace()));
            if (i != 0) {
                return i;
            }
            int n3 = arg0.getAnyAttributeNameSpace() == null ? (arg1.getAnyAttributeNameSpace() == null ? 0 : 1) : (i = arg0.getAnyAttributeNameSpace().compareTo(arg1.getAnyAttributeNameSpace()));
            if (i != 0) {
                return i;
            }
            Attribute[] a0 = arg0.getAttributes();
            Arrays.sort(a0, this);
            Attribute[] a1 = arg1.getAttributes();
            Arrays.sort(a1, this);
            if (a0 == a1) {
                return 0;
            }
            if (a0 == null) {
                return 1;
            }
            if (a1 == null) {
                return -1;
            }
            if (a0.length < a1.length) {
                return -1;
            }
            if (a0.length > a1.length) {
                return 1;
            }
            for (int j = 0; j < a0.length && i == 0; ++j) {
                i = this.compareAttribute(a0[j], a1[j]);
            }
            return i;
        }

        private int compareGroup(Group arg0, Group arg1) {
            ElementGrouping a1;
            int i;
            if (arg0 == arg1) {
                return 0;
            }
            if (arg0 == null) {
                return 1;
            }
            if (arg1 == null) {
                return -1;
            }
            int n = arg0.getName() == null ? (arg1.getName() == null ? 0 : 1) : (i = arg0.getName().compareTo(arg1.getName()));
            if (i != 0) {
                return i;
            }
            int n2 = arg0.getNamespace() == null ? (arg1.getNamespace() == null ? 0 : 1) : (i = arg0.getNamespace().compareTo(arg1.getNamespace()));
            if (i != 0) {
                return i;
            }
            i = arg0.getMaxOccurs() - arg1.getMaxOccurs();
            if (i != 0) {
                return i;
            }
            i = arg0.getMinOccurs() - arg1.getMinOccurs();
            if (i != 0) {
                return i;
            }
            ElementGrouping a0 = arg0.getChild();
            if (a0 == (a1 = arg1.getChild())) {
                return 0;
            }
            if (a0 == null) {
                return 1;
            }
            if (a1 == null) {
                return -1;
            }
            return this.compareElementGrouping(a0, a1);
        }

        private int compareElement(Element arg0, Element arg1) {
            int i;
            if (arg0 == arg1) {
                return 0;
            }
            if (arg0 == null) {
                return 1;
            }
            if (arg1 == null) {
                return -1;
            }
            int n = arg0.getName() == null ? (arg1.getName() == null ? 0 : 1) : (i = arg0.getName().compareTo(arg1.getName()));
            if (i != 0) {
                return i;
            }
            int n2 = arg0.getNamespace() == null ? (arg1.getNamespace() == null ? 0 : 1) : (i = arg0.getNamespace().compareTo(arg1.getNamespace()));
            if (i != 0) {
                return i;
            }
            i = arg0.getMaxOccurs() - arg1.getMaxOccurs();
            if (i != 0) {
                return i;
            }
            i = arg0.getMinOccurs() - arg1.getMinOccurs();
            if (i != 0) {
                return i;
            }
            i = this.compareElement(arg0.getSubstitutionGroup(), arg1.getSubstitutionGroup());
            if (i != 0) {
                return i;
            }
            return this.compare(arg0.getType(), arg1.getType());
        }

        private int compareElementGrouping(ElementGrouping arg0, ElementGrouping arg1) {
            if (arg0 == arg1) {
                return 0;
            }
            if (arg0 == null) {
                return 1;
            }
            if (arg1 == null) {
                return -1;
            }
            int i = 0;
            i = arg0.getGrouping() - arg1.getGrouping();
            if (i != 0) {
                return i;
            }
            i = arg0.getMaxOccurs() - arg1.getMaxOccurs();
            if (i != 0) {
                return i;
            }
            i = arg0.getMinOccurs() - arg1.getMinOccurs();
            if (i != 0) {
                return i;
            }
            ElementGrouping[] eg0 = null;
            ElementGrouping[] eg1 = null;
            switch (arg0.getGrouping()) {
                case 1: {
                    return this.compareElement((Element)arg0, (Element)arg1);
                }
                case 2: {
                    return this.compareGroup((Group)arg0, (Group)arg1);
                }
                case 16: {
                    Choice c0 = (Choice)arg0;
                    Choice c1 = (Choice)arg1;
                    eg0 = c0.getChildren();
                    eg1 = c1.getChildren();
                }
                case 8: {
                    Sequence s0 = (Sequence)arg0;
                    Sequence s1 = (Sequence)arg1;
                    eg0 = s0.getChildren();
                    eg1 = s1.getChildren();
                }
                case 32: {
                    All a0 = (All)arg0;
                    All a1 = (All)arg1;
                    eg0 = a0.getElements();
                    eg1 = a1.getElements();
                }
            }
            if (eg0.length < eg1.length) {
                return -1;
            }
            if (eg0.length > eg1.length) {
                return 1;
            }
            for (int j = 0; j < eg0.length && i != 0; ++j) {
                i = this.compareElementGrouping(eg0[j], eg1[j]);
            }
            return 0;
        }

        private int compareImport(Schema arg0, Schema arg1) {
            int i;
            if (arg0 == arg1) {
                return 0;
            }
            if (arg0 == null) {
                return 1;
            }
            if (arg1 == null) {
                return -1;
            }
            int n = arg0.getTargetNamespace() == null ? (arg1.getTargetNamespace() == null ? 0 : 1) : (i = arg0.getTargetNamespace().compareTo(arg1.getTargetNamespace()));
            if (i != 0) {
                return i;
            }
            int n2 = arg0.getURI() == null ? (arg1.getURI() == null ? 0 : 1) : (i = arg0.getURI().compareTo(arg1.getURI()));
            if (i != 0) {
                return i;
            }
            i = arg0.getElements().length - arg1.getElements().length;
            if (i != 0) {
                return i;
            }
            i = arg0.getComplexTypes().length - arg1.getComplexTypes().length;
            if (i != 0) {
                return i;
            }
            i = arg0.getSimpleTypes().length - arg1.getSimpleTypes().length;
            if (i != 0) {
                return i;
            }
            i = arg0.getAttributes().length - arg1.getAttributes().length;
            if (i != 0) {
                return i;
            }
            i = arg0.getAttributeGroups().length - arg1.getAttributeGroups().length;
            if (i != 0) {
                return i;
            }
            i = arg0.getGroups().length - arg1.getGroups().length;
            if (i != 0) {
                return i;
            }
            return 0;
        }

        private int compareSimpleType(SimpleType arg0, SimpleType arg1) {
            int i;
            if (arg0 == arg1) {
                return 0;
            }
            if (arg0 == null) {
                return 1;
            }
            if (arg1 == null) {
                return -1;
            }
            int n = arg0.getName() == null ? (arg1.getName() == null ? 0 : 1) : (i = arg0.getName().compareTo(arg1.getName()));
            if (i != 0) {
                return i;
            }
            int n2 = arg0.getNamespace() == null ? (arg1.getNamespace() == null ? 0 : 1) : (i = arg0.getNamespace().compareTo(arg1.getNamespace()));
            if (i != 0) {
                return i;
            }
            SimpleType[] a0 = arg0.getParents();
            Arrays.sort(a0, this);
            SimpleType[] a1 = arg1.getParents();
            Arrays.sort(a1, this);
            if (a0 == a1) {
                return 0;
            }
            if (a0 == null) {
                return 1;
            }
            if (a1 == null) {
                return -1;
            }
            if (a0.length < a1.length) {
                return -1;
            }
            if (a0.length > a1.length) {
                return 1;
            }
            for (int j = 0; j < a0.length && i == 0; ++j) {
                i = this.compareSimpleType(a0[j], a1[j]);
            }
            Facet[] a01 = arg0.getFacets();
            Arrays.sort(a0, this);
            Facet[] a11 = arg1.getFacets();
            Arrays.sort(a1, this);
            if (a01 == a11) {
                return 0;
            }
            if (a01 == null) {
                return 1;
            }
            if (a11 == null) {
                return -1;
            }
            if (a01.length < a11.length) {
                return -1;
            }
            if (a01.length > a11.length) {
                return 1;
            }
            for (int j = 0; j < a01.length && i == 0; ++j) {
                i = this.compareFacet(a01[j], a11[j]);
            }
            return i;
        }

        private int compareFacet(Facet arg0, Facet arg1) {
            if (arg0 == arg1) {
                return 0;
            }
            if (arg0 == null) {
                return 1;
            }
            if (arg1 == null) {
                return -1;
            }
            int i = 0;
            i = arg0.getFacetType() - arg1.getFacetType();
            if (i != 0) {
                return i;
            }
            i = arg0.getValue() == null ? (arg1.getValue() == null ? 0 : 1) : arg0.getValue().compareTo(arg1.getValue());
            return i;
        }

        private int compareComplexType(ComplexType arg0, ComplexType arg1) {
            Type a01;
            int i;
            if (arg0 == arg1) {
                return 0;
            }
            if (arg0 == null) {
                return 1;
            }
            if (arg1 == null) {
                return -1;
            }
            int n = arg0.getName() == null ? (arg1.getName() == null ? 0 : 1) : (i = arg0.getName().compareTo(arg1.getName()));
            if (i != 0) {
                return i;
            }
            int n2 = arg0.getNamespace() == null ? (arg1.getNamespace() == null ? 0 : 1) : (i = arg0.getNamespace().compareTo(arg1.getNamespace()));
            if (i != 0) {
                return i;
            }
            Type a00 = arg0.getParent();
            if (a00 == (a01 = arg1.getParent())) {
                return 0;
            }
            if (a00 == null) {
                return 1;
            }
            if (a01 == null) {
                return -1;
            }
            i = this.compare(a00, a01);
            if (i != 0) {
                return i;
            }
            int n3 = arg0.getAnyAttributeNameSpace() == null ? (arg1.getAnyAttributeNameSpace() == null ? 0 : 1) : (i = arg0.getAnyAttributeNameSpace().compareTo(arg1.getAnyAttributeNameSpace()));
            if (i != 0) {
                return i;
            }
            Attribute[] a10 = arg0.getAttributes();
            Arrays.sort(a10, this);
            Attribute[] a11 = arg1.getAttributes();
            Arrays.sort(a11, this);
            if (a10 == a11) {
                return 0;
            }
            if (a10 == null) {
                return 1;
            }
            if (a11 == null) {
                return -1;
            }
            if (a10.length < a11.length) {
                return -1;
            }
            if (a10.length > a11.length) {
                return 1;
            }
            for (int j = 0; j < a10.length && i == 0; ++j) {
                i = this.compareAttribute(a10[j], a11[j]);
            }
            if (i != 0) {
                return i;
            }
            Element[] a0 = arg0.getChildElements();
            Arrays.sort(a0, this);
            Element[] a1 = arg1.getChildElements();
            Arrays.sort(a1, this);
            if (a0 == a1) {
                return 0;
            }
            if (a0 == null) {
                return 1;
            }
            if (a1 == null) {
                return -1;
            }
            if (a0.length < a1.length) {
                return -1;
            }
            if (a0.length > a1.length) {
                return 1;
            }
            for (int j = 0; j < a0.length && i == 0; ++j) {
                i = this.compareElement(a0[j], a1[j]);
            }
            return i;
        }
    }

    private static class DefaultSchema
    implements Schema {
        boolean attributeFormDefault;
        boolean elementFormDefault;
        String id;
        URI targetNamespace;
        String version;
        int finalDefault;
        int blockDefault;
        URI uri;
        Schema[] imports;
        SimpleType[] simpleTypes;
        ComplexType[] complexTypes;
        AttributeGroup[] attributeGroups;
        Attribute[] attributes;
        Element[] elements;
        Group[] groups;
        String prefix;

        private DefaultSchema() {
        }

        public boolean isAttributeFormDefault() {
            return this.attributeFormDefault;
        }

        public AttributeGroup[] getAttributeGroups() {
            return this.attributeGroups;
        }

        public Attribute[] getAttributes() {
            return this.attributes;
        }

        public int getBlockDefault() {
            return this.blockDefault;
        }

        public ComplexType[] getComplexTypes() {
            return this.complexTypes;
        }

        public boolean isElementFormDefault() {
            return this.elementFormDefault;
        }

        public Element[] getElements() {
            return this.elements;
        }

        public int getFinalDefault() {
            return this.finalDefault;
        }

        public String getId() {
            return this.id;
        }

        public Schema[] getImports() {
            return this.imports;
        }

        public SimpleType[] getSimpleTypes() {
            return this.simpleTypes;
        }

        public URI getTargetNamespace() {
            return this.targetNamespace;
        }

        public URI getURI() {
            return this.uri;
        }

        public String getVersion() {
            return this.version;
        }

        public Group[] getGroups() {
            return this.groups;
        }

        public boolean includesURI(URI uri1) {
            if (this.uri == null) {
                return false;
            }
            return this.uri.equals(uri1);
        }

        public String getPrefix() {
            return this.prefix;
        }

        public Map getImplementationHints() {
            return Collections.EMPTY_MAP;
        }
    }
}

