/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.file.imageio;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.commons.io.FilenameUtils;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.exception.CreateException;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.raster.NewRasterStoreParameters;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemStoreParameters;
import org.gvsig.fmap.dal.serverexplorer.filesystem.impl.AbstractFilesystemServerExplorerProvider;
import org.gvsig.fmap.dal.serverexplorer.filesystem.spi.FilesystemServerExplorerProviderFactory;
import org.gvsig.fmap.dal.serverexplorer.filesystem.spi.FilesystemServerExplorerProviderServices;
import org.gvsig.raster.lib.buffer.api.Buffer;

public class ImageIOFileSystemServerProvider
extends AbstractFilesystemServerExplorerProvider {
    protected FilesystemServerExplorerProviderServices serverExplorer;
    protected String[] fileExtensions;
    protected boolean canCreate;

    public ImageIOFileSystemServerProvider(FilesystemServerExplorerProviderFactory factory, String name, String description, String[] fileExtensions) {
        this(factory, name, description, fileExtensions, false);
    }

    public ImageIOFileSystemServerProvider(FilesystemServerExplorerProviderFactory factory, String name, String description, String[] fileExtensions, boolean canCreate) {
        super(factory, name, description);
        this.fileExtensions = fileExtensions;
        this.canCreate = canCreate;
    }

    public boolean canCreate() {
        return this.canCreate;
    }

    public NewDataStoreParameters getCreateParameters() throws DataException {
        if (!this.canCreate()) {
            throw new UnsupportedOperationException();
        }
        return null;
    }

    public void create(NewDataStoreParameters parameters, boolean overwrite) throws CreateException {
        if (!this.canCreate()) {
            throw new UnsupportedOperationException();
        }
        File output = ((FilesystemStoreParameters)parameters).getFile();
        if (output == null) {
            throw new IllegalArgumentException("Parameter 'file' can't be null.");
        }
        Buffer buffer = ((NewRasterStoreParameters)parameters).getBuffer();
        if (buffer == null) {
            throw new IllegalArgumentException("Parameter 'buffer' can't be null.");
        }
        BufferedImage image = buffer.getBufferedImage();
        try {
            ImageIO.write((RenderedImage)image, this.getName(), output);
        }
        catch (IOException ex) {
            throw new CreateException(output.getAbsolutePath(), (Throwable)ex);
        }
    }

    public int getMode() {
        return 4;
    }

    public boolean accept(File pathname) {
        return FilenameUtils.isExtension((String)pathname.getName().toLowerCase(), (String[])this.fileExtensions);
    }
}

