/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.file.imageio;

import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;
import org.apache.commons.io.FilenameUtils;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.FileHelper;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.OpenException;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.file.imageio.ImageIOStoreProviderParameters;
import org.gvsig.fmap.dal.raster.spi.AbstractAwtRasterStoreProvider;
import org.gvsig.fmap.dal.resource.exception.AccessResourceException;
import org.gvsig.fmap.dal.resource.spi.ResourceConsumer;
import org.gvsig.fmap.dal.resource.spi.ResourceProvider;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemServerExplorerParameters;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.task.SimpleTaskStatus;

public class ImageIOStoreProvider
extends AbstractAwtRasterStoreProvider
implements ResourceConsumer {
    protected String storeProviderName;
    protected String storeProviderDescription;
    protected ResourceProvider resource;
    private BufferedImage image;

    public ImageIOStoreProvider(String storeProviderName, String storeProviderDescription, ImageIOStoreProviderParameters params, DataStoreProviderServices storeServices) throws InitializeException {
        super((DataStoreParameters)params, storeServices, FileHelper.newMetadataContainer((String)storeProviderName));
        this.storeProviderName = storeProviderName;
        this.storeProviderDescription = storeProviderDescription;
        this.init((DataStoreParameters)params, storeServices);
    }

    public String getProviderName() {
        return this.storeProviderName;
    }

    protected void init(DataStoreParameters params, DataStoreProviderServices storeServices) throws InitializeException {
        super.init(params, storeServices);
        File file = this.getParameters().getFile();
        if (file == null) {
            throw new InitializeException((Throwable)new NullPointerException(this.storeProviderName + " file is null"));
        }
        this.resource = this.createResource("file", new Object[]{file.getAbsolutePath()});
        this.resource.addConsumer((ResourceConsumer)this);
    }

    public ResourceProvider getResource() {
        return this.resource;
    }

    public Object getSourceId() {
        return this.getParameters().getFile();
    }

    public String getName() {
        String name = this.getParameters().getFile().getName();
        return FilenameUtils.getBaseName((String)name);
    }

    public String getFullName() {
        return this.getParameters().getFile().getAbsolutePath();
    }

    public boolean closeResourceRequested(ResourceProvider resource) {
        return true;
    }

    public void resourceChanged(ResourceProvider resource) {
        this.getStoreServices().notifyChange("resourceChange_DataStore", resource);
    }

    protected void doDispose() throws BaseException {
        super.doDispose();
        this.resource.removeConsumer((ResourceConsumer)this);
        this.resource = null;
        this.image = null;
    }

    public ImageIOStoreProviderParameters getParameters() {
        return (ImageIOStoreProviderParameters)super.getParameters();
    }

    public void open() throws OpenException {
        if (this.isOpen()) {
            return;
        }
        SimpleTaskStatus taskStatus = null;
        try {
            taskStatus = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus(this.getName());
            taskStatus.setIndeterminate();
            taskStatus.setAutoremove(true);
            taskStatus.message("Loading " + this.getName() + "...");
            taskStatus.add();
            this.image = ImageIO.read((File)this.getResource().getParameters().getDynValue("file"));
            this.open(this.image.getRaster());
        }
        catch (Exception e) {
            if (taskStatus != null) {
                taskStatus.abort();
                taskStatus = null;
            }
            try {
                throw new OpenException(this.resource.getName(), (Throwable)e);
            }
            catch (AccessResourceException e1) {
                throw new OpenException(this.getProviderName(), (Throwable)e);
            }
        }
        finally {
            if (taskStatus != null) {
                taskStatus.terminate();
                taskStatus = null;
            }
        }
    }

    public DataServerExplorer getExplorer() throws ReadException, ValidateDataParametersException {
        DataManager manager = DALLocator.getDataManager();
        try {
            FilesystemServerExplorerParameters params = (FilesystemServerExplorerParameters)manager.createServerExplorerParameters("FilesystemExplorer");
            params.setRoot(this.getParameters().getFile().getParent());
            return manager.openServerExplorer("FilesystemExplorer", (DataServerExplorerParameters)params);
        }
        catch (DataException | ValidateDataParametersException e) {
            throw new ReadException(this.getProviderName(), e);
        }
    }

    public BufferedImage getImage() {
        this.autoOpen();
        return this.image;
    }
}

