/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.fmap.rendering;

import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.mapcontext.MapContextException;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.rendering.legend.IInterval;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.legend.impl.VectorialIntervalLegend;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.IFillSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.impl.MarkerFillSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.impl.MultiLayerFillSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.IMarkerSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style.IMarkerFillPropertiesStyle;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style.SimpleMarkerFillPropertiesStyle;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.util.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraduatedSymbolsLegend
extends VectorialIntervalLegend {
    private static Logger logger = LoggerFactory.getLogger(GraduatedSymbolsLegend.class);
    public static final String GRADUATED_SYMBOL_LEGEND_NAME = "GRADUATED_SYMBOL_LEGEND";
    public static final String GRADUATED_SYMBOL_LEGEND_PERSISTENCE_DEFINITION_NAME = "GRADUATED_SYMBOL_LEGEND_PERSISTENCE_DEFINITION";
    private double maxSymbolSize;
    private double minSymbolSize;
    private ISymbol backgroundSymbol;
    private int templateShapeType;

    public GraduatedSymbolsLegend() {
    }

    public GraduatedSymbolsLegend(VectorialIntervalLegend leg) {
        this();
        this.setShapeType(leg.getShapeType());
        Object[] _keys = leg.getValues();
        ISymbol[] _syms = leg.getSymbols();
        if (_keys == null || _syms == null) {
            logger.info("Warning: inconsistent VectorialIntervalLegend (keys or syms is null)");
        } else if (_keys.length != _syms.length) {
            logger.info("Warning: inconsistent VectorialIntervalLegend (keys and syms have dif length)");
        } else {
            for (int i = 0; i < _keys.length; ++i) {
                this.addSymbol(_keys[i], _syms[i]);
            }
        }
        this.setClassifyingFieldNames(leg.getClassifyingFieldNames());
        this.setClassifyingFieldTypes(leg.getClassifyingFieldTypes());
        this.setDefaultSymbol(leg.getDefaultSymbol());
        this.setIntervalType(leg.getIntervalType());
        this.useDefaultSymbol(leg.isUseDefaultSymbol());
    }

    public double getMaxSymbolSize() {
        return this.maxSymbolSize;
    }

    public double getMinSymbolSize() {
        return this.minSymbolSize;
    }

    public void setMaxSymbolSize(double size) {
        this.maxSymbolSize = size;
    }

    public void setMinSymbolSize(double size) {
        this.minSymbolSize = size;
    }

    public ISymbol getSymbolByFeature(Feature feat) throws MapContextException {
        ISymbol theSymbol = super.getSymbolByFeature(feat);
        if (GraduatedSymbolsLegend.isPolygonal(this.getShapeType()) && theSymbol instanceof IMarkerSymbol) {
            theSymbol = GraduatedSymbolsLegend.toFillSymbol(theSymbol);
        }
        if (this.backgroundSymbol != null) {
            MultiLayerFillSymbol multi = new MultiLayerFillSymbol();
            multi.addLayer(this.backgroundSymbol);
            multi.addLayer(theSymbol);
            return multi;
        }
        return theSymbol;
    }

    public ISymbol getSymbolByInterval(IInterval key) {
        ISymbol theSymbol = super.getSymbolByInterval(key);
        if (GraduatedSymbolsLegend.isPolygonal(this.getShapeType()) && theSymbol instanceof IMarkerSymbol) {
            theSymbol = GraduatedSymbolsLegend.toFillSymbol(theSymbol);
        }
        return theSymbol;
    }

    public ISymbol getBackgroundSymbol() {
        return this.backgroundSymbol;
    }

    public void setBackgroundSymbol(ISymbol symbol) {
        this.backgroundSymbol = symbol;
    }

    public ISymbol getDefaultSymbol() {
        return this.defaultSymbol;
    }

    public boolean isSuitableForShapeType(int st) {
        return GraduatedSymbolsLegend.areSameBasicType(this.getShapeType(), st) || GraduatedSymbolsLegend.isPoint(this.getTemplateShapeType()) && GraduatedSymbolsLegend.isPolygonal(st);
    }

    public int getTemplateShapeType() {
        return this.templateShapeType;
    }

    public void setTemplateShapeType(int tst) {
        if (GraduatedSymbolsLegend.isPolygonal(this.getShapeType())) {
            if (GraduatedSymbolsLegend.isPoint(tst)) {
                this.templateShapeType = tst;
            }
        } else if (GraduatedSymbolsLegend.areSameBasicType(tst, this.getShapeType())) {
            this.templateShapeType = tst;
        }
    }

    public static boolean isPolygonal(int ty) {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        return geomManager.isSubtype(9, ty) || geomManager.isSubtype(3, ty);
    }

    public static boolean isLinear(int ty) {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        return geomManager.isSubtype(8, ty) || geomManager.isSubtype(2, ty);
    }

    public static boolean isPoint(int ty) {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        return geomManager.isSubtype(7, ty) || geomManager.isSubtype(1, ty);
    }

    public static boolean areSameBasicType(int ta, int tb) {
        if (GraduatedSymbolsLegend.isPoint(ta) && GraduatedSymbolsLegend.isPoint(tb)) {
            return true;
        }
        if (GraduatedSymbolsLegend.isLinear(ta) && GraduatedSymbolsLegend.isLinear(tb)) {
            return true;
        }
        return GraduatedSymbolsLegend.isPolygonal(ta) && GraduatedSymbolsLegend.isPolygonal(tb);
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        this.templateShapeType = state.getInt("templateShapeType");
        this.maxSymbolSize = state.getDouble("maxSymbolSize");
        this.minSymbolSize = state.getDouble("minSymbolSize");
        if (state.hasValue("backgroundSymbol")) {
            this.backgroundSymbol = (ISymbol)state.get("backgroundSymbol");
        }
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set("templateShapeType", this.templateShapeType);
        state.set("maxSymbolSize", this.maxSymbolSize);
        state.set("minSymbolSize", this.minSymbolSize);
        if (this.backgroundSymbol != null) {
            state.set("backgroundSymbol", (Persistent)this.backgroundSymbol);
        }
    }

    public static IFillSymbol toFillSymbol(ISymbol sym) {
        if (sym instanceof IFillSymbol) {
            return (IFillSymbol)sym;
        }
        if (sym instanceof IMarkerSymbol) {
            MarkerFillSymbol aux = new MarkerFillSymbol();
            aux.setMarker((IMarkerSymbol)sym);
            SimpleMarkerFillPropertiesStyle p = new SimpleMarkerFillPropertiesStyle();
            p.setFillStyle(2);
            aux.setMarkerFillProperties((IMarkerFillPropertiesStyle)p);
            return aux;
        }
        return null;
    }

    public static class RegisterLegend
    implements Callable {
        public Object call() throws Exception {
            MapContextManager manager = MapContextLocator.getMapContextManager();
            manager.registerLegend(GraduatedSymbolsLegend.GRADUATED_SYMBOL_LEGEND_NAME, GraduatedSymbolsLegend.class);
            return Boolean.TRUE;
        }
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() throws Exception {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            if (manager.getDefinition(GraduatedSymbolsLegend.GRADUATED_SYMBOL_LEGEND_PERSISTENCE_DEFINITION_NAME) == null) {
                DynStruct definition = manager.addDefinition(GraduatedSymbolsLegend.class, GraduatedSymbolsLegend.GRADUATED_SYMBOL_LEGEND_PERSISTENCE_DEFINITION_NAME, "GRADUATED_SYMBOL_LEGEND_PERSISTENCE_DEFINITION Persistence definition", null, null);
                definition.extend(manager.getDefinition("VectorialIntervalLegend"));
                definition.addDynFieldInt("templateShapeType").setMandatory(true);
                definition.addDynFieldDouble("maxSymbolSize").setMandatory(true);
                definition.addDynFieldDouble("minSymbolSize").setMandatory(true);
                definition.addDynFieldObject("backgroundSymbol").setClassOfValue(ISymbol.class).setMandatory(false);
            }
            return Boolean.TRUE;
        }
    }
}

