/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.h2spatial;

import java.awt.BorderLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SpinnerNumberModel;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.preferences.AbstractPreferencePage;
import org.gvsig.andami.preferences.IPreference;
import org.gvsig.andami.preferences.StoreException;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataTypeUtils;
import org.gvsig.h2spatial.H2SpatialPreferencesPageView;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;

public class H2SpatialPreferencesPage
extends AbstractPreferencePage
implements IPreference {
    public static String id = H2SpatialPreferencesPage.class.getName();
    private H2SpatialPreferencesPageView view;
    private boolean hasChanges;
    private ImageIcon icon;

    public H2SpatialPreferencesPage() {
        this.setParentID("org.gvsig.app.gui.preferencespage.dal.DALPage");
        this.initComponents();
        this.initializeValues();
    }

    private void initComponents() {
        this.view = new H2SpatialPreferencesPageView();
        this.translate();
        this.setLayout(new BorderLayout());
        this.add(this.view, "Center");
        this.view.spnConnectionCacheLifetime.addChangeListener(e -> {
            this.hasChanges = true;
        });
        this.view.spnConnectionCacheLifetime.setModel(new SpinnerNumberModel(60000, 0, Integer.MAX_VALUE, 60000));
    }

    private void translate() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        toolsSwingManager.translate(this.view.lblConnectionCacheLifetime);
        toolsSwingManager.translate((JComponent)this.view.spnConnectionCacheLifetime);
    }

    public boolean isResizeable() {
        return true;
    }

    public void initializeValues() {
        DataManager dataManager = DALLocator.getDataManager();
        int lifetime = DataTypeUtils.toInteger((Object)dataManager.getProperty("h2GlobalConnectionsLifetime"), (int)60000);
        this.view.spnConnectionCacheLifetime.setValue(lifetime);
    }

    public String getID() {
        return id;
    }

    public String getTitle() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        return i18nManager.getTranslation("_H2Spatial_provider");
    }

    public JPanel getPanel() {
        return this;
    }

    public void storeValues() throws StoreException {
        DataManager dataManager = DALLocator.getDataManager();
        dataManager.setProperty("h2GlobalConnectionsLifetime", (Object)((Number)this.view.spnConnectionCacheLifetime.getValue()).longValue());
    }

    public void initializeDefaults() {
        this.view.spnConnectionCacheLifetime.setValue(60000);
    }

    public ImageIcon getIcon() {
        if (this.icon == null) {
            this.icon = IconThemeHelper.getImageIcon((String)"preferences-h2spatialprovider");
        }
        return this.icon;
    }

    public boolean isValueChanged() {
        return this.hasChanges;
    }

    public void setChangesApplied() {
        this.hasChanges = true;
    }
}

