/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.catalog.protocols;

import java.net.URI;
import java.util.Hashtable;
import org.gvsig.catalog.protocols.Z3950Connection;
import org.jzkit.search.provider.iface.SearchException;
import org.jzkit.search.provider.iface.Searchable;
import org.jzkit.search.provider.z3950.Z3950ServiceFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class Z3950ConnectionFactory {
    private static ApplicationContext app_context = null;
    private static boolean appContextInitialized = false;
    private static Z3950ServiceFactory factory = null;
    private static Hashtable connections = new Hashtable();

    public static Z3950Connection getConnection(URI uri) {
        Z3950Connection connection = (Z3950Connection)((Object)connections.get(uri));
        if (connection == null) {
            connection = new Z3950Connection(uri);
            connections.put(uri, connection);
        }
        return connection;
    }

    public static Searchable getSearchable(URI uri) throws SearchException {
        if (!appContextInitialized) {
            Z3950ConnectionFactory.initAppContext(uri);
            factory = new Z3950ServiceFactory();
            factory.setApplicationContext(app_context);
            factory.setDefaultRecordSyntax("usmarc");
            factory.setDefaultElementSetName("F");
            factory.getRecordArchetypes().put("Default", "usmarc::F");
            factory.getRecordArchetypes().put("FullDisplay", "usmarc::F");
            factory.getRecordArchetypes().put("BriefDisplay", "usmarc::B");
            factory.getRecordArchetypes().put("Holdings", "usmarc::F");
        }
        factory.setHost(uri.getHost());
        factory.setPort(uri.getPort());
        Searchable s = factory.newSearchable();
        s.setApplicationContext(app_context);
        return s;
    }

    private static void initAppContext(URI uri) {
        System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
        try {
            app_context = new FileSystemXmlApplicationContext(new String[]{"config/ApplicationContextAlone.xml"}, false);
            ((FileSystemXmlApplicationContext)app_context).setClassLoader(Z3950ConnectionFactory.class.getClassLoader());
            ((FileSystemXmlApplicationContext)app_context).refresh();
        }
        catch (Exception e) {
            e.printStackTrace();
            app_context = new FileSystemXmlApplicationContext(new String[]{"gvSIG/extensiones/es.gva.cit.gvsig.catalogClient/config/ApplicationContext.xml"}, false);
            ((FileSystemXmlApplicationContext)app_context).setClassLoader(Z3950ConnectionFactory.class.getClassLoader());
            ((FileSystemXmlApplicationContext)app_context).refresh();
        }
        if (app_context == null) {
            throw new RuntimeException("Unable to locate TestApplicationContext.xml definition file");
        }
        appContextInitialized = true;
    }
}

