/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.catalog.schemas;

import java.net.URI;
import org.gvsig.catalog.metadataxml.XMLNode;
import org.gvsig.catalog.metadataxml.XMLTree;
import org.gvsig.catalog.schemas.Record;
import org.gvsig.catalog.schemas.Resource;

public class LaitsGmuServicesRecord
extends Record {
    public LaitsGmuServicesRecord() {
    }

    public LaitsGmuServicesRecord(URI uri, XMLNode node) {
        super(uri, node);
        this.setTitle(XMLTree.searchNodeValue(node, "name"));
        this.setAbstract_(XMLTree.searchNodeValue(node, "description"));
        this.setPurpose(null);
        this.setKeyWords(null);
        this.setResources(this.getResources(node));
        this.setFileID(null);
        this.setImage(null);
    }

    private Resource[] getResources(XMLNode node) {
        XMLNode[] slots = XMLTree.searchMultipleNode(node, "rim:Slot");
        if (slots != null) {
            Resource[] resources = new Resource[1];
            String resource = null;
            String serviceType = null;
            for (int i = 0; i < slots.length; ++i) {
                XMLNode slot = slots[i];
                String attType = slot.getAttribute("name");
                if (attType.equals("connectPointLinkage")) {
                    resource = XMLTree.searchNodeValue(slot, "rim:ValueList->rim:Value");
                    continue;
                }
                if (!attType.equals("serviceType")) continue;
                serviceType = XMLTree.searchNodeValue(slot, "rim:ValueList->rim:Value");
            }
            resources[0] = new Resource(resource, this.getProtocol(serviceType), null, null, null, null, null);
            return resources;
        }
        return new Resource[0];
    }

    private String getProtocol(String serviceType) {
        if (serviceType == null) {
            return "UNKNOWN";
        }
        if (serviceType.compareTo("WMS") == 0) {
            return "OGC:WMS";
        }
        if (serviceType.compareTo("WCS") == 0) {
            return "OGC:WCS";
        }
        if (serviceType.compareTo("WFS") == 0) {
            return "OGC:WFS";
        }
        if (serviceType.compareTo("urn:uuid:677F6003-E6E0-4B5C-B930-09B36EF6E0FB") == 0) {
            return "OGC:WMS";
        }
        return "UNKNOWN";
    }

    @Override
    public boolean accept(URI uri, XMLNode node) {
        return node.getName().equals("rim:Service");
    }
}

