/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.catalog.ui.showresults;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.gvsig.catalog.CatalogClient;
import org.gvsig.catalog.schemas.Record;
import org.gvsig.catalog.utils.ImageRetriever;
import org.gvsig.i18n.Messages;

public class ShowResultsPanel
extends JPanel {
    public static boolean mustShowThumbnails = true;
    private Record record = null;
    private CatalogClient client = null;
    private URL imageURL = null;
    private JPanel descriptionPanel = null;
    private JEditorPane descriptionArea = null;
    private JPanel linksPanel = null;
    private JPanel jPanel = null;
    private JButton descriptionButton = null;
    private JLabel jLabel = null;
    private JButton mapButton = null;
    private JScrollPane descriptionScroll = null;
    private JPanel imagePanel = null;
    private JLabel jLabel1 = null;
    private JLabel imageLabel = null;
    private JPanel jPanel1 = null;
    private JPanel nextLastPanel = null;
    private JButton previousButton = null;
    private JLabel textLabel = null;
    private JButton nextButton = null;
    private int numRecords;
    private JButton closeButton = null;

    public ShowResultsPanel(CatalogClient client, int numRecords) {
        this.client = client;
        this.numRecords = numRecords;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BoxLayout(this, 1));
        this.add((Component)this.getNextLastPanel(), null);
        this.add((Component)this.getDescriptionPanel(), null);
        this.add((Component)this.getLinksPanel(), null);
        this.actualizaLabel(1);
    }

    public void actualizaLabel(int number) {
        this.textLabel.setText(Messages.getText((String)"results") + ": " + String.valueOf(number) + " " + Messages.getText((String)"of") + " " + String.valueOf(this.numRecords));
    }

    public void setDescripcionBoton(JButton descripcionBoton) {
        this.descriptionButton = descripcionBoton;
    }

    public void setMapButton(JButton mapButton) {
        this.mapButton = mapButton;
    }

    private JPanel getDescriptionPanel() {
        if (this.descriptionPanel == null) {
            this.descriptionPanel = new JPanel();
            this.descriptionPanel.setPreferredSize(new Dimension(600, 300));
            this.descriptionPanel.setLayout(new GridBagLayout());
            GridBagConstraints cc = new GridBagConstraints();
            cc.gridx = 0;
            cc.gridy = 0;
            cc.fill = 1;
            cc.weightx = 1.0;
            cc.weighty = 1.0;
            cc.insets = new Insets(2, 2, 2, 2);
            this.descriptionPanel.add((Component)this.getDescriptionScroll(), cc);
            if (mustShowThumbnails) {
                cc.gridx = 1;
                cc.weightx = 0.0;
                cc.fill = 0;
                this.descriptionPanel.add((Component)this.getImagePanel(), cc);
            }
        }
        return this.descriptionPanel;
    }

    public JEditorPane getDescriptionArea() {
        if (this.descriptionArea == null) {
            this.descriptionArea = new JEditorPane();
            this.descriptionArea.setPreferredSize(new Dimension(400, 300));
            this.descriptionArea.setContentType("text/html");
        }
        return this.descriptionArea;
    }

    private JPanel getLinksPanel() {
        if (this.linksPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(2);
            this.linksPanel = new JPanel(flowLayout);
            this.linksPanel.add((Component)this.getDescriptionButton(), null);
            this.linksPanel.add((Component)this.getMapButton(), null);
            this.linksPanel.add((Component)this.getCloseButton(), null);
        }
        return this.linksPanel;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
        }
        return this.jPanel;
    }

    public JButton getDescriptionButton() {
        if (this.descriptionButton == null) {
            this.descriptionButton = new JButton();
            this.descriptionButton.setText(Messages.getText((String)"description"));
            this.descriptionButton.setActionCommand("description");
            this.descriptionButton.setPreferredSize(new Dimension(95, 23));
        }
        return this.descriptionButton;
    }

    private JLabel getJLabel() {
        if (this.jLabel == null) {
            this.jLabel = new JLabel();
        }
        return this.jLabel;
    }

    public JButton getMapButton() {
        if (this.mapButton == null) {
            this.mapButton = new JButton();
            this.mapButton.setText(Messages.getText((String)"addLayer"));
            this.mapButton.setActionCommand("layer");
            this.mapButton.setPreferredSize(new Dimension(95, 23));
        }
        return this.mapButton;
    }

    public JScrollPane getDescriptionScroll() {
        if (this.descriptionScroll == null) {
            this.descriptionScroll = new JScrollPane();
            this.descriptionScroll.setViewportView(this.getDescriptionArea());
            this.descriptionScroll.setHorizontalScrollBarPolicy(31);
            this.descriptionScroll.setVerticalScrollBarPolicy(22);
            this.descriptionScroll.setPreferredSize(new Dimension(400, 250));
        }
        return this.descriptionScroll;
    }

    public Record getRecord() {
        return this.record;
    }

    public void setRecord(Record record) {
        this.record = record;
    }

    public void loadTextNewRecord(Record record) {
        this.setRecord(record);
        this.descriptionArea.setText(this.getHtml());
        this.descriptionArea.setCaretPosition(0);
        if (this.getRecord() != null) {
            if (this.getRecord().getImage() == null) {
                this.imageLabel.setIcon(this.getImgIcon(null));
                new ImageThread();
            } else {
                this.imageLabel.setIcon(this.getImgIcon(this.getRecord().getImage()));
            }
        }
        this.repaint();
    }

    private String getHtml() {
        StringBuffer html = new StringBuffer();
        html.append("<html><body>");
        if (this.getRecord() == null) {
            html.append("Error");
            html.append("</body></html>");
            return html.toString();
        }
        if (this.getRecord().getNode() != null && this.getRecord().getNode().getName() != null && this.getRecord().getNode().getName().equals("NOTXML")) {
            html.append(this.getRecord().getNode().getText());
            html.append("</body></html>");
            return html.toString();
        }
        html.append("<font COLOR=\"#0000FF\">");
        if (this.getRecord().getTitle() != null) {
            html.append(this.getRecord().getTitle());
        }
        html.append("<font COLOR=\"#000000\">");
        if (this.getRecord().getAbstract_() != null && !this.getRecord().getAbstract_().equals("")) {
            html.append("<br>");
            html.append("<br>");
            html.append("<b>" + Messages.getText((String)"abstract") + ": </b>");
            html.append(this.getRecord().getAbstract_());
        }
        if (this.getRecord().getPurpose() != null && !this.getRecord().getPurpose().equals("")) {
            html.append("<br>");
            html.append("<br>");
            html.append("<b>" + Messages.getText((String)"purpose") + ": </b>");
            html.append(this.getRecord().getPurpose());
        }
        if (this.getRecord().getKeyWords() != null && this.getRecord().getKeyWords()[0] != null) {
            html.append("<br>");
            html.append("<br>");
            html.append("<b>" + Messages.getText((String)"keyWords") + ":</b>");
            html.append(this.getRecord().getKeyWords()[0]);
        }
        if (this.getRecord().getKeyWords() != null) {
            for (int i = 1; i < this.getRecord().getKeyWords().length; ++i) {
                if (this.getRecord().getKeyWords()[i] == null) continue;
                html.append(", " + this.getRecord().getKeyWords()[i]);
            }
        }
        html.append("</body></html>");
        return html.toString();
    }

    private JPanel getImagePanel() {
        if (this.imagePanel == null) {
            this.imagePanel = new JPanel();
            this.imagePanel.setLayout(new FlowLayout(1));
            this.imagePanel.setMaximumSize(new Dimension(207, 210));
            JPanel borderPanel = new JPanel();
            borderPanel.setLayout(new BorderLayout());
            borderPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            this.imagePanel.add((Component)borderPanel, "Center");
            this.imageLabel = new JLabel(this.getImgIcon(null));
            borderPanel.add((Component)this.imageLabel, "Center");
        }
        return this.imagePanel;
    }

    public ImageIcon getImgIcon(BufferedImage pic) {
        BufferedImage img = new BufferedImage(180, 180, 2);
        Graphics2D g = img.createGraphics();
        if (pic != null) {
            double fw = 1.0;
            double fh = 1.0;
            if (pic.getWidth() > pic.getHeight()) {
                fh = fw = 180.0 / (double)pic.getWidth();
            } else {
                fw = fh = 180.0 / (double)pic.getHeight();
            }
            AffineTransform mat = AffineTransform.getScaleInstance(fw, fh);
            g.drawImage(pic, mat, null);
        } else {
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setFont(new Font("Lucida Bright", 2, 30));
            g.rotate(-0.7853981633974483, 100.0, 100.0);
            String text = "NO PICTURE";
            TextLayout tl = new TextLayout(text, g.getFont(), g.getFontRenderContext());
            Rectangle2D bounds = tl.getBounds();
            double x = (180.0 - bounds.getWidth()) / 2.0 - bounds.getX();
            double y = (180.0 - bounds.getHeight()) / 2.0 - bounds.getY();
            Shape outline = tl.getOutline(AffineTransform.getTranslateInstance(x + 2.0, y + 1.0));
            g.setComposite(AlphaComposite.getInstance(3, 0.3f));
            g.setPaint(Color.WHITE);
            g.draw(outline);
            g.setPaint(new GradientPaint(0.0f, 0.0f, new Color(192, 192, 255), 30.0f, 20.0f, new Color(255, 255, 64), true));
            tl.draw(g, (float)x, (float)y);
        }
        g.dispose();
        return new ImageIcon(img);
    }

    public URL getImageURL() {
        return this.imageURL;
    }

    public void setImageURL(URL imageURL) {
        this.imageURL = imageURL;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            this.jPanel1 = new JPanel();
        }
        return this.jPanel1;
    }

    private JPanel getNextLastPanel() {
        if (this.nextLastPanel == null) {
            this.textLabel = new JLabel();
            this.nextLastPanel = new JPanel();
            this.textLabel.setText("JLabel");
            this.nextLastPanel.add((Component)this.getPreviousButton(), null);
            this.nextLastPanel.add((Component)this.textLabel, null);
            this.nextLastPanel.add((Component)this.getNextButton(), null);
        }
        return this.nextLastPanel;
    }

    public JButton getPreviousButton() {
        if (this.previousButton == null) {
            this.previousButton = new JButton();
            this.previousButton.setText(Messages.getText((String)"_Previous"));
            this.previousButton.setActionCommand("previous");
            this.previousButton.setEnabled(false);
            this.previousButton.setPreferredSize(new Dimension(95, 23));
        }
        return this.previousButton;
    }

    public JButton getNextButton() {
        if (this.nextButton == null) {
            this.nextButton = new JButton();
            this.nextButton.setText(Messages.getText((String)"next"));
            this.nextButton.setActionCommand("next");
            this.nextButton.setPreferredSize(new Dimension(95, 23));
            if (this.numRecords < 2) {
                this.nextButton.setEnabled(false);
            }
        }
        return this.nextButton;
    }

    public JButton getCloseButton() {
        if (this.closeButton == null) {
            this.closeButton = new JButton();
            this.closeButton.setText(Messages.getText((String)"close"));
            this.closeButton.setActionCommand("close");
            this.closeButton.setPreferredSize(new Dimension(80, 23));
        }
        return this.closeButton;
    }

    private class ImageThread
    implements Runnable {
        volatile Thread myThread = new Thread(this);

        public ImageThread() {
            this.myThread.start();
        }

        public void stop() {
            this.myThread.stop();
        }

        @Override
        public void run() {
            BufferedImage img = ImageRetriever.getImageUrl(ShowResultsPanel.this.getRecord());
            ShowResultsPanel.this.imageLabel.setIcon(ShowResultsPanel.this.getImgIcon(img));
        }
    }
}

