/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.catalog.ui.showtree;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import next.swing.JTreeTable;
import next.swing.TreeTableModel;
import org.gvsig.catalog.metadataxml.XMLNode;
import org.gvsig.catalog.utils.xmltreetable.XMLTreeTable;
import org.gvsig.catalog.utils.xmltreetable.XMLTreeTableModel;
import org.gvsig.i18n.Messages;

public class ShowTreePanel
extends JPanel {
    private XMLTreeTable treeTable = null;
    private JScrollPane jScrollPane = null;
    private XMLNode node = null;

    public ShowTreePanel(XMLNode node) {
        this.node = node;
        this.initialize();
    }

    private void initialize() {
        this.setSize(900, 600);
        this.add((Component)this.getJScrollPane(), null);
    }

    public JTreeTable getTreeTable() {
        if (this.treeTable == null) {
            XMLTreeTableModel model = new XMLTreeTableModel(this.node);
            model.addJScrollPaneColumn("valueColumn", "tag-value", Messages.getText((String)"value"), 0);
            model.addJScrollPaneColumn("attributeColumn", "attribute", Messages.getText((String)"attributes"), 0);
            this.treeTable = new XMLTreeTable((TreeTableModel)model);
            model.configureView(this.treeTable);
        }
        return this.treeTable;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane((Component)this.getTreeTable());
            this.jScrollPane.setPreferredSize(new Dimension(775, 600));
            this.jScrollPane.setVerticalScrollBarPolicy(20);
            this.jScrollPane.setHorizontalScrollBarPolicy(31);
        }
        return this.jScrollPane;
    }
}

