/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.bean;

import com.jeta.forms.beanmgr.BeanManager;
import com.jeta.forms.gui.beans.JETABean;
import com.jeta.forms.gui.beans.JETAPropertyDescriptor;
import com.jeta.forms.gui.common.FormException;
import com.jeta.forms.logger.FormsLogger;
import com.jeta.forms.store.bean.BeanDeserializer;
import com.jeta.forms.store.memento.PropertiesMemento;
import com.jeta.forms.store.properties.ColorHolder;
import com.jeta.forms.store.properties.FontProperty;
import com.jeta.open.registry.JETARegistry;
import java.awt.Component;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class DefaultBeanDeserializer
implements BeanDeserializer {
    private PropertiesMemento m_memento;

    public DefaultBeanDeserializer(PropertiesMemento memento) {
        this.m_memento = memento;
    }

    public PropertiesMemento getProperties() {
        return this.m_memento;
    }

    public Component createBean() throws FormException {
        try {
            Class bean_class = null;
            try {
                BeanManager bmgr = (BeanManager)JETARegistry.lookup("jeta.forms.bean.manager");
                if (bmgr != null) {
                    bean_class = bmgr.getBeanClass(this.m_memento.getBeanClassName());
                }
            }
            catch (Exception e) {
                FormsLogger.severe(e);
            }
            if (bean_class == null) {
                bean_class = Class.forName(this.m_memento.getBeanClassName());
            }
            Component comp = (Component)bean_class.newInstance();
            return comp;
        }
        catch (Exception e) {
            FormsLogger.severe(e);
            if (e instanceof FormException) {
                throw (FormException)e;
            }
            throw new FormException(e);
        }
    }

    public void initializeBean(JETABean jbean) throws FormException {
        block16: {
            if (jbean == null) {
                return;
            }
            try {
                DefaultTableModel tmodel;
                JTable table;
                TableModel model;
                Component comp = jbean.getDelegate();
                if (comp instanceof JList) {
                    ((JList)comp).setModel(new DefaultListModel());
                } else if (comp instanceof JTable && (model = (table = (JTable)comp).getModel()) instanceof DefaultTableModel && (tmodel = (DefaultTableModel)model).getColumnCount() == 0) {
                    tmodel.addColumn("A");
                    tmodel.addColumn("B");
                    tmodel.addRow(new Object[]{"", ""});
                    tmodel.addRow(new Object[]{"", ""});
                }
                if (comp == null) break block16;
                Collection jeta_pds = jbean.getPropertyDescriptors();
                Iterator iter = jeta_pds.iterator();
                while (iter.hasNext()) {
                    JETAPropertyDescriptor jpd = (JETAPropertyDescriptor)iter.next();
                    try {
                        if (!this.m_memento.containsProperty(jpd.getName())) continue;
                        Object prop_value = this.m_memento.getPropertyValue(jpd.getName());
                        if (prop_value instanceof FontProperty) {
                            prop_value = ((FontProperty)prop_value).getFont();
                        } else if (prop_value instanceof ColorHolder) {
                            prop_value = ((ColorHolder)prop_value).getColor();
                        }
                        jpd.setPropertyValue(jbean, this.convertValue(jpd.getPropertyType(), prop_value));
                    }
                    catch (Exception e) {
                        FormsLogger.debug(e);
                    }
                }
                try {
                    if (this.m_memento.containsProperty("name")) {
                        comp.setName((String)this.m_memento.getPropertyValue("name"));
                    }
                }
                catch (Exception e) {
                    FormsLogger.severe(e);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (e instanceof FormException) {
                    throw (FormException)e;
                }
                throw new FormException(e);
            }
        }
    }

    private Object convertValue(Class c, Object prop_value) {
        String propclass;
        String string = propclass = prop_value == null ? "null" : prop_value.getClass().getName();
        if (prop_value instanceof String) {
            String sval = (String)prop_value;
            if (c == Boolean.class || c == Boolean.TYPE) {
                return Boolean.valueOf(sval);
            }
            if (c == Byte.class || c == Byte.TYPE) {
                return Byte.valueOf(sval);
            }
            if (c == Character.class || c == Character.TYPE) {
                return new Character(sval.length() == 0 ? (char)'\u0000' : sval.charAt(0));
            }
            if (c == Short.class || c == Short.TYPE) {
                return Short.valueOf(sval);
            }
            if (c == Integer.class || c == Integer.TYPE) {
                return Integer.valueOf(sval);
            }
            if (c == Long.class || c == Long.TYPE) {
                return Long.valueOf(sval);
            }
            if (c == Float.class || c == Float.TYPE) {
                return Float.valueOf(sval);
            }
            if (c == Double.class || c == Double.TYPE) {
                return Double.valueOf(sval);
            }
        }
        return prop_value;
    }
}

