/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.properties;

import com.jeta.forms.components.border.ShadowBorder;
import com.jeta.forms.store.JETAObjectInput;
import com.jeta.forms.store.JETAObjectOutput;
import com.jeta.forms.store.properties.BorderProperty;
import com.jeta.forms.store.properties.ColorProperty;
import java.awt.Component;
import java.io.IOException;
import javax.swing.border.Border;

public class ShadowBorderProperty
extends BorderProperty {
    static final long serialVersionUID = -1317321607073605569L;
    public static final int VERSION = 2;
    public static final int SOLID = 0;
    public static final int GRADIENT = 1;
    private int m_type = 0;
    private ColorProperty m_start_color = new ColorProperty();
    private ColorProperty m_end_color = new ColorProperty();
    private int m_thickness = 1;
    private boolean m_symmetric = true;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ShadowBorderProperty() {
    }

    public ShadowBorderProperty(int type, int thickness, ColorProperty startColor, ColorProperty endColor, boolean symmetric) {
        this.m_type = type;
        this.m_thickness = thickness;
        this.m_start_color = startColor;
        this.m_end_color = endColor;
        this.m_symmetric = symmetric;
    }

    public Border createBorder(Component comp) {
        ShadowBorder b = new ShadowBorder(this.getType(), this.getThickness(), this.getStartColor(), this.getEndColor(), this.isSymmetric());
        return b;
    }

    public int getType() {
        return this.m_type;
    }

    public ColorProperty getStartColor() {
        return this.m_start_color;
    }

    public ColorProperty getEndColor() {
        return this.m_end_color;
    }

    public int getThickness() {
        return this.m_thickness;
    }

    public boolean isSymmetric() {
        return this.m_symmetric;
    }

    public void setType(int type) {
        this.m_type = type;
    }

    public void setStartColor(ColorProperty c) {
        this.m_start_color = c;
    }

    public void setEndColor(ColorProperty c) {
        this.m_end_color = c;
    }

    public void setSymmetric(boolean symmetric) {
        this.m_symmetric = symmetric;
    }

    public void setThickness(int t) {
        this.m_thickness = t;
    }

    public void setValue(Object prop) {
        super.setValue(prop);
        if (prop instanceof ShadowBorderProperty) {
            ShadowBorderProperty bp = (ShadowBorderProperty)prop;
            this.m_type = bp.m_type;
            if (this.m_start_color == null) {
                this.m_start_color = new ColorProperty();
            }
            if (this.m_end_color == null) {
                this.m_end_color = new ColorProperty();
            }
            this.m_start_color.setValue(bp.m_start_color);
            this.m_end_color.setValue(bp.m_end_color);
            this.m_thickness = bp.m_thickness;
            this.m_symmetric = bp.m_symmetric;
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void read(JETAObjectInput in) throws ClassNotFoundException, IOException {
        super.read(in.getSuperClassInput());
        int version = in.readVersion();
        this.m_type = in.readInt("type");
        this.m_start_color = (ColorProperty)in.readObject("startcolor");
        this.m_end_color = (ColorProperty)in.readObject("endcolor");
        this.m_thickness = in.readInt("thickness");
        if (version > 1) {
            this.m_symmetric = in.readBoolean("symmetric");
        }
    }

    public void write(JETAObjectOutput out) throws IOException {
        super.write(out.getSuperClassOutput(BorderProperty.class));
        out.writeVersion(2);
        out.writeInt("type", this.m_type);
        out.writeObject("startcolor", this.m_start_color);
        out.writeObject("endcolor", this.m_end_color);
        out.writeInt("thickness", this.m_thickness);
        out.writeBoolean("symmetric", this.m_symmetric);
    }

    public String toString() {
        return "SHADOW";
    }

    static {
        $assertionsDisabled = !ShadowBorderProperty.class.desiredAssertionStatus();
    }
}

