/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.open.gui.framework;

import com.jeta.open.gui.framework.JETAContainer;
import com.jeta.open.gui.framework.JETAController;
import com.jeta.open.gui.framework.UIDirector;
import com.jeta.open.registry.JETARegistry;
import com.jeta.open.support.ComponentFinder;
import com.jeta.open.support.ComponentFinderFactory;
import com.jeta.open.support.DefaultComponentFinder;
import com.jeta.open.support.SwingComponentSupport;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.text.JTextComponent;

public class JETAPanel
extends JPanel
implements JETAContainer,
SwingComponentSupport {
    private ComponentFinder m_finder;
    private JETAController m_controller;
    private UIDirector m_uidirector;

    public JETAPanel() {
    }

    public JETAPanel(LayoutManager layout) {
        super(layout);
    }

    public JETAPanel(ComponentFinder finder) {
        this.m_finder = finder;
    }

    protected ComponentFinder createComponentFinder() {
        if (this.m_finder == null) {
            ComponentFinderFactory ff = (ComponentFinderFactory)JETARegistry.lookup("component.finder.factory");
            if (ff != null) {
                this.m_finder = ff.createFinder(this);
            }
            if (this.m_finder == null) {
                this.m_finder = new DefaultComponentFinder(this);
            }
        }
        return this.m_finder;
    }

    public void enableComponent(String commandId, boolean bEnable) {
        Collection comps = this.getComponentsByName(commandId);
        Iterator iter = comps.iterator();
        while (iter.hasNext()) {
            Component comp = (Component)iter.next();
            if (comp.isEnabled() == bEnable) continue;
            comp.setEnabled(bEnable);
        }
    }

    public boolean getBoolean(String compName) {
        Component comp = this.getComponentByName(compName);
        if (comp instanceof AbstractButton) {
            return ((AbstractButton)comp).isSelected();
        }
        return false;
    }

    public AbstractButton getButton(String compName) {
        Component comp = this.getComponentByName(compName);
        if (comp instanceof AbstractButton) {
            return (AbstractButton)comp;
        }
        return null;
    }

    public JCheckBox getCheckBox(String compName) {
        Component comp = this.getComponentByName(compName);
        if (comp instanceof JCheckBox) {
            return (JCheckBox)comp;
        }
        return null;
    }

    public JComboBox getComboBox(String compName) {
        Component comp = this.getComponentByName(compName);
        if (comp instanceof JComboBox) {
            return (JComboBox)comp;
        }
        return null;
    }

    public Component getComponentByName(String componentName) {
        Component comp = this.getComponentFinder().getComponentByName(componentName);
        if (comp == null) {
            System.err.println("JETAPanel.getComponentByName failed to find component: " + componentName);
        }
        return comp;
    }

    protected ComponentFinder getComponentFinder() {
        if (this.m_finder == null) {
            this.m_finder = this.createComponentFinder();
        }
        return this.m_finder;
    }

    public Collection getComponentsByName(String compName) {
        return this.getComponentFinder().getComponentsByName(compName);
    }

    public Collection getAllNamedComponents() {
        return this.getComponentFinder().getAllNamedComponents();
    }

    public JETAController getController() {
        return this.m_controller;
    }

    public int getInteger(String compName, int defaultValue) {
        try {
            Component comp = this.getComponentByName(compName);
            if (comp instanceof JTextField) {
                return Integer.parseInt(((JTextField)comp).getText());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    public JLabel getLabel(String compName) {
        Component comp = this.getComponentByName(compName);
        if (comp instanceof JLabel) {
            return (JLabel)comp;
        }
        return null;
    }

    public JList getList(String compName) {
        Component comp = this.getComponentByName(compName);
        if (comp instanceof JList) {
            return (JList)comp;
        }
        return null;
    }

    public JPanel getPanel(String compName) {
        Component comp = this.getComponentByName(compName);
        if (comp instanceof JPanel) {
            return (JPanel)comp;
        }
        return null;
    }

    public JProgressBar getProgressBar(String compName) {
        Component comp = this.getComponentByName(compName);
        if (comp instanceof JProgressBar) {
            return (JProgressBar)comp;
        }
        return null;
    }

    public JRadioButton getRadioButton(String compName) {
        Component comp = this.getComponentByName(compName);
        if (comp instanceof JRadioButton) {
            return (JRadioButton)comp;
        }
        return null;
    }

    public Object getSelectedItem(String compName) {
        Component comp = this.getComponentByName(compName);
        if (comp instanceof JList) {
            return ((JList)comp).getSelectedValue();
        }
        if (comp instanceof JComboBox) {
            return ((JComboBox)comp).getSelectedItem();
        }
        return null;
    }

    public JSpinner getSpinner(String compName) {
        Component comp = this.getComponentByName(compName);
        if (comp instanceof JSpinner) {
            return (JSpinner)comp;
        }
        return null;
    }

    public JTable getTable(String compName) {
        Component comp = this.getComponentByName(compName);
        if (comp instanceof JTable) {
            return (JTable)comp;
        }
        return null;
    }

    public JTabbedPane getTabbedPane(String compName) {
        Component comp = this.getComponentByName(compName);
        if (comp instanceof JTabbedPane) {
            return (JTabbedPane)comp;
        }
        return null;
    }

    public JTextComponent getTextComponent(String compName) {
        Component comp = this.getComponentByName(compName);
        if (comp instanceof JTextComponent) {
            return (JTextComponent)comp;
        }
        return null;
    }

    public JTextField getTextField(String compName) {
        Component comp = this.getComponentByName(compName);
        if (comp instanceof JTextField) {
            return (JTextField)comp;
        }
        return null;
    }

    public String getText(String compName) {
        Component comp = this.getComponentByName(compName);
        if (comp instanceof JTextComponent) {
            return ((JTextComponent)comp).getText();
        }
        if (comp instanceof AbstractButton) {
            return ((AbstractButton)comp).getText();
        }
        if (comp instanceof JLabel) {
            return ((JLabel)comp).getText();
        }
        try {
            if (comp != null) {
                Class<?> c = comp.getClass();
                Class[] params = new Class[]{};
                Object[] values = new Object[]{};
                Method m = c.getDeclaredMethod("getText", params);
                Object obj = m.invoke((Object)comp, values);
                return obj == null ? null : obj.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public JTree getTree(String compName) {
        Component comp = this.getComponentByName(compName);
        if (comp instanceof JTree) {
            return (JTree)comp;
        }
        return null;
    }

    public UIDirector getUIDirector() {
        return this.m_uidirector;
    }

    public boolean isSelected(String compName) {
        return this.getBoolean(compName);
    }

    public void removeDescendent(String compName) {
        Component comp = this.getComponentByName(compName);
        if (comp != null) {
            JETAPanel.removeFromParent(comp);
        }
    }

    public static void removeFromParent(Component comp) {
        Container parent;
        if (comp != null && (parent = comp.getParent()) != null) {
            parent.remove(comp);
            if (parent instanceof JComponent) {
                ((JComponent)parent).revalidate();
            }
        }
    }

    public void reset() {
        if (this.m_finder != null) {
            this.m_finder.reset();
        }
    }

    protected void setComponentFinder(ComponentFinder finder) {
        this.m_finder = finder;
    }

    public void setUIDirector(UIDirector director) {
        this.m_uidirector = director;
    }

    public void setController(JETAController controller) {
        this.m_controller = controller;
    }

    public void setVisible(String compName, boolean bVisible) {
        Component comp = this.getComponentByName(compName);
        if (comp != null) {
            comp.setVisible(bVisible);
        }
    }

    public void setSelected(String compName, boolean sel) {
        Component comp = this.getComponentByName(compName);
        if (comp instanceof AbstractButton) {
            ((AbstractButton)comp).setSelected(sel);
        }
    }

    public void setSelectedItem(String compName, Object value) {
        Component comp = this.getComponentByName(compName);
        if (comp instanceof JComboBox) {
            ((JComboBox)comp).setSelectedItem(value);
        } else if (comp instanceof JList) {
            ((JList)comp).setSelectedValue(value, true);
        }
    }

    public void setText(String compName, String txt) {
        Component comp = this.getComponentByName(compName);
        if (comp instanceof JTextComponent) {
            ((JTextComponent)comp).setText(txt);
        } else if (comp instanceof JLabel) {
            ((JLabel)comp).setText(txt);
        } else if (comp instanceof AbstractButton) {
            ((AbstractButton)comp).setText(txt);
        } else {
            try {
                if (comp != null) {
                    Class<?> c = comp.getClass();
                    Class[] params = new Class[]{String.class};
                    Object[] values = new Object[]{txt};
                    Method m = c.getDeclaredMethod("setText", params);
                    m.invoke((Object)comp, values);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void updateComponents() {
        this.updateComponents(null);
    }

    public void updateComponents(EventObject evt) {
        if (this.m_controller != null) {
            this.m_controller.updateComponents(evt);
        }
    }
}

