/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.circle3p;

import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Circumference;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.vectorediting.lib.api.exceptions.FinishServiceException;
import org.gvsig.vectorediting.lib.prov.circle3p.Circle2PEditingProvider;
import org.gvsig.vectorediting.lib.spi.DefaultDrawingStatus;
import org.gvsig.vectorediting.lib.spi.EditingProvider;
import org.gvsig.vectorediting.lib.spi.EditingProviderLocator;
import org.gvsig.vectorediting.lib.spi.EditingProviderManager;
import org.gvsig.vectorediting.lib.spi.EditingProviderServices;

public class Circumference2PEditingProvider
extends Circle2PEditingProvider
implements EditingProvider {
    public Circumference2PEditingProvider(ProviderServices providerServices, DynObject parameters) {
        super(providerServices, parameters);
    }

    @Override
    public Geometry finish() throws FinishServiceException {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        EditingProviderServices editingProviderServices = this.getProviderServices();
        Point firstPointValue = (Point)this.values.get(this.firstPoint);
        Point secondPointValue = (Point)this.values.get(this.secondPoint);
        try {
            int subtype = editingProviderServices.getSubType(this.featureStore);
            Point center = GeometryUtils.getMidPoint((Point)firstPointValue, (Point)secondPointValue, (int)subtype);
            double radius = firstPointValue.distance((Geometry)secondPointValue) / 2.0;
            Circumference circumference = (Circumference)geomManager.create(23, subtype);
            circumference.setPoints(center, radius);
            return this.makeMultiPrimitiveIsNeeded(this.featureStore, (Primitive)circumference);
        }
        catch (Exception e) {
            throw new FinishServiceException((Throwable)e);
        }
    }

    @Override
    public String getName() {
        return "insert-circumference-3p";
    }

    @Override
    protected void addTemporaryGeometryToDrawingStatus(DefaultDrawingStatus drawingStatus, int subtype, Point center, double radius) throws CreateGeometryException {
        EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
        ISymbol lineSymbolEditing = editingProviderManager.getSymbol("line-symbol-editing");
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        Circumference circumference = (Circumference)geomManager.create(23, subtype);
        circumference.setPoints(center, radius);
        drawingStatus.addStatus((Geometry)circumference, lineSymbolEditing, "");
        drawingStatus.addStatus((Geometry)circumference, drawingStatus.getPreviewSymbol(), "");
    }
}

