/*
 * Decompiled with CFR 0.152.
 */
package thing;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import thing.Generator;
import thing.Handler;
import thing.Settings;
import thinlet.Thinlet;
import thinletcommons.AntiAliasedThinlet;
import thinletcommons.DirChooser;
import thinletcommons.MessageDialog;
import thinletcommons.ThinletDialog;

public class GenerateDialog {
    private static final Logger log = Logger.getLogger("thing");
    private ThinletDialog dialog;
    private Thinlet thinlet;
    private Handler thingHandler;
    private Object cbGenerateInterface;
    private Object cbGenerateHandler;
    private Object cbGenerateAsThinlet;
    private Object cbGenerateMain;
    private Object tInterfaceName;
    private Object tHandlerName;
    private Object tPackageName;
    private Object tOutputDir;
    private Object tPreview;
    private Object bOk;

    private static final boolean debug() {
        return log.isLoggable(Level.FINE);
    }

    public GenerateDialog(Frame owner, Handler thingHandler) {
        this.dialog = new ThinletDialog(owner, "Generate Handler Stub Source");
        this.thinlet = new AntiAliasedThinlet();
        this.thingHandler = thingHandler;
        try {
            Object panel = this.thinlet.parse("/thing/generate.xml", (Object)this);
            this.thinlet.add(panel);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error parsing generate.xml", e);
        }
        this.dialog.setContent(this.thinlet);
    }

    public void show() {
        this.dialog.setSize(new Dimension(500, 460));
        this.dialog.setLocationRelativeTo(this.dialog.getOwner());
        this.dialog.setVisible(true);
    }

    public void init(Object cbGenerateInterface, Object cbGenerateHandler, Object cbGenerateAsThinlet, Object cbGenerateMain, Object tInterfaceName, Object tHandlerName, Object tPackageName, Object tOutputDir, Object tPreview, Object bOk) {
        this.cbGenerateInterface = cbGenerateInterface;
        this.cbGenerateHandler = cbGenerateHandler;
        this.cbGenerateAsThinlet = cbGenerateAsThinlet;
        this.cbGenerateMain = cbGenerateMain;
        this.tInterfaceName = tInterfaceName;
        this.tHandlerName = tHandlerName;
        this.tPackageName = tPackageName;
        this.tOutputDir = tOutputDir;
        this.tPreview = tPreview;
        this.bOk = bOk;
        this.thinlet.setString(tHandlerName, "text", this.getHandlerClassname());
        this.thinlet.setString(tInterfaceName, "text", this.getInterfaceName());
        String outputDir = null;
        outputDir = this.thingHandler.getCurrentFile() != null ? this.thingHandler.getCurrentFile().getParentFile().getAbsolutePath() : Settings.getLastDir();
        this.thinlet.setString(tOutputDir, "text", outputDir);
        this.updateGui();
    }

    public void checkboxChanged(Object checkbox) {
        this.updateGui();
    }

    public void textfieldChanged(Object textfield) {
        this.updatePreview();
    }

    public void buttonOutputDirClicked() {
        String outputDir = this.thinlet.getString(this.tOutputDir, "text");
        DirChooser chooser = new DirChooser(this.dialog, "Choose Directory...");
        chooser.setSelectedDirectory(new File(outputDir));
        chooser.show();
        File dir = chooser.getSelectedDirectory();
        if (dir != null) {
            this.thinlet.setString(this.tOutputDir, "text", dir.getAbsolutePath());
        }
    }

    public void ok() {
        if (this.generate()) {
            this.close();
        }
    }

    public void close() {
        this.dialog.setVisible(false);
    }

    private String getHandlerClassname() {
        String handlerName = this.thinlet.getString(this.tHandlerName, "text");
        if (handlerName == null || handlerName.trim().length() == 0) {
            if (this.thingHandler.getCurrentFile() != null) {
                return GenerateDialog.capitalize(GenerateDialog.getBaseName(this.thingHandler.getCurrentFile().getName())) + "Handler";
            }
            return "UnnamedHandler";
        }
        return GenerateDialog.getBaseName(handlerName.trim());
    }

    private String getInterfaceName() {
        String interfaceName = this.thinlet.getString(this.tInterfaceName, "text");
        if (interfaceName == null || interfaceName.trim().length() == 0) {
            return "I" + this.getHandlerClassname();
        }
        return GenerateDialog.getBaseName(interfaceName.trim());
    }

    private String getPackageName() {
        String packageName = this.thinlet.getString(this.tPackageName, "text");
        if (packageName == null || packageName.trim().length() == 0) {
            return null;
        }
        return packageName.trim();
    }

    private File getOutputFile(File dir, String filename) {
        File f = new File(dir, filename);
        if (f.exists()) {
            this.thingHandler.setStatusText("File " + f.getAbsolutePath() + " exists.");
            int answer = new MessageDialog((Dialog)this.dialog, "File Exists", "File " + f.getAbsolutePath() + "\nexists. Overwrite?", 2).show();
            if (answer != 2) {
                return null;
            }
            if (!f.canWrite()) {
                this.thingHandler.setStatusText("Cannot write to file " + f.getAbsolutePath() + ". (write protected?)");
                new MessageDialog(this.dialog, "Write Error", "Cannot write to file\n" + f.getAbsolutePath() + "\n(write protected?)").show();
                return null;
            }
        }
        return f;
    }

    private boolean generate() {
        boolean generateHandler = this.thinlet.getBoolean(this.cbGenerateHandler, "selected");
        boolean generateInterface = this.thinlet.getBoolean(this.cbGenerateInterface, "selected");
        if (!generateHandler && !generateInterface) {
            return true;
        }
        File outputDir = new File(this.thinlet.getString(this.tOutputDir, "text"));
        if (!outputDir.exists()) {
            new MessageDialog(this.dialog, "Generate Error", "The output directory\n" + outputDir.getAbsolutePath() + "\ndoes not exist.").show();
            return false;
        }
        Settings.setLastDir(outputDir.getAbsolutePath());
        try {
            Generator generator = new Generator();
            generator.setPackageName(this.getPackageName());
            generator.setGenerateFirstLine(true);
            if (generateHandler) {
                File handlerFile = this.getOutputFile(outputDir, this.getHandlerClassname() + ".java");
                if (handlerFile == null) {
                    return false;
                }
                generator.setWriterForHandler(new FileWriter(handlerFile));
                generator.setHandlerClassname(this.getHandlerClassname());
                generator.setGenerateAsThinlet(this.thinlet.getBoolean(this.cbGenerateAsThinlet, "selected"));
                generator.setGenerateMain(this.thinlet.getBoolean(this.cbGenerateMain, "selected"));
            }
            if (generateInterface) {
                File interfaceFile = this.getOutputFile(outputDir, this.getInterfaceName() + ".java");
                if (interfaceFile == null) {
                    return false;
                }
                generator.setWriterForInterface(new FileWriter(interfaceFile));
                generator.setInterfaceName(this.getInterfaceName());
            }
            String thinletFilename = this.thingHandler.getCurrentFile() != null ? this.thingHandler.getCurrentFile().getName() : "untitled.xml";
            generator.generate(this.thingHandler.getThinlet(), this.thingHandler.getTopComponent(), this.thingHandler.getPropertyManager(), thinletFilename);
            this.thingHandler.setStatusText("Code generated successfully to directory " + outputDir.getAbsolutePath());
            new MessageDialog(this.dialog, "Success", "Code generated successfully.").show();
            return true;
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Error generating java code to disk", e);
            this.thingHandler.setStatusText("I/O Error during generate.");
            new MessageDialog(this.dialog, "I/O Error", "An I/O error occurred during generate:\n\n" + e.toString() + "\n\nSee log for details.").show();
            return false;
        }
    }

    private void updateGui() {
        boolean generateHandler = this.thinlet.getBoolean(this.cbGenerateHandler, "selected");
        boolean generateInterface = this.thinlet.getBoolean(this.cbGenerateInterface, "selected");
        this.thinlet.setBoolean(this.tHandlerName, "enabled", generateHandler);
        this.thinlet.setBoolean(this.tInterfaceName, "enabled", generateInterface);
        this.thinlet.setBoolean(this.cbGenerateAsThinlet, "enabled", generateHandler);
        this.thinlet.setBoolean(this.cbGenerateMain, "enabled", generateHandler);
        this.thinlet.setBoolean(this.tPackageName, "enabled", generateHandler || generateInterface);
        this.thinlet.setBoolean(this.tPreview, "enabled", generateHandler || generateInterface);
        this.thinlet.setBoolean(this.bOk, "enabled", generateHandler || generateInterface);
        this.updatePreview();
    }

    private void updatePreview() {
        boolean generateHandler = this.thinlet.getBoolean(this.cbGenerateHandler, "selected");
        boolean generateInterface = this.thinlet.getBoolean(this.cbGenerateInterface, "selected");
        if (!generateHandler && !generateInterface) {
            return;
        }
        StringWriter sw = new StringWriter();
        Generator generator = new Generator();
        generator.setPackageName(this.getPackageName());
        generator.setGenerateFirstLine(false);
        if (generateHandler) {
            generator.setHandlerClassname(this.getHandlerClassname());
            generator.setGenerateAsThinlet(this.thinlet.getBoolean(this.cbGenerateAsThinlet, "selected"));
            generator.setGenerateMain(this.thinlet.getBoolean(this.cbGenerateMain, "selected"));
            generator.setWriterForHandler(sw);
        }
        if (generateInterface) {
            generator.setInterfaceName(this.getInterfaceName());
            generator.setWriterForInterface(generateHandler ? new StringWriter() : sw);
        }
        String thinletFilename = this.thingHandler.getCurrentFile() != null ? this.thingHandler.getCurrentFile().getName() : "untitled.xml";
        try {
            generator.generate(this.thingHandler.getThinlet(), this.thingHandler.getTopComponent(), this.thingHandler.getPropertyManager(), thinletFilename);
            this.thinlet.setString(this.tPreview, "text", sw.toString());
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Error generating preview", e);
            this.thinlet.setString(this.tPreview, "text", e.toString());
        }
    }

    private static String capitalize(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return s;
        }
        if (s.length() == 1) {
            return s.toUpperCase();
        }
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    private static String getBaseName(String filename) {
        int dotpos = filename.indexOf(46);
        return dotpos > 0 ? filename.substring(0, dotpos) : filename;
    }
}

