/*
 * Decompiled with CFR 0.152.
 */
package thing;

import java.awt.Frame;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import thing.Settings;
import thinlet.Thinlet;
import thinletcommons.AntiAliasedThinlet;
import thinletcommons.DirChooser;
import thinletcommons.ThinletDialog;

public class SettingsDialog {
    private static final Logger log = Logger.getLogger("thing");
    private ThinletDialog dialog;
    private Thinlet thinlet;

    private static final boolean debug() {
        return log.isLoggable(Level.FINE);
    }

    public SettingsDialog(Frame owner) {
        this.dialog = new ThinletDialog(owner, "Settings");
        this.thinlet = new AntiAliasedThinlet();
        try {
            Object panel = this.thinlet.parse("/thing/settings.xml", (Object)this);
            this.thinlet.add(panel);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error parsing settings.xml", e);
        }
        this.dialog.setContent(this.thinlet);
    }

    public void show() {
        String iconpath = Settings.getIconDir();
        if (iconpath.equals(".")) {
            iconpath = "";
        }
        this.thinlet.setString(this.thinlet.find("tIconpath"), "text", iconpath);
        this.thinlet.setString(this.thinlet.find("spIndentSize"), "text", String.valueOf(Settings.getSerializeIndentSize()));
        this.thinlet.setString(this.thinlet.find("tCustomHeader"), "text", Settings.getSerializeHeader());
        this.thinlet.setBoolean(this.thinlet.find("rbIndentSpace"), "selected", Settings.getSerializeIndentChar() == ' ');
        this.thinlet.setBoolean(this.thinlet.find("rbIndentTab"), "selected", Settings.getSerializeIndentChar() == '\t');
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(this.dialog.getOwner());
        this.dialog.setVisible(true);
    }

    public void chooseDir(Object tIconpath, String iconpath) {
        DirChooser chooser = new DirChooser(this.dialog, "Choose Directory...");
        if (iconpath != null && iconpath.trim().length() > 0) {
            chooser.setSelectedDirectory(new File(iconpath));
        }
        chooser.show();
        File dir = chooser.getSelectedDirectory();
        if (SettingsDialog.debug()) {
            log.fine("selected: " + dir);
        }
        if (dir != null) {
            this.thinlet.setString(tIconpath, "text", dir.getAbsolutePath());
        }
    }

    public void ok(String iconpath, String indentSize, boolean indentSpace, boolean indentTab, String customHeader) {
        String path = iconpath.trim();
        Settings.setIconDir(path.length() == 0 ? "." : path);
        Settings.setSerializeIndentChar(indentSpace ? (char)' ' : '\t');
        Settings.setSerializeIndentSize(Integer.parseInt(indentSize));
        Settings.setSerializeHeader(customHeader);
        this.close();
    }

    public void close() {
        this.dialog.setVisible(false);
    }
}

