/*
 * Decompiled with CFR 0.152.
 */
package thing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ThinletDTD {
    private static final Logger log;
    private static final Object[] dtd;
    private static final String[] components;
    private static final Object[] allowedSubWidgets;
    private static final HashMap widgets;

    private static final boolean debug() {
        return log.isLoggable(Level.FINE);
    }

    public static Widget getWidget(String classname) {
        Widget widget = (Widget)widgets.get(classname);
        if (widget == null) {
            throw new IllegalArgumentException("unknown classname: " + classname);
        }
        return widget;
    }

    public static Property[] getProperties(String classname) {
        return ThinletDTD.getWidget(classname).getProperties();
    }

    public static Property getProperty(String classname, String propName) {
        Property property = ThinletDTD.getWidget(classname).getProperty(propName);
        if (property != null) {
            return property;
        }
        throw new IllegalArgumentException("unknown property: " + propName + " in class: " + classname);
    }

    static {
        Widget widget;
        String classname;
        int i;
        log = Logger.getLogger("thing");
        Integer integer_1 = new Integer(-1);
        Integer integer0 = new Integer(0);
        Integer integer1 = new Integer(1);
        String[] orientation = new String[]{"horizontal", "vertical"};
        String[] leftcenterright = new String[]{"left", "center", "right"};
        String[] selections = new String[]{"single", "interval", "multiple"};
        dtd = new Object[]{"component", null, new Object[][]{{"string", "name", null, null}, {"boolean", "enabled", "paint", Boolean.TRUE}, {"boolean", "visible", "parent", Boolean.TRUE}, {"string", "tooltip", null, null}, {"font", "font", "validate", null}, {"color", "foreground", "paint", null}, {"color", "background", "paint", null}, {"integer", "width", "validate", integer0}, {"integer", "height", "validate", integer0}, {"integer", "colspan", "validate", integer1}, {"integer", "rowspan", "validate", integer1}, {"integer", "weightx", "validate", integer0}, {"integer", "weighty", "validate", integer0}, {"choice", "halign", "validate", new String[]{"fill", "center", "left", "right"}}, {"choice", "valign", "validate", new String[]{"fill", "center", "top", "bottom"}}, {"property", "property", null, null}, {"method", "init"}, {"method", "focuslost"}, {"method", "focusgained"}}, "label", "component", new Object[][]{{"string", "text", "validate", null}, {"icon", "icon", "validate", null}, {"choice", "alignment", "validate", leftcenterright}, {"integer", "mnemonic", "paint", integer_1}, {"component", "for", null, null}}, "button", "label", new Object[][]{{"choice", "alignment", "validate", new String[]{"center", "left", "right"}}, {"method", "action"}, {"choice", "type", "paint", new String[]{"normal", "default", "cancel", "link"}}}, "checkbox", "label", new Object[][]{{"boolean", "selected", "paint", Boolean.FALSE}, {"string", "group", "paint", null}, {"method", "action"}}, "togglebutton", "checkbox", null, "combobox", "textfield", new Object[][]{{"icon", "icon", "validate", null}, {"integer", "selected", "layout", integer_1}}, "choice", null, new Object[][]{{"string", "name", null, null}, {"boolean", "enabled", "paint", Boolean.TRUE}, {"boolean", "i18n", "validate", Boolean.FALSE}, {"string", "text", "parent", null}, {"icon", "icon", "parent", null}, {"choice", "alignment", "parent", leftcenterright}, {"string", "tooltip", null, null}, {"font", "font", "validate", null}, {"color", "foreground", "paint", null}, {"color", "background", "paint", null}, {"property", "property", null, null}}, "textfield", "component", new Object[][]{{"string", "text", "layout", ""}, {"integer", "columns", "validate", integer0}, {"boolean", "editable", "paint", Boolean.TRUE}, {"integer", "start", "layout", integer0}, {"integer", "end", "layout", integer0}, {"method", "action"}, {"method", "insert"}, {"method", "remove"}, {"method", "caret"}, {"method", "perform"}}, "passwordfield", "textfield", null, "textarea", "textfield", new Object[][]{{"integer", "rows", "validate", integer0}, {"boolean", "border", "validate", Boolean.TRUE}, {"boolean", "wrap", "layout", Boolean.FALSE}}, "tabbedpane", "component", new Object[][]{{"choice", "placement", "validate", new String[]{"top", "left", "bottom", "right", "stacked"}}, {"integer", "selected", "paint", integer0}, {"method", "action"}}, "tab", "choice", new Object[][]{{"integer", "mnemonic", "paint", integer_1}}, "panel", "component", new Object[][]{{"integer", "columns", "validate", integer0}, {"integer", "top", "validate", integer0}, {"integer", "left", "validate", integer0}, {"integer", "bottom", "validate", integer0}, {"integer", "right", "validate", integer0}, {"integer", "gap", "validate", integer0}, {"string", "text", "validate", null}, {"icon", "icon", "validate", null}, {"boolean", "border", "validate", Boolean.FALSE}, {"boolean", "scrollable", "validate", Boolean.FALSE}}, "desktop", "component", null, "dialog", "panel", new Object[][]{{"boolean", "modal", null, Boolean.FALSE}, {"boolean", "resizable", null, Boolean.FALSE}, {"method", "close"}, {"boolean", "maximizable", "paint", Boolean.FALSE}, {"boolean", "iconifiable", "paint", Boolean.FALSE}, {"boolean", "closable", null, Boolean.FALSE}}, "spinbox", "textfield", new Object[][]{{"integer", "minimum", null, new Integer(Integer.MIN_VALUE)}, {"integer", "maximum", null, new Integer(Integer.MAX_VALUE)}, {"integer", "step", null, integer1}, {"integer", "value", null, integer0}}, "progressbar", "component", new Object[][]{{"choice", "orientation", "validate", orientation}, {"integer", "minimum", "paint", integer0}, {"integer", "maximum", "paint", new Integer(100)}, {"integer", "value", "paint", integer0}}, "slider", "progressbar", new Object[][]{{"integer", "unit", null, new Integer(5)}, {"integer", "block", null, new Integer(25)}, {"method", "action"}}, "splitpane", "component", new Object[][]{{"choice", "orientation", "validate", orientation}, {"integer", "divider", "layout", integer_1}}, "list", "component", new Object[][]{{"choice", "selection", "paint", selections}, {"method", "action"}, {"method", "perform"}, {"boolean", "line", "validate", Boolean.TRUE}}, "item", "choice", new Object[][]{{"boolean", "selected", null, Boolean.FALSE}}, "table", "list", new Object[0][], "header", null, new Object[][]{{"method", "action"}, {"boolean", "resizable", null, Boolean.TRUE}}, "column", "choice", new Object[][]{{"integer", "width", null, new Integer(80)}, {"choice", "sort", null, new String[]{"none", "ascent", "descent"}}, {"boolean", "selected", null, Boolean.FALSE}}, "row", null, new Object[][]{{"boolean", "selected", null, Boolean.FALSE}}, "cell", "choice", null, "tree", "list", new Object[][]{{"boolean", "angle", null, Boolean.FALSE}, {"method", "expand"}, {"method", "collapse"}}, "node", "choice", new Object[][]{{"boolean", "selected", null, Boolean.FALSE}, {"boolean", "expanded", null, Boolean.TRUE}}, "separator", "component", null, "menubar", "component", new Object[][]{{"choice", "placement", "validate", new String[]{"top", "bottom"}}}, "menu", "choice", new Object[][]{{"integer", "mnemonic", "paint", integer_1}}, "menuitem", "choice", new Object[][]{{"keystroke", "accelerator", null, null}, {"method", "action"}, {"integer", "mnemonic", "paint", integer_1}}, "checkboxmenuitem", "menuitem", new Object[][]{{"boolean", "selected", "paint", Boolean.FALSE}, {"string", "group", "paint", null}}, "popupmenu", "component", new Object[][]{{"method", "menushown"}}, "bean", "component", new Object[][]{{"bean", "bean", null, null}}};
        components = new String[]{"bean", "button", "checkbox", "combobox", "desktop", "dialog", "label", "list", "menubar", "panel", "passwordfield", "popupmenu", "progressbar", "separator", "slider", "spinbox", "splitpane", "tabbedpane", "table", "textarea", "textfield", "togglebutton", "tree"};
        allowedSubWidgets = new Object[]{"bean", new String[]{"popupmenu"}, "button", new String[]{"popupmenu"}, "cell", new String[0], "checkbox", new String[]{"popupmenu"}, "checkboxmenuitem", new String[0], "choice", new String[0], "column", new String[0], "combobox", new String[]{"choice", "popupmenu"}, "desktop", components, "dialog", components, "header", new String[]{"column"}, "item", new String[0], "label", new String[]{"popupmenu"}, "list", new String[]{"item", "popupmenu"}, "menu", new String[]{"menu", "menuitem", "checkboxmenuitem", "separator"}, "menubar", new String[]{"menu"}, "menuitem", new String[0], "node", new String[]{"node"}, "panel", components, "passwordfield", new String[]{"popupmenu"}, "popupmenu", new String[]{"menu", "menuitem", "checkboxmenuitem", "separator"}, "progressbar", new String[]{"popupmenu"}, "row", new String[]{"cell"}, "separator", new String[]{"popupmenu"}, "slider", new String[]{"popupmenu"}, "spinbox", new String[]{"popupmenu"}, "splitpane", components, "tab", components, "tabbedpane", new String[]{"tab", "popupmenu"}, "table", new String[]{"row", "header", "popupmenu"}, "textarea", new String[]{"popupmenu"}, "textfield", new String[]{"popupmenu"}, "togglebutton", new String[]{"popupmenu"}, "tree", new String[]{"node", "popupmenu"}};
        widgets = new HashMap();
        for (i = 0; i < dtd.length; i += 3) {
            classname = (String)dtd[i];
            Widget widget2 = new Widget(classname);
            widgets.put(classname, widget2);
            Object[][] propDefs = (Object[][])dtd[i + 2];
            Property[] properties = new Property[]{};
            if (propDefs != null) {
                TreeSet<Property> props = new TreeSet<Property>();
                for (int j = 0; j < propDefs.length; ++j) {
                    String type = (String)propDefs[j][0];
                    String name = (String)propDefs[j][1];
                    Object defaultValue = propDefs[j].length > 3 ? propDefs[j][3] : null;
                    props.add(new Property(widget2, name, type, defaultValue));
                }
                properties = props.toArray(new Property[props.size()]);
            }
            widget2.setProperties(properties);
        }
        for (i = 0; i < dtd.length; i += 3) {
            classname = (String)dtd[i];
            String parentclassname = (String)dtd[i + 1];
            widget = (Widget)widgets.get(classname);
            Widget parentWidget = (Widget)widgets.get(parentclassname);
            widget.setParent(parentWidget);
        }
        for (i = 0; i < allowedSubWidgets.length; i += 2) {
            classname = (String)allowedSubWidgets[i];
            String[] allowed = (String[])allowedSubWidgets[i + 1];
            if (allowed.length <= 0) continue;
            widget = (Widget)widgets.get(classname);
            for (int j = 0; j < allowed.length; ++j) {
                Widget allowedWidget = (Widget)widgets.get(allowed[j]);
                widget.addAllowedSubWidget(allowedWidget);
            }
        }
    }

    public static class Property
    implements Comparable {
        public static final int STRING = 0;
        public static final int INTEGER = 1;
        public static final int BOOLEAN = 2;
        public static final int CHOICE = 3;
        public static final int COLOR = 4;
        public static final int ICON = 5;
        public static final int FONT = 6;
        public static final int KEYSTROKE = 7;
        public static final int METHOD = 8;
        public static final int BEAN = 9;
        public static final int PROPERTY = 10;
        public static final int COMPONENT = 11;
        private static final String[] allTypes = new String[]{"string", "integer", "boolean", "choice", "color", "icon", "font", "keystroke", "method", "bean", "property", "component"};
        private Widget widget;
        private String name;
        private int type;
        private Object defaultValue;

        Property(Widget widget, String name, String type, Object defaultValue) {
            this.widget = widget;
            this.name = name;
            this.defaultValue = defaultValue;
            this.type = -1;
            for (int i = 0; i < allTypes.length; ++i) {
                if (!allTypes[i].equals(type)) continue;
                this.type = i;
                break;
            }
            if (this.type == -1) {
                throw new IllegalArgumentException("unknown property type: " + type);
            }
        }

        public Widget getWidget() {
            return this.widget;
        }

        public int getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public Object getDefaultValue() {
            return this.type == 3 ? this.getChoices()[0] : this.defaultValue;
        }

        public String[] getChoices() {
            return this.type == 3 ? (String[])this.defaultValue : null;
        }

        public String getTypeName() {
            return Property.getTypeName(this.getType());
        }

        public static String getTypeName(int type) {
            return allTypes[type];
        }

        public boolean equals(Object obj) {
            if (obj instanceof Property) {
                Property prop = (Property)obj;
                return this.getWidget().equals(prop.getWidget()) && this.getName().equals(prop.getName());
            }
            return false;
        }

        public int hashCode() {
            return this.getWidget().hashCode() * 3 + this.getName().hashCode() + 7;
        }

        public int compareTo(Object obj) {
            Property other = (Property)obj;
            return this.getName().compareTo(other.getName());
        }

        public String toString() {
            return this.getName();
        }
    }

    public static class Widget
    implements Comparable {
        private String classname;
        private Widget parent;
        private Property[] properties;
        private ArrayList allowedSubWidgets = new ArrayList();
        private boolean allPropertiesCalculated = false;
        private HashMap propMap = new HashMap();

        Widget(String classname) {
            this.classname = classname;
        }

        void setProperties(Property[] properties) {
            this.properties = properties;
        }

        void setParent(Widget parent) {
            this.parent = parent;
        }

        void addAllowedSubWidget(Widget w) {
            this.allowedSubWidgets.add(w);
        }

        public String getClassname() {
            return this.classname;
        }

        public Widget getParent() {
            return this.parent;
        }

        public String getParentClassname() {
            return this.getParent() != null ? this.getParent().getClassname() : null;
        }

        public Property getProperty(String propName) {
            this.calculateAllProperties();
            return (Property)this.propMap.get(propName);
        }

        public boolean hasProperty(String propName) {
            return this.getProperty(propName) != null;
        }

        public Property[] getProperties() {
            this.calculateAllProperties();
            return this.properties;
        }

        public Widget[] getAllowedSubWidgets() {
            return this.allowedSubWidgets.toArray(new Widget[this.allowedSubWidgets.size()]);
        }

        public boolean isSubWidgetAllowed(Widget subWidget) {
            return this.isSubWidgetAllowed(subWidget.getClassname());
        }

        public boolean isSubWidgetAllowed(String classname) {
            Iterator it = this.allowedSubWidgets.iterator();
            while (it.hasNext()) {
                if (!classname.equals(((Widget)it.next()).getClassname())) continue;
                return true;
            }
            return false;
        }

        public boolean isInstanceOf(String classname) {
            if (classname.equals(this.getClassname())) {
                return true;
            }
            if (this.getParent() == null) {
                return false;
            }
            return this.getParent().isInstanceOf(classname);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Widget) {
                return this.getClassname().equals(((Widget)obj).getClassname());
            }
            return false;
        }

        public int hashCode() {
            return this.getClassname().hashCode() + 7;
        }

        public int compareTo(Object obj) {
            Widget other = (Widget)obj;
            return this.getClassname().compareTo(other.getClassname());
        }

        public String toString() {
            return this.getClassname();
        }

        private void calculateAllProperties() {
            if (!this.allPropertiesCalculated) {
                TreeSet<Property> set = new TreeSet<Property>();
                for (Widget widget = this; widget != null; widget = widget.getParent()) {
                    set.addAll(Arrays.asList(widget.properties));
                }
                this.properties = set.toArray(new Property[set.size()]);
                for (int i = 0; i < this.properties.length; ++i) {
                    this.propMap.put(this.properties[i].getName(), this.properties[i]);
                }
                this.allPropertiesCalculated = true;
            }
        }
    }
}

