/*
 * Decompiled with CFR 0.152.
 */
package thinletcommons;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.filechooser.FileSystemView;
import thinlet.Thinlet;
import thinletcommons.AntiAliasedThinlet;
import thinletcommons.ThinletDialog;

public class DirChooser {
    private static final Logger log = Logger.getLogger("thinletcommons");
    private ThinletDialog dialog;
    private Thinlet thinlet;
    private File selectedDir;
    private File expandDir;
    private boolean isInitialized = false;
    private FileSystemView fsv = FileSystemView.getFileSystemView();

    private static final boolean debug() {
        return log.isLoggable(Level.FINE);
    }

    public DirChooser(Frame owner, String title) {
        this.dialog = new ThinletDialog(owner, title);
        this.init();
    }

    public DirChooser(Dialog owner, String title) {
        this.dialog = new ThinletDialog(owner, title);
        this.init();
    }

    private void init() {
        this.thinlet = new AntiAliasedThinlet();
        try {
            Object panel = this.thinlet.parse("/thinletcommons/dirchooser.xml", (Object)this);
            this.thinlet.add(panel);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error parsing dirchooser.xml", e);
        }
        this.dialog.setContent(this.thinlet);
    }

    public void show() {
        this.selectedDir = null;
        if (this.expandDir != null) {
            this.expandTreeTo(this.expandDir);
            this.expandDir = null;
        }
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(this.dialog.getOwner());
        this.dialog.setVisible(true);
    }

    public void setSelectedDirectory(File dir) {
        this.expandDir = dir;
    }

    public File getSelectedDirectory() {
        return this.selectedDir;
    }

    public void init(Object tree) {
        if (DirChooser.debug()) {
            log.fine("in init()");
        }
        if (!this.isInitialized) {
            this.addFiles(this.fsv.getRoots(), tree);
            this.isInitialized = true;
        }
    }

    public void ok(Object tree) {
        Object node = this.thinlet.getSelectedItem(tree);
        if (node != null) {
            this.selectedDir = (File)this.thinlet.getProperty(node, (Object)"file");
        }
        this.close();
    }

    public void close() {
        this.dialog.setVisible(false);
    }

    public void nodeExpanded(Object tree, Object node) {
        File file = (File)this.thinlet.getProperty(node, (Object)"file");
        this.thinlet.removeAll(node);
        File[] files = this.fsv.getFiles(file, false);
        this.addFiles(files, node);
    }

    private void addFiles(File[] files, Object parent) {
        this.sort(files);
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (!this.fsv.isTraversable(file).booleanValue()) continue;
            Object node = this.createNode(file);
            this.thinlet.setBoolean(node, "expanded", false);
            this.thinlet.add(parent, node);
            Object placeholder = Thinlet.create((String)"node");
            this.thinlet.setBoolean(placeholder, "expanded", false);
            this.thinlet.setString(placeholder, "text", "#Placeholder#");
            this.thinlet.add(node, placeholder);
        }
    }

    private Object createNode(File file) {
        Object node = Thinlet.create((String)"node");
        this.thinlet.setString(node, "text", this.fsv.getSystemDisplayName(file));
        Icon icon = this.fsv.getSystemIcon(file);
        if (icon != null) {
            this.thinlet.setIcon(node, "icon", DirChooser.convertIconToImage(this.thinlet, icon));
        }
        this.thinlet.putProperty(node, (Object)"file", (Object)file);
        return node;
    }

    private void sort(File[] files) {
        if (files.length == 0) {
            return;
        }
        File firstFile = files[0];
        if (this.fsv.isComputerNode(firstFile) || this.fsv.isDrive(firstFile) || this.fsv.isFileSystemRoot(firstFile) || this.fsv.isFloppyDrive(firstFile) || this.fsv.isRoot(firstFile)) {
            return;
        }
        Arrays.sort(files, new Comparator(){
            private Collator collator = Collator.getInstance();

            public int compare(Object obj1, Object obj2) {
                return this.collator.compare(DirChooser.this.fsv.getSystemDisplayName((File)obj1), DirChooser.this.fsv.getSystemDisplayName((File)obj2));
            }

            @Override
            public boolean equals(Object other) {
                return false;
            }
        });
    }

    private void expandTreeTo(File file) {
        Stack<File> stack = new Stack<File>();
        stack.push(file);
        File root = null;
        File parent = file;
        do {
            if ((parent = this.fsv.getParentDirectory(parent)) == null) continue;
            stack.push(parent);
            root = parent;
        } while (parent != null);
        if (root == null) {
            log.warning("cannot expand to directory '" + file + "' because parent not found!");
            return;
        }
        Object tree = this.thinlet.find("tree");
        this._expandTreeTo(tree, stack);
    }

    private void _expandTreeTo(Object node, Stack stack) {
        File currentDir = (File)stack.pop();
        Object[] nodes = this.thinlet.getItems(node);
        boolean found = false;
        for (int i = 0; i < nodes.length; ++i) {
            Object subnode = nodes[i];
            File file = (File)this.thinlet.getProperty(subnode, (Object)"file");
            if (found || !file.equals(currentDir)) continue;
            this.thinlet.removeAll(subnode);
            File[] subfiles = this.fsv.getFiles(file, false);
            this.addFiles(subfiles, subnode);
            if (stack.empty()) {
                this.thinlet.setBoolean(subnode, "selected", true);
                continue;
            }
            this.thinlet.setBoolean(subnode, "expanded", true);
            this._expandTreeTo(subnode, stack);
            found = true;
        }
    }

    private static Image convertIconToImage(Thinlet thinlet, Icon icon) {
        BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        icon.paintIcon((Component)thinlet, image.getGraphics(), 0, 0);
        return image;
    }
}

