/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.awt.AWTKeyStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.KeyEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AWTUtils {
    private static final Logger log = Logger.getLogger("thinletcommons");
    private static HashMap keyDescriptions = new HashMap();

    private static final boolean debug() {
        return log.isLoggable(Level.FINE);
    }

    public static String getColorString(Color c) {
        int red = c.getRed();
        int green = c.getGreen();
        int blue = c.getBlue();
        StringBuffer s = new StringBuffer("#");
        if (red < 10) {
            s.append("0");
        }
        s.append(Integer.toHexString(red));
        if (green < 10) {
            s.append("0");
        }
        s.append(Integer.toHexString(green));
        if (blue < 10) {
            s.append("0");
        }
        s.append(Integer.toHexString(blue));
        return s.toString();
    }

    public static String getFontString(Font font) {
        StringBuffer s = new StringBuffer();
        s.append(font.getFamily());
        s.append(" ");
        s.append(font.getSize());
        if (font.isItalic()) {
            s.append(" italic");
        }
        if (font.isBold()) {
            s.append(" bold");
        }
        return s.toString();
    }

    public static String getFontString(Font font, Font defaultFont) {
        StringBuffer s = new StringBuffer();
        if (!font.getFamily().equals(defaultFont.getFamily())) {
            s.append(font.getFamily());
        }
        if (font.getSize() != defaultFont.getSize()) {
            if (s.length() > 0) {
                s.append(' ');
            }
            s.append(font.getSize());
        }
        if (font.isItalic() != defaultFont.isItalic()) {
            if (s.length() > 0) {
                s.append(' ');
            }
            s.append("italic");
        }
        if (font.isBold() != defaultFont.isBold()) {
            if (s.length() > 0) {
                s.append(' ');
            }
            s.append("bold");
        }
        return s.toString();
    }

    public static Frame getFrame(Component comp) {
        while (comp != null && !Frame.class.isInstance(comp)) {
            comp = comp.getParent();
        }
        return (Frame)comp;
    }

    public static Dimension getBounds(String text, Component component) {
        Graphics2D graphics = (Graphics2D)component.getGraphics();
        StringTokenizer st = new StringTokenizer(text, "\n", true);
        Dimension dim = new Dimension(0, 0);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals("\n")) {
                token = "W";
            }
            TextLayout textLayout = new TextLayout(token, component.getFont(), graphics != null ? graphics.getFontRenderContext() : new FontRenderContext(null, true, false));
            Rectangle2D rect = textLayout.getBounds();
            dim.height += (int)rect.getHeight();
            dim.width = Math.max(dim.width, (int)rect.getWidth());
        }
        return dim;
    }

    public static Image getIcon(Component component, String path) {
        URL url = component.getClass().getResource(path);
        return AWTUtils.getIcon(component, url);
    }

    public static Image getIcon(Component component, URL url) {
        if (AWTUtils.debug()) {
            log.fine("loading icon url=" + url + "...");
        }
        Image icon = component.getToolkit().getImage(url);
        MediaTracker mediatracker = new MediaTracker(component);
        mediatracker.addImage(icon, 1);
        try {
            mediatracker.waitForID(1);
        }
        catch (InterruptedException e) {
            log.warning("loading of icon " + url + " has been interrupted!");
        }
        return icon;
    }

    public static String getAWTKeyStrokeDescription(AWTKeyStroke k) {
        StringBuffer buf = new StringBuffer();
        int mod = k.getModifiers();
        if ((mod & 0x200) != 0 || (mod & 8) != 0) {
            buf.append("alt ");
        }
        if ((mod & 0x2000) != 0 || (mod & 0x20) != 0) {
            buf.append("altGraph ");
        }
        if ((mod & 0x100) != 0 || (mod & 4) != 0) {
            buf.append("meta ");
        }
        if ((mod & 0x80) != 0 || (mod & 2) != 0) {
            buf.append("ctrl ");
        }
        if ((mod & 0x40) != 0 || (mod & 1) != 0) {
            buf.append("shift ");
        }
        buf.append(AWTUtils.getKeyText(k.getKeyCode()));
        return buf.toString();
    }

    public static String getKeyText(int keyCode) {
        String desc = (String)keyDescriptions.get(new Integer(keyCode));
        if (desc == null) {
            log.warning("KeyEvent field for keyCode " + keyCode + " not found!" + " Returning default description.");
            return KeyEvent.getKeyText(keyCode);
        }
        return desc;
    }

    static {
        Field[] fields = KeyEvent.class.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            int modifiers = field.getModifiers();
            if ((modifiers & 9) == 0 || !field.getName().startsWith("VK_")) continue;
            try {
                int keyCode = field.getInt(null);
                String keyDescription = field.getName().substring(3);
                keyDescriptions.put(new Integer(keyCode), keyDescription);
                continue;
            }
            catch (IllegalAccessException e) {
                log.log(Level.SEVERE, "can't get value of field " + field, e);
            }
        }
    }
}

