/*
 * Decompiled with CFR 0.152.
 */
package examples;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.postgis.java2d.Java2DWrapper;

public class TestJava2d {
    private static final boolean DEBUG = true;
    public static final Shape[] SHAPEARRAY = new Shape[0];

    public static void main(String[] args) throws ClassNotFoundException, SQLException {
        Shape[] geometries;
        if (args.length != 5) {
            System.err.println("Usage: java examples/TestJava2D dburl user pass tablename column");
            System.err.println();
            System.err.println("dburl has the following format:");
            System.err.println("jdbc:postgis_j2d://HOST:PORT/DATABASENAME");
            System.err.println("tablename is 'jdbc_test' by default.");
            System.exit(1);
        }
        if ((geometries = TestJava2d.read(args[0], args[1], args[2], "SELECT " + args[4] + " FROM " + args[3])).length == 0) {
            System.err.println("No geometries were found.");
            return;
        }
        System.err.println("Painting...");
        Frame window = new Frame("PostGIS java2D demo");
        GisCanvas CV = new GisCanvas(geometries);
        window.add(CV);
        window.setSize(500, 500);
        window.addWindowListener(new EventHandler());
        window.setVisible(true);
    }

    static Rectangle2D calcbbox(Shape[] geometries) {
        Rectangle2D bbox = geometries[0].getBounds2D();
        for (int i = 1; i < geometries.length; ++i) {
            bbox = bbox.createUnion(geometries[i].getBounds2D());
        }
        return bbox;
    }

    private static Shape[] read(String dburl, String dbuser, String dbpass, String query) throws ClassNotFoundException, SQLException {
        ArrayList<Shape> geometries = new ArrayList<Shape>();
        System.out.println("Creating JDBC connection...");
        Class.forName("org.postgresql.Driver");
        Connection conn = DriverManager.getConnection(dburl, dbuser, dbpass);
        System.out.println("fetching geometries");
        ResultSet r = conn.createStatement().executeQuery(query);
        while (r.next()) {
            Shape current = (Shape)r.getObject(1);
            if (current == null) continue;
            geometries.add(current);
        }
        conn.close();
        return geometries.toArray(SHAPEARRAY);
    }

    static {
        new Java2DWrapper();
    }

    public static class EventHandler
    implements WindowListener {
        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowClosed(WindowEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            e.getWindow().setVisible(false);
            System.exit(0);
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }
    }

    public static class GisCanvas
    extends Canvas {
        private static final long serialVersionUID = 1L;
        final Rectangle2D bbox;
        final Shape[] geometries;

        public GisCanvas(Shape[] geometries) {
            this.geometries = geometries;
            this.bbox = TestJava2d.calcbbox(geometries);
            this.setBackground(Color.GREEN);
        }

        @Override
        public void paint(Graphics og) {
            Graphics2D g = (Graphics2D)og;
            double scaleX = (double)(super.getWidth() - 10) / this.bbox.getWidth();
            double scaleY = (double)(super.getHeight() - 10) / this.bbox.getHeight();
            AffineTransform at = new AffineTransform();
            at.translate(super.getX() + 5, super.getY() + 5);
            at.scale(scaleX, scaleY);
            at.translate(-this.bbox.getX(), -this.bbox.getY());
            System.err.println();
            System.err.println("bbox:  " + this.bbox);
            System.err.println("trans: " + at);
            System.err.println("new:   " + at.createTransformedShape(this.bbox).getBounds2D());
            System.err.println("visual:" + super.getBounds());
            for (int i = 0; i < this.geometries.length; ++i) {
                g.setPaint(Color.BLUE);
                Shape shape = at.createTransformedShape(this.geometries[i]);
                g.fill(shape);
                g.setPaint(Color.ORANGE);
                g.draw(shape);
            }
        }
    }
}

