/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.postgis_jts_osgi;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.orbisgis.postgis_jts_osgi.ConnectionWrapper;
import org.postgis.PGbox2d;
import org.postgis.PGbox3d;
import org.postgis.jts.JtsGeometry;
import org.postgresql.PGConnection;

public class DataSourceWrapper
implements DataSource {
    private DataSource pgDataSource;

    public DataSourceWrapper(DataSource pgDataSource) {
        this.pgDataSource = pgDataSource;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.pgDataSource.setLoginTimeout(seconds);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.configureConnection(this.pgDataSource.getConnection());
    }

    private Connection configureConnection(Connection connection) throws SQLException {
        if (connection instanceof PGConnection) {
            ((PGConnection)((Object)connection)).addDataType("geometry", JtsGeometry.class);
            ((PGConnection)((Object)connection)).addDataType("box3d", PGbox3d.class);
            ((PGConnection)((Object)connection)).addDataType("box2d", PGbox2d.class);
        }
        return new ConnectionWrapper(connection);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.configureConnection(this.pgDataSource.getConnection(username, password));
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.pgDataSource.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.pgDataSource.setLogWriter(out);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.pgDataSource.getLoginTimeout();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.pgDataSource.getParentLogger();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("Unsupported operation");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }
}

