/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.daltransform.app.mainplugin;

import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.daltransform.DataTransformLocator;
import org.gvsig.daltransform.DataTransformManager;
import org.gvsig.daltransform.swing.JDialogDataTransformList;
import org.gvsig.i18n.Messages;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTransformExtension
extends Extension {
    private static final Logger logger = LoggerFactory.getLogger(DataTransformExtension.class);

    public void execute(String actionCommand) {
        ApplicationManager application = ApplicationLocator.getManager();
        DataTransformManager manager = DataTransformLocator.getDataTransformManager();
        if ("CREATE".equalsIgnoreCase(actionCommand)) {
            try {
                PluginServices.getMDIManager().addWindow(manager.createWizard().getWindow());
            }
            catch (Exception e) {
                logger.info("Error while creating data transform wizard", (Throwable)e);
                ApplicationLocator.getManager().messageDialog(Messages.getText((String)"transform_create_wizard_exception") + ": " + e.getMessage(), Messages.getText((String)"feature_transform"), 0);
            }
        } else if ("VIEW".equalsIgnoreCase(actionCommand)) {
            if (application.getActiveDocument() == null) {
                JOptionPane.showMessageDialog(null, Messages.getText((String)"not_featurestore_loaded"), Messages.getText((String)"view_transforms"), 2);
                return;
            }
            JDialogDataTransformList dialog = manager.createJDialogDataTransformList();
            WindowManager wm = ToolsSwingLocator.getWindowManager();
            wm.showWindow((JComponent)dialog, Messages.getText((String)"view_transforms"), WindowManager.MODE.WINDOW);
        }
    }

    public void initialize() {
        IconThemeHelper.registerIcon((String)"feature-transform-tools", (String)"feature-transform-wizard", (Object)((Object)this));
    }

    public void postInitialize() {
        super.postInitialize();
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isVisible() {
        return true;
    }
}

