/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.daltransform.swing.impl;

import jwizardcomponent.FinishAction;
import jwizardcomponent.JWizardComponents;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.table.TableDocument;
import org.gvsig.app.project.documents.table.TableManager;
import org.gvsig.daltransform.swing.DataTransformGui;
import org.gvsig.daltransform.swing.impl.DefaultDataTransformWizard;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureStoreTransform;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontext.layers.LayerCollectionAdapter;
import org.gvsig.fmap.mapcontext.layers.LayerCollectionEvent;
import org.gvsig.fmap.mapcontext.layers.LayerCollectionListener;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontext.layers.vectorial.VectorLayer;
import org.gvsig.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTransformSelectionAction
extends FinishAction {
    private static final Logger logger = LoggerFactory.getLogger(DataTransformSelectionAction.class);
    private DefaultDataTransformWizard dataTransformWizard = null;

    public DataTransformSelectionAction(DefaultDataTransformWizard dataTransformWizard) {
        super((JWizardComponents)dataTransformWizard.getWizardComponents());
        this.dataTransformWizard = dataTransformWizard;
    }

    public void performAction() {
        boolean result_added_separately = this.dataTransformWizard.isLayerLoaded();
        DataTransformGui featureTransformGui = this.dataTransformWizard.getDataTransformGui();
        FeatureStore fsto = this.dataTransformWizard.getFeatureStore();
        try {
            FeatureStoreTransform fst = null;
            fst = featureTransformGui.createFeatureStoreTransform(fsto);
            fsto.getTransforms().add(fst);
            if (result_added_separately) {
                MapContextManager manager = MapContextLocator.getMapContextManager();
                final VectorLayer layer = (VectorLayer)manager.createLayer(featureTransformGui.toString(), (DataStore)fsto);
                MapContext mco = this.dataTransformWizard.getMapContext();
                if (mco != null) {
                    mco.getLayers().addLayer((FLayer)layer);
                } else {
                    ApplicationLocator.getManager().messageDialog(Messages.getText((String)"_Layer_was_not_added_to_any_view"), Messages.getText((String)"transform_apply"), 0);
                }
                ProjectManager projectManager = ApplicationLocator.getProjectManager();
                final TableManager tableManager = (TableManager)projectManager.getDocumentManager(TableManager.TYPENAME);
                TableDocument tableDoc = tableManager.getTableDocument(layer);
                if (tableDoc == null && (tableDoc = tableManager.getTableDocument(layer.getFeatureStore())) == null) {
                    tableDoc = (TableDocument)tableManager.createDocument();
                    tableDoc.setName(layer.getName());
                    tableDoc.setStore(layer.getFeatureStore());
                    layer.getParentLayer().addLayerCollectionListener((LayerCollectionListener)new LayerCollectionAdapter(){

                        public void layerRemoved(LayerCollectionEvent e) {
                            FLayer affectedLayer = e.getAffectedLayer();
                            if (layer == affectedLayer && layer instanceof FLyrVect) {
                                TableDocument tableDoc = tableManager.getTableDocument(layer);
                                tableDoc.setAssociatedLayer(null);
                                FLayers layers = layer.getParentLayer();
                                if (layers != null && layers.getLayersCount() == 0) {
                                    layers.removeLayerCollectionListener((LayerCollectionListener)this);
                                }
                            }
                        }
                    });
                    projectManager.getCurrentProject().addDocument((Document)tableDoc);
                }
                tableDoc.setAssociatedLayer(layer);
                layer.dispose();
            }
        }
        catch (Exception e) {
            logger.error("Error loading the layer", (Throwable)e);
        }
        PluginServices.getMDIManager().closeWindow((IWindow)this.dataTransformWizard);
    }
}

