/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.temporarystorage.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.gvsig.temporarystorage.TemporaryStorageGroup;

public class DefaultTemporaryStorageGroup
implements TemporaryStorageGroup {
    private final String name;
    private final Class classOfElements;
    private final List<Pair<String, Object>> elements;

    public DefaultTemporaryStorageGroup(String name, Class classOfElements) {
        this.name = name;
        this.classOfElements = classOfElements;
        this.elements = new ArrayList<Pair<String, Object>>();
    }

    public String getName() {
        return this.name;
    }

    public Class getClassOfElements() {
        return this.classOfElements;
    }

    private MutablePair<String, Object> getElement(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        for (Pair<String, Object> element : this.elements) {
            if (!name.equalsIgnoreCase((String)element.getKey())) continue;
            return (MutablePair)element;
        }
        return null;
    }

    public boolean contains(String name) {
        MutablePair<String, Object> element = this.getElement(name);
        return element != null;
    }

    public void put(String name, Object obj) {
        if (!this.classOfElements.isInstance(obj)) {
            throw new IllegalArgumentException("The object can't be of class " + this.classOfElements.getName() + ".");
        }
        MutablePair element = this.getElement(name);
        if (element == null) {
            element = new MutablePair((Object)name, obj);
            this.elements.add((Pair<String, Object>)element);
            this.elements.sort(new Comparator<Pair<String, Object>>(){

                @Override
                public int compare(Pair<String, Object> o1, Pair<String, Object> o2) {
                    return o1.compareTo(o2);
                }
            });
        } else {
            element.setValue(obj);
        }
    }

    public Object get(String name) {
        MutablePair<String, Object> element = this.getElement(name);
        if (element == null) {
            return null;
        }
        return element.getValue();
    }

    public boolean remove(String name) {
        MutablePair<String, Object> element = this.getElement(name);
        if (element == null) {
            return false;
        }
        return this.elements.remove(element);
    }

    public List<Pair<String, Object>> asList() {
        return Collections.unmodifiableList(this.elements);
    }
}

