/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.json.simplereaders;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.store.json.JsonStoreParameters;
import org.gvsig.fmap.dal.store.simplereader.simplereaders.AbstractSimpleReader;
import org.gvsig.json.Json;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonReader
extends AbstractSimpleReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonReader.class);
    private JsonArray jsonData;
    private int columns;
    private String[] header;
    private int currentElement = 0;
    private final JsonStoreParameters parameters;

    public JsonReader(Reader reader, JsonStoreParameters theParameters) throws IOException {
        String input = IOUtils.toString((Reader)reader);
        this.jsonData = Json.createArray((String)input);
        this.columns = -1;
        this.header = null;
        this.parameters = theParameters;
        if (StringUtils.isBlank((CharSequence)((CharSequence)this.parameters.getDynValue("header")))) {
            this.parameters.setDynValue("header", StringUtils.join((Object[])this.getHeader(), (char)','));
        }
    }

    public String[] getHeader() throws IOException {
        if (this.header == null) {
            JsonObject firstItem = this.jsonData.getJsonObject(0);
            String[] theHeader = new String[firstItem.size()];
            int i = 0;
            for (String item : firstItem.keySet()) {
                theHeader[i++] = item;
            }
            this.header = theHeader;
        }
        return this.header;
    }

    public int getColumnsCount() throws IOException {
        if (this.columns <= 0) {
            this.columns = this.getHeader().length;
        }
        return this.columns;
    }

    public List<String> read() throws IOException {
        List<String> values = this.read(this.currentElement);
        if (values == null) {
            return null;
        }
        ++this.currentElement;
        return values;
    }

    public List<String> read(int rowNumber) throws IOException {
        ArrayList<String> values = new ArrayList<String>();
        if (rowNumber < this.jsonData.size()) {
            JsonObject feature = this.jsonData.getJsonObject(rowNumber);
            block6: for (String columName : this.getHeader()) {
                if (feature.isNull(columName)) {
                    values.add("");
                    continue;
                }
                JsonValue value = (JsonValue)feature.get((Object)columName);
                switch (value.getValueType()) {
                    case FALSE: {
                        values.add("false");
                        continue block6;
                    }
                    case STRING: {
                        values.add(((JsonString)value).getString());
                        continue block6;
                    }
                    case TRUE: {
                        values.add("true");
                        continue block6;
                    }
                    case NULL: {
                        values.add("");
                        continue block6;
                    }
                    default: {
                        values.add(value.toString());
                    }
                }
            }
            return values;
        }
        return null;
    }

    public void close() throws IOException {
        this.jsonData = null;
    }

    public List<String> skip(int lines) throws IOException {
        this.currentElement += lines;
        if (this.currentElement > this.jsonData.size()) {
            return null;
        }
        return this.read(this.currentElement);
    }

    public int getLine() {
        if (this.jsonData == null) {
            return 0;
        }
        return this.currentElement;
    }

    public List<String> nextRowValues() {
        try {
            return this.read();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

