/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension;

import java.util.prefs.Preferences;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.andami.preferences.IPreference;
import org.gvsig.andami.preferences.IPreferenceExtension;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.gui.preferencespage.GridPage;
import org.gvsig.app.gui.preferencespage.SnapConfigPage;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.gui.DefaultViewPanel;
import org.gvsig.app.project.documents.view.gui.ViewSnappingPropertiesPageFactory;
import org.gvsig.app.project.documents.view.toolListeners.snapping.Snapping;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontext.layers.LayersIterator;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontrol.MapControlLocator;
import org.gvsig.fmap.mapcontrol.MapControlManager;
import org.gvsig.fmap.mapcontrol.tools.snapping.snappers.ISnapper;
import org.gvsig.propertypage.PropertiesPageFactory;
import org.gvsig.propertypage.PropertiesPageManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;

public class SnappingExtension
extends Extension
implements IPreferenceExtension {
    private IPreference[] preferencePages = null;

    public void initialize() {
        Snapping.register();
        this.registerIcons();
        MapControlManager mapControlManager = MapControlLocator.getMapControlManager();
        for (int n = 0; n < mapControlManager.getSnapperCount(); ++n) {
            ISnapper snp = mapControlManager.getSnapperAt(n);
            String nameClass = snp.getClass().getName();
            nameClass = nameClass.substring(nameClass.lastIndexOf(46) + 1);
            snp.setEnabled(((Boolean)this.getPlugin().getPluginProperties().getDynValue("snapperActivated" + nameClass)).booleanValue());
            snp.setPriority(((Integer)this.getPlugin().getPluginProperties().getDynValue("snapperPriority" + nameClass)).intValue());
        }
        Integer snapTolerance = (Integer)this.getPlugin().getPluginProperties().getDynValue("snapTolerance");
        mapControlManager.setTolerance(snapTolerance.intValue());
        Boolean applySnappers = (Boolean)this.getPlugin().getPluginProperties().getDynValue("applySnappers");
        Preferences prefs = Preferences.userRoot().node("snappers");
        prefs.putBoolean("apply-snappers", applySnappers);
        PropertiesPageManager manager = MapControlLocator.getPropertiesPageManager();
        manager.registerFactory((PropertiesPageFactory)new ViewSnappingPropertiesPageFactory());
    }

    public void postInitialize() {
    }

    private void registerIcons() {
        ToolsSwingUtils.registerIcons(((Object)((Object)this)).getClass(), (String)"/images/action", (String)this.getPlugin().getPluginName(), (String[][])new String[][]{{"action", "enable-snapping", "snapping"}, {"action", "disable-snapping", "snapping"}});
        ToolsSwingUtils.registerIcons(((Object)((Object)this)).getClass(), (String)"/images/preferences", (String)this.getPlugin().getPluginName(), (String[][])new String[][]{{"preferences", "preferences-snapper", "snapping"}, {"preferences", "grid-preferences", "snapping"}});
    }

    public void execute(String actionCommand) {
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isVisible() {
        IWindow f = PluginServices.getMDIManager().getActiveWindow();
        if (f != null && f instanceof DefaultViewPanel) {
            DefaultViewPanel vista = (DefaultViewPanel)f;
            ViewDocument model = vista.getViewDocument();
            MapContext mapa = model.getMapContext();
            FLayers capas = mapa.getLayers();
            int numActiveVectorial = 0;
            int numActiveVectorialEditable = 0;
            LayersIterator iter = new LayersIterator((FLayer)capas);
            while (iter.hasNext()) {
                FLayer capa = iter.nextLayer();
                if (!(capa instanceof FLyrVect) || !capa.isActive() || !capa.isAvailable()) continue;
                ++numActiveVectorial;
                if (!capa.isEditing()) continue;
                ++numActiveVectorialEditable;
            }
            if (numActiveVectorialEditable == 1 && numActiveVectorial == 1) {
                return true;
            }
        }
        return false;
    }

    public IPreference[] getPreferencesPages() {
        if (this.preferencePages == null) {
            this.preferencePages = new IPreference[]{new SnapConfigPage(), new GridPage()};
        }
        return this.preferencePages;
    }
}

