/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.gui.preferencespage;

import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.PluginsManager;
import org.gvsig.andami.preferences.AbstractPreferencePage;
import org.gvsig.andami.preferences.StoreException;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.documents.view.gui.DefaultViewPanel;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.tools.grid.Grid;
import org.gvsig.tools.dynobject.DynObject;

public class GridPage
extends AbstractPreferencePage {
    public static final String ID = GridPage.class.getName();
    private MapControl mapControl;
    private JCheckBox chkShowGrid;
    private JCheckBox chkAdjustGrid;
    private JTextField txtDistanceX;
    private JTextField txtDistanceY;
    private JLabel lblUnits = new JLabel();
    private ImageIcon icon;
    private DynObject pluginProperties;
    private PluginServices plugin;

    public GridPage() {
        PluginsManager pluginManager = PluginsLocator.getManager();
        this.plugin = pluginManager.getPlugin((Object)this);
        this.pluginProperties = this.plugin.getPluginProperties();
        this.icon = IconThemeHelper.getImageIcon((String)"grid-preferences");
        this.chkShowGrid = new JCheckBox(PluginServices.getText((Object)((Object)this), (String)"mostrar_rejilla"));
        this.addComponent(this.chkShowGrid);
        this.chkAdjustGrid = new JCheckBox(PluginServices.getText((Object)((Object)this), (String)"ajustar_rejilla"));
        this.addComponent(this.chkAdjustGrid);
        this.addComponent(this.lblUnits);
        this.txtDistanceX = new JTextField("", 15);
        this.addComponent(PluginServices.getText((Object)((Object)this), (String)"distance_x") + ":", this.txtDistanceX);
        this.txtDistanceY = new JTextField("", 15);
        this.addComponent(PluginServices.getText((Object)((Object)this), (String)"distance_y") + ":", this.txtDistanceY);
    }

    public void initializeValues() {
        boolean showGrid = (Boolean)this.pluginProperties.getDynValue("showgrid");
        boolean adjustGrid = (Boolean)this.pluginProperties.getDynValue("adjustgrid");
        double dx = (Double)this.pluginProperties.getDynValue("griddistancex");
        double dy = (Double)this.pluginProperties.getDynValue("griddistancey");
        Grid.SHOWGRID = showGrid;
        Grid.ADJUSTGRID = adjustGrid;
        Grid.GRIDSIZEX = dx;
        Grid.GRIDSIZEY = dy;
        this.chkShowGrid.setSelected(showGrid);
        this.chkAdjustGrid.setSelected(adjustGrid);
        this.txtDistanceX.setText(String.valueOf(dx));
        this.txtDistanceY.setText(String.valueOf(dy));
    }

    public String getID() {
        return ID;
    }

    public String getTitle() {
        return PluginServices.getText((Object)((Object)this), (String)"Grid");
    }

    public JPanel getPanel() {
        return this;
    }

    public void storeValues() throws StoreException {
        double dy;
        double dx;
        boolean showGrid = this.chkShowGrid.isSelected();
        boolean adjustGrid = this.chkAdjustGrid.isSelected();
        try {
            dx = Double.parseDouble(this.txtDistanceX.getText());
            dy = Double.parseDouble(this.txtDistanceY.getText());
        }
        catch (Exception e) {
            throw new StoreException(PluginServices.getText((Object)((Object)this), (String)"distancia_malla_incorrecta"));
        }
        this.pluginProperties.setDynValue("showgrid", (Object)showGrid);
        this.pluginProperties.setDynValue("adjustgrid", (Object)adjustGrid);
        this.pluginProperties.setDynValue("griddistancex", (Object)dx);
        this.pluginProperties.setDynValue("griddistancey", (Object)dy);
        Grid.SHOWGRID = showGrid;
        Grid.ADJUSTGRID = adjustGrid;
        Grid.GRIDSIZEX = dx;
        Grid.GRIDSIZEY = dy;
        IWindow window = PluginServices.getMDIManager().getActiveWindow();
        if (window instanceof DefaultViewPanel) {
            MapControl mc = ((DefaultViewPanel)window).getMapControl();
            Grid cadGrid = mc.getGrid();
            cadGrid.setShowGrid(showGrid);
            cadGrid.setAdjustGrid(adjustGrid);
            cadGrid.setGridSizeX(dx);
            cadGrid.setGridSizeY(dy);
        }
    }

    public void initializeDefaults() {
        this.chkShowGrid.setSelected(Grid.DefaultShowGrid);
        this.chkAdjustGrid.setSelected(Grid.DefaultAdjustGrid);
        this.txtDistanceX.setText(String.valueOf(Grid.DefaultGridSizeX));
        this.txtDistanceY.setText(String.valueOf(Grid.DefaultGridSizeY));
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public boolean isValueChanged() {
        return super.hasChanged();
    }

    public void setChangesApplied() {
        this.setChanged(false);
    }
}

