/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.toolListeners.snapping.snappers;

import com.vividsolutions.jts.geom.Coordinate;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.PrimitivesDrawer;
import org.gvsig.fmap.mapcontrol.tools.snapping.snappers.ISnapperRaster;
import org.gvsig.fmap.mapcontrol.tools.snapping.snappers.impl.AbstractSnapper;
import org.gvsig.i18n.Messages;

public class PixelSnapper
extends AbstractSnapper
implements ISnapperRaster {
    private Color refColor = Color.BLACK;
    private int tolColorR = 100;
    private int tolColorG = 100;
    private int tolColorB = 100;

    public Point2D getSnapPoint(MapControl mapControl, Point2D point, double mapTolerance, Point2D lastPoint) {
        int toY;
        int toX;
        int fromY;
        BufferedImage img = mapControl.getImage();
        ViewPort vp = mapControl.getViewPort();
        Point2D pPixel = vp.fromMapPoint(point);
        int xPixel = (int)pPixel.getX();
        int yPixel = (int)pPixel.getY();
        int centerRGB = this.refColor.getRGB();
        double x1 = ColorModel.getRGBdefault().getRed(centerRGB);
        double y1 = ColorModel.getRGBdefault().getGreen(centerRGB);
        double z1 = ColorModel.getRGBdefault().getBlue(centerRGB);
        Coordinate c = new Coordinate(x1, y1, z1);
        int half = vp.fromMapDistance(mapTolerance) / 2;
        double minDistColor = Double.MAX_VALUE;
        int xSnapped = -1;
        int ySnapped = -1;
        int fromX = xPixel - half;
        if (fromX < 0) {
            fromX = 0;
        }
        if ((fromY = yPixel - half) < 0) {
            fromY = 0;
        }
        if ((toX = xPixel + half) > vp.getImageWidth()) {
            toX = vp.getImageWidth();
        }
        if ((toY = yPixel + half) > vp.getImageHeight()) {
            toY = vp.getImageHeight();
        }
        for (int testX = fromX; testX < toX; ++testX) {
            for (int testY = fromY; testY < toY; ++testY) {
                double dist;
                int testRGB = img.getRGB(testX, testY);
                int r = ColorModel.getRGBdefault().getRed(testRGB);
                int g = ColorModel.getRGBdefault().getGreen(testRGB);
                int b = ColorModel.getRGBdefault().getBlue(testRGB);
                Coordinate cAux = new Coordinate((double)r, (double)g, (double)b);
                if (!(Math.abs((double)r - x1) < (double)this.tolColorR) || !(Math.abs((double)g - y1) < (double)this.tolColorG) || !(Math.abs((double)b - z1) < (double)this.tolColorB) || !((dist = c.distance(cAux)) < minDistColor)) continue;
                minDistColor = dist;
                xSnapped = testX;
                ySnapped = testY;
            }
        }
        Point2D pResul = null;
        if (xSnapped != -1) {
            pResul = vp.toMapPoint(xSnapped, ySnapped);
        }
        return pResul;
    }

    public void draw(PrimitivesDrawer primitivesDrawer, Point2D pPixels) {
        primitivesDrawer.setColor(this.getColor());
        int half = this.getSizePixels() / 2;
        primitivesDrawer.drawOval((int)(pPixels.getX() - (double)half), (int)(pPixels.getY() - (double)half), this.getSizePixels(), this.getSizePixels());
    }

    public String getToolTipText() {
        return Messages.getText((String)"Pixel_point");
    }
}

