/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.newlayer.prov.jdbc.panels;

import javax.swing.JComponent;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.newlayer.NewLayerProviderPanel;
import org.gvsig.newlayer.NewLayerWizard;
import org.gvsig.newlayer.prov.jdbc.NewLayerJDBCProviderParameters;
import org.gvsig.newlayer.spi.NewLayerPanelValidationException;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;

public class JDBCConnectionPanel
implements NewLayerProviderPanel {
    private org.gvsig.fmap.dal.swing.jdbc.JDBCConnectionPanel connectionPanel;
    private final NewLayerJDBCProviderParameters parameters;
    private final NewLayerWizard wizard;

    public JDBCConnectionPanel(NewLayerWizard wizard, NewLayerJDBCProviderParameters parameters) {
        this.parameters = parameters;
        this.wizard = wizard;
        this.initComponents();
    }

    private void initComponents() {
        DataSwingManager manager = DALSwingLocator.getSwingManager();
        this.connectionPanel = manager.createJDBCConnectionPanel();
    }

    public void previousPanel() {
    }

    public void enterPanel() {
        if (this.parameters.getExplorerParameters() != null) {
            this.connectionPanel.setServerExplorerParameters(this.parameters.getExplorerParameters());
        }
    }

    public JDBCServerExplorerParameters getServerExplorerParameters() {
        return this.connectionPanel.getServerExplorerParametersAndRegister();
    }

    public String getIdPanel() {
        return this.getClass().getCanonicalName();
    }

    public String getTitlePanel() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        return i18nManager.getTranslation("connection_params");
    }

    public void nextPanel() {
        this.parameters.setExplorerParameters(this.getServerExplorerParameters());
    }

    public boolean validatePanel() throws NewLayerPanelValidationException {
        JDBCServerExplorerParameters connection = this.connectionPanel.getServerExplorerParametersWithoutRegister();
        if (connection == null) {
            return false;
        }
        try {
            connection.validate();
            this.parameters.setExplorerParameters(this.getServerExplorerParameters());
            return true;
        }
        catch (ValidateDataParametersException ex) {
            throw new NewLayerPanelValidationException(ex.getMessageStack(), (Throwable)ex);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public JComponent asJComponent() {
        return this.connectionPanel.asJComponent();
    }
}

