/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal;

import java.util.ArrayList;
import org.cresques.ProjectionLibrary;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLibrary;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.geom.GeometryLibrary;
import org.gvsig.metadata.MetadataLibrary;
import org.gvsig.metadata.MetadataLocator;
import org.gvsig.metadata.MetadataManager;
import org.gvsig.metadata.exceptions.MetadataException;
import org.gvsig.timesupport.TimeSupportLibrary;
import org.gvsig.tools.ToolsLibrary;
import org.gvsig.tools.library.AbstractLibrary;
import org.gvsig.tools.library.LibraryException;
import org.gvsig.tools.locator.Locator;
import org.gvsig.tools.locator.ReferenceNotRegisteredException;

public class DALLibrary
extends AbstractLibrary {
    public void doRegistration() {
        this.registerAsAPI(DALLibrary.class);
        this.require(ToolsLibrary.class);
        this.require(MetadataLibrary.class);
        this.require(ProjectionLibrary.class);
        this.require(GeometryLibrary.class);
        this.require(TimeSupportLibrary.class);
        this.require(ExpressionEvaluatorLibrary.class);
    }

    protected void doInitialize() throws LibraryException {
    }

    protected void doPostInitialize() throws LibraryException {
        ArrayList<MetadataException> exs = new ArrayList<MetadataException>();
        try {
            this.registerDataStoreMetadataDefinition();
        }
        catch (MetadataException e) {
            exs.add(e);
        }
        try {
            this.registerSpatialDataStoreMetadataDefinition();
        }
        catch (MetadataException e) {
            exs.add(e);
        }
        try {
            this.registerFeatureStoreMetadataDefinition();
        }
        catch (MetadataException e) {
            exs.add(e);
        }
        DataManager dataManager = DALLocator.getDataManager();
        if (dataManager == null) {
            throw new ReferenceNotRegisteredException("DataManager", (Locator)DALLocator.getInstance());
        }
        if (exs.size() > 0) {
            throw new LibraryException(((Object)((Object)this)).getClass(), exs);
        }
    }

    private void registerDataStoreMetadataDefinition() throws MetadataException {
        MetadataManager manager = MetadataLocator.getMetadataManager();
        if (manager.getDefinition("DataProvider") == null) {
            manager.addDefinition("DataProvider", DALLibrary.class.getResourceAsStream("MetadataDefinitions.xml"), DALLibrary.class.getClassLoader());
        }
    }

    private void registerSpatialDataStoreMetadataDefinition() throws MetadataException {
        MetadataManager manager = MetadataLocator.getMetadataManager();
        if (manager.getDefinition("SpatialProvider") == null) {
            manager.addDefinition("SpatialProvider", DALLibrary.class.getResourceAsStream("MetadataDefinitions.xml"), DALLibrary.class.getClassLoader());
        }
    }

    private void registerFeatureStoreMetadataDefinition() throws MetadataException {
        MetadataManager manager = MetadataLocator.getMetadataManager();
        if (manager.getDefinition("FeatureProvider") == null) {
            manager.addDefinition("FeatureProvider", DALLibrary.class.getResourceAsStream("MetadataDefinitions.xml"), DALLibrary.class.getClassLoader());
        }
    }
}

