/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal;

import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.feature.FeatureTypeDefinitionsManager;
import org.gvsig.fmap.dal.resource.ResourceManager;
import org.gvsig.tools.locator.AbstractLocator;
import org.gvsig.tools.locator.LocatorException;

public class DALLocator
extends AbstractLocator {
    private static final String LOCATOR_NAME = "DALLocator";
    public static final String DATA_MANAGER_NAME = "DataManager";
    private static final String DATA_MANAGER_DESCRIPTION = "DataManager of gvSIG Data Access Library";
    public static final String RESOURCE_MANAGER_NAME = "ResourceManager";
    private static final String RESOURCE_MANAGER_DESCRIPTION = "ResourceManager of gvSIG Data Access Library";
    public static final String FEATURETYPE_DEFINITIONS_MANAGER_NAME = "FeatureTypeDefinitionsManager";
    private static final String FEATURETYPE_DEFINITIONS_MANAGER_DESCRIPTION = "FeatureTypeDefinitionsManager of gvSIG Data Access Library";
    private static final DALLocator instance = new DALLocator();

    public static DALLocator getInstance() {
        return instance;
    }

    public String getLocatorName() {
        return LOCATOR_NAME;
    }

    public static DataManager getDataManager() throws LocatorException {
        return (DataManager)DALLocator.getInstance().get(DATA_MANAGER_NAME);
    }

    public static DataManager getManager() throws LocatorException {
        return DALLocator.getDataManager();
    }

    public static void registerDataManager(Class clazz) {
        DALLocator.getInstance().register(DATA_MANAGER_NAME, DATA_MANAGER_DESCRIPTION, clazz);
    }

    public static void registerDefaultDataManager(Class clazz) {
        DALLocator.getInstance().registerDefault(DATA_MANAGER_NAME, DATA_MANAGER_DESCRIPTION, clazz);
    }

    public static ResourceManager getResourceManager() throws LocatorException {
        return (ResourceManager)DALLocator.getInstance().get(RESOURCE_MANAGER_NAME);
    }

    public static void registerResourceManager(Class clazz) {
        DALLocator.getInstance().register(RESOURCE_MANAGER_NAME, RESOURCE_MANAGER_DESCRIPTION, clazz);
    }

    public static FeatureTypeDefinitionsManager getFeatureTypeDefinitionsManager() throws LocatorException {
        return (FeatureTypeDefinitionsManager)DALLocator.getInstance().get(FEATURETYPE_DEFINITIONS_MANAGER_NAME);
    }

    public static void registerFeatureTypeDefinitionsManager(Class clazz) {
        DALLocator.getInstance().register(FEATURETYPE_DEFINITIONS_MANAGER_NAME, FEATURETYPE_DEFINITIONS_MANAGER_DESCRIPTION, clazz);
    }

    public static void registerDefaultFeatureTypeDefinitionsManager(Class clazz) {
        DALLocator.getInstance().registerDefault(FEATURETYPE_DEFINITIONS_MANAGER_NAME, FEATURETYPE_DEFINITIONS_MANAGER_DESCRIPTION, clazz);
    }
}

