/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.swingbox;

import com.sun.net.ssl.internal.ssl.Provider;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Security;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.ChangedCharSetException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.fit.cssbox.swingbox.SwingBoxEditorKit;
import org.fit.cssbox.swingbox.SwingBoxViewFactory;
import org.fit.cssbox.swingbox.util.Anchor;
import org.fit.cssbox.swingbox.util.CSSBoxAnalyzer;
import org.fit.cssbox.swingbox.util.GeneralEvent;
import org.fit.cssbox.swingbox.util.GeneralEventListener;
import org.fit.cssbox.swingbox.view.ViewportView;
import org.fit.net.DataURLHandler;

public class BrowserPane
extends JEditorPane {
    private static final long serialVersionUID = 7303652028812084960L;
    private InputStream loadingStream;
    private Hashtable<String, Object> pageProperties;
    private Document document;
    private static EditorKit swingBoxEditorKit = null;
    protected String HtmlEditorKitClass = "org.fit.cssbox.swingbox.SwingBoxEditorKit";

    public BrowserPane() {
        this.init();
    }

    protected void init() {
        String handlerPkgs = System.getProperty("java.protocol.handler.pkgs");
        handlerPkgs = handlerPkgs != null && !handlerPkgs.isEmpty() ? handlerPkgs + "|com.sun.net.ssl.internal.www.protocol" : "com.sun.net.ssl.internal.www.protocol";
        System.setProperty("java.protocol.handler.pkgs", handlerPkgs);
        Security.addProvider((java.security.Provider)new Provider());
        if (swingBoxEditorKit == null) {
            swingBoxEditorKit = new SwingBoxEditorKit();
        }
        this.setEditable(false);
        this.setContentType("text/html");
        this.activateTooltip(true);
        Caret caret = this.getCaret();
        if (caret instanceof DefaultCaret) {
            ((DefaultCaret)caret).setUpdatePolicy(1);
        }
    }

    @Override
    public Document getDocument() {
        return this.document;
    }

    @Override
    public void setDocument(Document document) {
        this.document = document;
        super.setDocument(document);
    }

    public void activateTooltip(boolean show) {
        if (show) {
            ToolTipManager.sharedInstance().registerComponent(this);
        } else {
            ToolTipManager.sharedInstance().unregisterComponent(this);
        }
        ToolTipManager.sharedInstance().setEnabled(show);
    }

    public boolean isTooltipActivated() {
        return ToolTipManager.sharedInstance().isEnabled();
    }

    public synchronized void addGeneralEventListener(GeneralEventListener listener) {
        if (listener == null) {
            return;
        }
        this.listenerList.add(GeneralEventListener.class, listener);
    }

    public synchronized void removeGeneralEventListener(GeneralEventListener listener) {
        if (listener == null) {
            return;
        }
        this.listenerList.remove(GeneralEventListener.class, listener);
    }

    public synchronized GeneralEventListener[] getGeneralEventListeners() {
        return (GeneralEventListener[])this.listenerList.getListeners(GeneralEventListener.class);
    }

    public void fireGeneralEvent(GeneralEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != GeneralEventListener.class) continue;
            ((GeneralEventListener)listeners[i + 1]).generalEventUpdate(e);
        }
    }

    public Graphics2D renderContent() {
        ViewportView view = null;
        ViewFactory factory = this.getEditorKit().getViewFactory();
        if (factory instanceof SwingBoxViewFactory) {
            view = ((SwingBoxViewFactory)factory).getViewport();
        }
        if (view != null) {
            int w = (int)((View)view).getPreferredSpan(0);
            int h = (int)((View)view).getPreferredSpan(1);
            Rectangle rec = new Rectangle(w, h);
            BufferedImage img = new BufferedImage(w, h, 1);
            Graphics2D g = img.createGraphics();
            g.setClip(rec);
            ((View)view).paint(g, rec);
            return g;
        }
        return null;
    }

    public Graphics2D renderContent(Graphics2D g) {
        ViewportView view;
        if (g.getClip() == null) {
            throw new NullPointerException("Clip is not set on graphics context");
        }
        ViewFactory factory = this.getEditorKit().getViewFactory();
        if (factory instanceof SwingBoxViewFactory && (view = ((SwingBoxViewFactory)factory).getViewport()) != null) {
            ((View)view).paint(g, g.getClip());
        }
        return g;
    }

    @Override
    public void setText(String t) {
        try {
            URL url = DataURLHandler.createURL(null, (String)("data:text/html," + t));
            this.setPage(url);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean setCSSBoxAnalyzer(CSSBoxAnalyzer cba) {
        EditorKit kit = this.getEditorKit();
        if (kit instanceof SwingBoxEditorKit) {
            ((SwingBoxEditorKit)kit).setCSSBoxAnalyzer(cba);
            return true;
        }
        return false;
    }

    @Override
    public void scrollToReference(String reference) {
        this.tryScrollToReference(reference);
    }

    public boolean tryScrollToReference(String reference) {
        Element dst = this.findElementToScroll(reference, this.getDocument().getDefaultRootElement());
        if (dst != null) {
            try {
                Rectangle bottom = new Rectangle(0, this.getHeight() - 1, 1, 1);
                Rectangle rec = this.modelToView(dst.getStartOffset());
                if (rec != null) {
                    this.scrollRectToVisible(bottom);
                    this.scrollRectToVisible(rec);
                }
                return true;
            }
            catch (BadLocationException e) {
                UIManager.getLookAndFeel().provideErrorFeedback(this);
                return false;
            }
        }
        return false;
    }

    private Element findElementToScroll(String ref, Element root) {
        String name = (String)root.getAttributes().getAttribute("$ename");
        if (!"bg".equals(name)) {
            String eid = (String)root.getAttributes().getAttribute("element_id");
            if (eid != null && ref.equalsIgnoreCase(eid)) {
                return root;
            }
            Anchor anchor = (Anchor)root.getAttributes().getAttribute("attribute_anchor_reference");
            if (anchor != null && anchor.isActive() && anchor.getProperties().get("a_name").equals(ref)) {
                return root;
            }
        }
        int n = root.getElementCount();
        Element child = null;
        for (int i = 0; i < n; ++i) {
            child = this.findElementToScroll(ref, root.getElement(i));
            if (child == null) continue;
            return child;
        }
        return null;
    }

    @Override
    public EditorKit getEditorKitForContentType(String type) {
        if (type.equalsIgnoreCase("text/html") || type.equalsIgnoreCase("application/xhtml+xml") || type.equalsIgnoreCase("text/xhtml")) {
            return swingBoxEditorKit;
        }
        return super.getEditorKitForContentType(type);
    }

    @Override
    protected InputStream getStream(URL page) throws IOException {
        final URLConnection conn = this.setConnectionProperties(page.openConnection());
        if (conn instanceof HttpsURLConnection) {
            System.out.println("$ Connection is HTTPS !!");
        } else if (conn instanceof HttpURLConnection) {
            int response;
            boolean redirect;
            HttpURLConnection hconn = (HttpURLConnection)conn;
            hconn.setInstanceFollowRedirects(false);
            Object postData = this.getPostData();
            if (postData != null) {
                this.handlePostData(hconn, postData);
            }
            boolean bl = redirect = (response = hconn.getResponseCode()) >= 300 && response <= 399;
            if (redirect) {
                String loc = conn.getHeaderField("Location");
                page = loc.startsWith("http", 0) ? new URL(loc) : new URL(page, loc);
                return this.getStream(page);
            }
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.handleConnectionProperties(conn);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        BrowserPane.this.handleConnectionProperties(conn);
                    }
                });
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return conn.getInputStream();
    }

    @Override
    public void setPage(final URL newPage) throws IOException {
        this.fireGeneralEvent(new GeneralEvent(this, GeneralEvent.EventType.page_loading_begin, newPage, null));
        if (newPage == null) {
            throw new IOException("invalid url");
        }
        final URL oldPage = this.getPage();
        Object postData = this.getPostData();
        if (oldPage == null || !oldPage.sameFile(newPage) || postData != null) {
            final InputStream in = this.getStream(newPage);
            EditorKit kit = this.getEditorKit();
            if (kit == null) {
                UIManager.getLookAndFeel().provideErrorFeedback(this);
            } else {
                this.document = this.createDocument(kit, newPage);
                int p = this.getAsynchronousLoadPriority(this.document);
                if (p < 0) {
                    this.loadPage(newPage, oldPage, in, this.document);
                } else {
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            BrowserPane.this.loadPage(newPage, oldPage, in, BrowserPane.this.document);
                        }
                    });
                    t.setDaemon(true);
                    t.start();
                }
            }
        } else if (oldPage.sameFile(newPage) && newPage.getRef() != null) {
            final String reference = newPage.getRef();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BrowserPane.this.scrollToReference(reference);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPage(URL newPage, URL oldPage, InputStream in, Document doc) {
        Object reference;
        boolean done = false;
        try {
            BrowserPane browserPane = this;
            synchronized (browserPane) {
                if (this.loadingStream != null) {
                    this.loadingStream.close();
                    this.loadingStream = null;
                }
                this.loadingStream = in;
            }
            this.read(this.loadingStream, doc);
            this.setDocument(doc);
            reference = newPage.getRef();
            SwingUtilities.invokeLater(new Runnable((String)reference){
                final /* synthetic */ String val$reference;
                {
                    this.val$reference = string;
                }

                @Override
                public void run() {
                    BrowserPane.this.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
                    if (this.val$reference != null) {
                        BrowserPane.this.scrollToReference(this.val$reference);
                    }
                }
            });
            done = true;
            reference = this;
        }
        catch (IOException ioe) {
            BrowserPane browserPane;
            try {
                UIManager.getLookAndFeel().provideErrorFeedback(this);
                browserPane = this;
            }
            catch (Throwable throwable) {
                BrowserPane browserPane2 = this;
                synchronized (browserPane2) {
                    if (this.loadingStream != null) {
                        try {
                            this.loadingStream.close();
                        }
                        catch (IOException ignored) {
                            // empty catch block
                        }
                    }
                    this.loadingStream = null;
                }
                if (done) {
                    SwingUtilities.invokeLater(new Runnable(oldPage, newPage){
                        final /* synthetic */ URL val$oldPage;
                        final /* synthetic */ URL val$newPage;
                        {
                            this.val$oldPage = uRL;
                            this.val$newPage = uRL2;
                        }

                        @Override
                        public void run() {
                            BrowserPane.this.firePropertyChange("page", this.val$oldPage, this.val$newPage);
                        }
                    });
                }
                throw throwable;
            }
            synchronized (browserPane) {
                if (this.loadingStream != null) {
                    try {
                        this.loadingStream.close();
                    }
                    catch (IOException ignored) {
                        // empty catch block
                    }
                }
                this.loadingStream = null;
            }
            if (done) {
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        }
        synchronized (reference) {
            if (this.loadingStream != null) {
                try {
                    this.loadingStream.close();
                }
                catch (IOException ignored) {
                    // empty catch block
                }
            }
            this.loadingStream = null;
        }
        if (done) {
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }
    }

    private Document createDocument(EditorKit kit, URL page) {
        Document doc = kit.createDefaultDocument();
        if (this.pageProperties != null) {
            Enumeration<String> e = this.pageProperties.keys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                doc.putProperty(key, this.pageProperties.get(key));
            }
        }
        if (doc.getProperty("stream") == null) {
            doc.putProperty("stream", page);
        }
        return doc;
    }

    private int getAsynchronousLoadPriority(Document doc) {
        return doc instanceof AbstractDocument ? ((AbstractDocument)doc).getAsynchronousLoadPriority() : -1;
    }

    private Object getPostData() {
        return this.getDocument().getProperty("javax.swing.JEditorPane.postdata");
    }

    private void handleConnectionProperties(URLConnection conn) {
        String type;
        if (this.pageProperties == null) {
            this.pageProperties = new Hashtable(22);
        }
        if ((type = conn.getContentType()) != null) {
            this.setContentType(type);
        }
        this.pageProperties.put("stream", conn.getURL());
        Map<String, List<String>> header = conn.getHeaderFields();
        Set<String> keys = header.keySet();
        for (String key : keys) {
            List<String> obj = header.get(key);
            if (key == null || obj == null) continue;
            this.pageProperties.put(key, obj);
        }
        System.out.println("# pageProperties #");
        for (String k : this.pageProperties.keySet()) {
            System.out.println(k + " : " + this.pageProperties.get(k));
        }
    }

    private URLConnection setConnectionProperties(URLConnection conn) {
        conn.setRequestProperty("User-Agent", "Mozilla/5.0 (compatible; SwingBox/1.x; Linux; U) CSSBox/4.x (like Gecko)");
        conn.setRequestProperty("Accept-Charset", "utf-8");
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePostData(HttpURLConnection conn, Object postData) throws IOException {
        conn.setDoOutput(true);
        FilterOutputStream os = null;
        try {
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            os = new DataOutputStream(conn.getOutputStream());
            ((DataOutputStream)os).writeBytes((String)postData);
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }

    private void setCharsetFromContentTypeParameters(String paramlist) {
        Object charset = null;
        try {
            int semi = paramlist.indexOf(59);
            if (semi > -1 && semi < paramlist.length() - 1) {
                paramlist = paramlist.substring(semi + 1);
            }
            if (paramlist.length() > 0 && charset != null) {
                this.putClientProperty("charset", charset);
            }
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (NullPointerException e) {
        }
        catch (Exception e) {
            System.err.println("JEditorPane.getCharsetFromContentTypeParameters failed on: " + paramlist);
            e.printStackTrace();
        }
    }

    @Override
    public void read(InputStream in, Object desc) throws IOException {
        super.read(in, desc);
    }

    void read(InputStream in, Document doc) throws IOException {
        EditorKit kit = this.getEditorKit();
        try {
            kit.read(in, doc, 0);
        }
        catch (ChangedCharSetException ccse) {
            throw ccse;
        }
        catch (BadLocationException ble) {
            throw new IOException(ble);
        }
    }
}

