/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.spi;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.MutablePair;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.expressionevaluator.ExpressionEvaluatorManager;
import org.gvsig.expressionevaluator.MutableSymbolTable;
import org.gvsig.expressionevaluator.spi.AbstractSymbolTable;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.DynObjectManager;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.lang.Cloneable;

public class DynObjectSymbolTable
extends AbstractSymbolTable
implements MutableSymbolTable {
    private DynObject obj;
    private Map<String, Object> wrapper;

    public DynObjectSymbolTable(String name, DynObject obj) {
        super(name);
        this.obj = obj;
        this.wrapper = DynObjectSymbolTable.createDynObjectToMapAdapter(obj);
        ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getManager();
        manager.populateSymbolTable(this);
    }

    private static Map createDynObjectToMapAdapter(final DynObject obj) {
        return new AbstractMap<String, Object>(){

            @Override
            public Set<Map.Entry<String, Object>> entrySet() {
                return new AbstractSet<Map.Entry<String, Object>>(){

                    @Override
                    public Iterator<Map.Entry<String, Object>> iterator() {
                        return new Iterator<Map.Entry<String, Object>>(){
                            int n = 0;

                            @Override
                            public boolean hasNext() {
                                return this.n < obj.getDynClass().getDynFields().length;
                            }

                            @Override
                            public Map.Entry<String, Object> next() {
                                String name = obj.getDynClass().getDynFields()[this.n++].getName();
                                return new MutablePair((Object)name, obj.getDynValue(name));
                            }
                        };
                    }

                    @Override
                    public int size() {
                        return obj.getDynClass().getDynFields().length;
                    }
                };
            }
        };
    }

    @Override
    protected Map<String, Object> getVars() {
        return this.wrapper;
    }

    @Override
    public void setVar(String name, Object value) {
        this.obj.setDynValue(name, value);
    }

    @Override
    public void removeVar(String name) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public MutableSymbolTable clone() throws CloneNotSupportedException {
        DynObjectSymbolTable other = (DynObjectSymbolTable)super.clone();
        DynObjectManager dynObjectManager = ToolsLocator.getDynObjectManager();
        other.obj = (DynObject)Cloneable.cloneQuietly((Object)this.obj);
        if (other.obj == null) {
            other.obj = dynObjectManager.createDynObject((DynStruct)this.obj.getDynClass());
            dynObjectManager.copy(this.obj, other.obj);
        }
        other.wrapper = DynObjectSymbolTable.createDynObjectToMapAdapter(other.obj);
        return other;
    }
}

