/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.georeferencing.app.georeferencingclient;

import java.util.HashMap;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.gvsig.fmap.dal.coverage.datastruct.GeoPoint;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.algorithm.RasterBaseAlgorithmLibrary;
import org.gvsig.raster.algorithm.process.DataProcess;
import org.gvsig.raster.algorithm.process.ProcessException;
import org.gvsig.raster.georeferencing.app.georeferencingclient.gui.CheckBoxColumnEditor;
import org.gvsig.raster.georeferencing.app.georeferencingclient.gui.CheckBoxColumnRenderer;
import org.gvsig.raster.georeferencing.app.georeferencingclient.gui.ColorColumnRenderer;
import org.gvsig.raster.georeferencing.app.georeferencingclient.gui.GCPModel;
import org.gvsig.raster.georeferencing.lib.impl.GeoTransformDataResult;
import org.gvsig.raster.georeferencing.swing.control.GeorefControlPanel;
import org.gvsig.raster.georeferencing.swing.impl.GeoreferencingSwingImplLibrary;
import org.gvsig.raster.georeferencing.swing.model.GCPList;
import org.gvsig.raster.georeferencing.swing.model.GeoreferencingOptionsDataModel;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.swing.RasterSwingLocator;
import org.gvsig.raster.swing.RasterSwingManager;
import org.gvsig.raster.swing.pagedtable.ModelLoader;
import org.gvsig.raster.swing.pagedtable.PagedTable;
import org.gvsig.raster.swing.pagedtable.TableModel;

public class TableWrapper {
    private PagedTable table = null;
    private DataProcess process = null;
    private GCPList gpList = null;
    private GeoreferencingOptionsDataModel dataModel = null;
    private GeorefControlPanel controlPanel = null;

    public TableWrapper(GeoreferencingOptionsDataModel dataModel, GeorefControlPanel controlPanel) {
        this.gpList = dataModel.getGCPList();
        this.dataModel = dataModel;
        this.controlPanel = controlPanel;
        try {
            this.process = RasterBaseAlgorithmLibrary.getManager().createRasterTask("GeotransformProcess");
        }
        catch (ProcessException e) {
            GeoreferencingSwingImplLibrary.messageBoxError((String)"process_not_registered", null, (Exception)((Object)e));
        }
    }

    public PagedTable getPagedTable() {
        if (this.table == null) {
            RasterSwingManager manager = RasterSwingLocator.getSwingManager();
            String[] columnNames = new String[]{"-", Messages.getText((String)"num"), Messages.getText((String)"worldx"), Messages.getText((String)"worldy"), Messages.getText((String)"imagex"), Messages.getText((String)"imagey"), "Error X", "Error Y", "RMS", ""};
            int[] columnSizes = new int[]{30, 30, -1, -1, -1, -1, -1, -1, -1, 0};
            GCPModel model = new GCPModel(columnNames);
            ModelLoader loader = manager.createModelLoader((TableModel)model);
            CheckBoxColumnRenderer render = new CheckBoxColumnRenderer(null);
            CheckBoxColumnEditor editor = new CheckBoxColumnEditor();
            loader.setRenderForColumn(0, (TableCellRenderer)render);
            loader.setCellEditorForColumn(0, (TableCellEditor)editor);
            loader.setColumnNames(columnNames);
            loader.setColumnWidths(columnSizes);
            this.table = manager.createPagedTable(loader);
            this.table.setConfirmationMessageDeleteAllEntries(Messages.getText((String)"eliminar_puntos"));
            this.table.setConfirmationMessageDeleteOneEntry(Messages.getText((String)"delete_selected_points"));
        }
        return this.table;
    }

    public void initializeRow(int row, long id) {
        this.getPagedTable().setValueAt((Object)new Integer(row), row, 1);
        for (int i = 2; i <= 9; ++i) {
            this.getPagedTable().setValueAt((Object)new Double(0.0), row, i);
        }
        this.getPagedTable().setValueAt((Object)new Long(id), row, this.getPagedTable().getColumnCount() - 1);
    }

    public void updateErrors() {
        this.process.addParam("gcps", (Object)this.gpList.getGeoPointList());
        int degree = 1;
        if (this.dataModel.getAlgorithm() == 0) {
            degree = this.dataModel.getDegree();
        }
        this.process.addParam("Order", (Object)new Integer(degree));
        try {
            this.process.execute();
        }
        catch (ProcessException e) {
            return;
        }
        catch (RuntimeException e) {
            return;
        }
        catch (ProcessInterruptedException e) {
            // empty catch block
        }
        HashMap map = this.process.getResult();
        GeoTransformDataResult result = (GeoTransformDataResult)map.get("RESULT");
        if (result == null) {
            return;
        }
        for (int i = 0; i < this.gpList.size(); ++i) {
            GeoPoint point = this.gpList.getGeoPoint(i);
            this.getPagedTable().setValueAt((Object)new Double(point.getErrorX()), point.getNumber(), 6);
            this.getPagedTable().setValueAt((Object)new Double(point.getErrorY()), point.getNumber(), 7);
            this.getPagedTable().setValueAt((Object)new Double(point.getRms()), point.getNumber(), 8);
        }
        this.updateTableEntryColor();
        this.controlPanel.getError().setValue(result.getRmsTotal() + "");
    }

    public void updateTableEntryColor() {
        ColorColumnRenderer cr = new ColorColumnRenderer();
        for (int i = 0; i < this.getPagedTable().getJTable().getRowCount(); ++i) {
            Object obj = this.getPagedTable().getJTable().getValueAt(i, 8);
            double rms = 0.0;
            try {
                rms = Double.valueOf(obj.toString());
            }
            catch (NumberFormatException e) {
                continue;
            }
            if (rms > this.dataModel.getThreshold()) {
                cr.addRowToColor1(i);
                continue;
            }
            cr.addRowToColor2(i);
        }
        this.getPagedTable().getJTable().getColumnModel().getColumn(8).setCellRenderer(cr);
    }

    public double[] getCoordinatesByTableRow(int row) {
        double xMap = 0.0;
        double yMap = 0.0;
        double xRaster = 0.0;
        double yRaster = 0.0;
        boolean numberFormatException = false;
        Object value = this.getPagedTable().getValueAt(row, 2);
        try {
            if (value instanceof Double) {
                xMap = (Double)value;
            } else if (value instanceof String) {
                xMap = Double.valueOf((String)value);
            }
        }
        catch (NumberFormatException ex1) {
            numberFormatException = true;
        }
        value = this.getPagedTable().getValueAt(row, 3);
        try {
            if (value instanceof Double) {
                yMap = (Double)value;
            } else if (value instanceof String) {
                yMap = Double.valueOf((String)value);
            }
        }
        catch (NumberFormatException ex1) {
            numberFormatException = true;
        }
        try {
            value = this.getPagedTable().getValueAt(row, 4);
            if (value instanceof Double) {
                xRaster = (Double)value;
            } else if (value instanceof String) {
                xRaster = Double.valueOf((String)value);
            }
        }
        catch (NumberFormatException ex1) {
            numberFormatException = true;
        }
        try {
            value = this.getPagedTable().getValueAt(row, 5);
            if (value instanceof Double) {
                yRaster = (Double)value;
            } else if (value instanceof String) {
                yRaster = Double.valueOf((String)value);
            }
        }
        catch (NumberFormatException ex1) {
            numberFormatException = true;
        }
        if (numberFormatException) {
            RasterSwingLibrary.messageBoxError((String)"value_not_valid", (Object)this.table);
            this.getPagedTable().setValueAt((Object)new String(xMap + ""), row, 2);
            this.getPagedTable().setValueAt((Object)new String(yMap + ""), row, 3);
            this.getPagedTable().setValueAt((Object)new String(xRaster + ""), row, 4);
            this.getPagedTable().setValueAt((Object)new String(yRaster + ""), row, 5);
        }
        return new double[]{xMap, yMap, xRaster, yRaster};
    }

    public GeoTransformDataResult getGeoTransformDataResult() {
        if (this.process != null) {
            HashMap map = this.process.getResult();
            GeoTransformDataResult result = (GeoTransformDataResult)map.get("RESULT");
            return result;
        }
        return null;
    }

    public void updatePoint(Object mapX, Object mapY, Object pixelX, Object pixelY, int row) {
        this.getPagedTable().setValueAt(mapX, row, 2);
        this.getPagedTable().setValueAt(mapY, row, 3);
        this.getPagedTable().setValueAt(pixelX, row, 4);
        this.getPagedTable().setValueAt(pixelY, row, 5);
        this.updateErrors();
    }

    public void updateRasterPoint(Object valueX, Object valueY, int row) {
        this.getPagedTable().setValueAt(valueX, row, 4);
        this.getPagedTable().setValueAt(valueY, row, 5);
        this.updateErrors();
    }

    public void updateMapPoint(Object valueX, Object valueY, int row) {
        this.getPagedTable().setValueAt(valueX, row, 2);
        this.getPagedTable().setValueAt(valueY, row, 3);
        this.updateErrors();
    }
}

