/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.georeferencing.app.georeferencingclient.listener;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.raster.georeferencing.swing.exception.InvalidRequestException;
import org.gvsig.raster.georeferencing.swing.view.GeoreferencingView;
import org.gvsig.raster.georeferencing.swing.view.IGraphicLayer;
import org.gvsig.raster.georeferencing.swing.view.IViewRequestManager;

public abstract class AbstractViewRequestManager
implements IViewRequestManager {
    protected GeoreferencingView view = null;
    private Color backGroundColor = null;
    private BufferedImage initImg = null;

    public Color getBackGroundColor() {
        return this.backGroundColor;
    }

    public void setBackGroundColor(Color backGroundColor) {
        this.backGroundColor = backGroundColor;
    }

    protected BufferedImage getBufferedImage() {
        if (this.initImg == null) {
            this.initImg = new BufferedImage(this.view.getCanvasWidth(), this.view.getCanvasHeight(), 2);
        }
        if (this.initImg.getWidth() != this.view.getCanvasWidth() || this.initImg.getHeight() != this.view.getCanvasHeight()) {
            this.initImg = new BufferedImage(this.view.getCanvasWidth(), this.view.getCanvasHeight(), 2);
        }
        return this.initImg;
    }

    protected Graphics2D getCleanGraphics() {
        Graphics2D g2d = (Graphics2D)this.getBufferedImage().getGraphics();
        if (this.getBackGroundColor() != null) {
            g2d.setColor(this.getBackGroundColor());
            g2d.fillRect(0, 0, this.getBufferedImage().getWidth(), this.getBufferedImage().getHeight());
        }
        return g2d;
    }

    public Rectangle2D initRequest(Extent ext) throws InvalidRequestException {
        Rectangle2D extent = ext.toRectangle2D();
        double x = extent.getX();
        double y = extent.getY();
        double w = extent.getWidth();
        double h = extent.getHeight();
        if (extent.getWidth() < extent.getHeight()) {
            if ((double)this.view.getCanvasWidth() / (double)this.view.getCanvasHeight() <= extent.getWidth() / extent.getHeight()) {
                h = (double)this.view.getCanvasHeight() * w / (double)this.view.getCanvasWidth();
                y = extent.getCenterY() - h / 2.0;
            } else {
                w = (double)this.view.getCanvasWidth() * h / (double)this.view.getCanvasHeight();
                x = extent.getCenterX() - w / 2.0;
            }
        } else if ((double)this.view.getCanvasWidth() / (double)this.view.getCanvasHeight() >= extent.getWidth() / extent.getHeight()) {
            w = (double)this.view.getCanvasWidth() * h / (double)this.view.getCanvasHeight();
            x = extent.getCenterX() - w / 2.0;
        } else {
            h = (double)this.view.getCanvasHeight() * w / (double)this.view.getCanvasWidth();
            y = extent.getCenterY() - h / 2.0;
        }
        Rectangle2D.Double r = new Rectangle2D.Double(x, y, w, h);
        this.setDrawParams(null, r);
        this.request(RasterLocator.getManager().getDataStructFactory().createExtent((Rectangle2D)r), null);
        return r;
    }

    public void setDrawParams(BufferedImage img, Rectangle2D extBuf) {
        if (this.view != null) {
            if (img != null) {
                this.view.setDrawParams(img, extBuf, extBuf.getWidth() / (double)img.getWidth(), (Point2D)new Point2D.Double(extBuf.getCenterX(), extBuf.getCenterY()));
            } else {
                this.view.setDrawParams(img, extBuf, extBuf.getWidth() / (double)this.view.getCanvasWidth(), (Point2D)new Point2D.Double(extBuf.getCenterX(), extBuf.getCenterY()));
            }
        }
    }

    public void setGCPsGraphicLayer(IGraphicLayer gl) {
    }
}

