/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.georeferencing.app.georeferencingclient.listener;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.gvsig.andami.PluginServices;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.impl.DefaultMapContextDrawer;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.georeferencing.app.georeferencingclient.listener.AbstractViewRequestManager;
import org.gvsig.raster.georeferencing.swing.exception.InvalidRequestException;
import org.gvsig.raster.georeferencing.swing.view.GeoreferencingView;
import org.gvsig.tools.task.Cancellable;

public class ViewMapRequestManager
extends AbstractViewRequestManager {
    private FLayers lyrs = null;
    private MapControl mapControl = null;
    private FLyrRaster testLayer = null;

    public ViewMapRequestManager(GeoreferencingView view, MapControl mapControl) {
        this.mapControl = mapControl;
        if (mapControl != null) {
            this.lyrs = mapControl.getMapContext().getLayers();
        }
        this.view = view;
    }

    public void addTestRasterLayer(FLyrRaster lyr) throws InvalidRequestException {
        if (this.lyrs == null || lyr == null) {
            return;
        }
        this.testLayer = lyr;
        this.lyrs.addLayer((FLayer)lyr);
        this.view.getCanvas().setForceRequest(true);
        Envelope e = lyr.getFullEnvelope();
        Extent extent = RasterLocator.getManager().getDataStructFactory().createExtent(e.getMinimum(0), e.getMaximum(1), e.getMaximum(0), e.getMinimum(1));
        this.initRequest(extent);
    }

    public void removeTestRasterLayer() throws InvalidRequestException {
        if (this.testLayer != null) {
            this.lyrs.removeLayer((FLayer)this.testLayer);
            PluginServices.getMainFrame().enableControls();
        }
        this.view.getCanvas().setForceRequest(true);
        Rectangle2D r = this.view.getCanvas().getCanvasExtent();
        Extent extent = RasterLocator.getManager().getDataStructFactory().createExtent(r.getMinX(), r.getMaxY(), r.getMaxX(), r.getMinY());
        this.initRequest(extent);
    }

    public BufferedImage request(Rectangle2D req, Cancellable cancel) throws InvalidRequestException {
        Extent e = null;
        if (req != null) {
            e = RasterLocator.getManager().getDataStructFactory().createExtent(req);
        }
        return this.request(e, cancel);
    }

    public BufferedImage request(Extent req, Cancellable cancel) throws InvalidRequestException {
        if (this.view.getCanvasWidth() == 0 || this.view.getCanvasHeight() == 0 || req == null) {
            return null;
        }
        try {
            ViewPort vp = new ViewPort(null);
            vp.setImageSize(new Dimension(this.view.getCanvasWidth(), this.view.getCanvasHeight()));
            Envelope e = GeometryLocator.getGeometryManager().createEnvelope(req.getMin().getX(), req.getMin().getY(), req.getMax().getX(), req.getMax().getY(), 0);
            vp.setEnvelope(e);
            vp.setProjection(this.mapControl.getMapContext().getProjection());
            BufferedImage buf = this.getBufferedImage();
            Graphics2D g2d = this.getCleanGraphics();
            DefaultMapContextDrawer mapContextDrawer = new DefaultMapContextDrawer();
            mapContextDrawer.setMapContext(this.lyrs.getMapContext());
            mapContextDrawer.setViewPort(vp);
            Cancellable c = new Cancellable(){

                public void setCanceled(boolean canceled) {
                }

                public boolean isCanceled() {
                    return false;
                }
            };
            Cancellable cancelation = cancel != null ? cancel : c;
            mapContextDrawer.draw(this.lyrs, buf, g2d, cancelation, this.mapControl.getMapContext().getScaleView());
            if (!cancelation.isCanceled()) {
                this.setDrawParams(buf, req.toRectangle2D());
            }
            return buf;
        }
        catch (Exception ex) {
            throw new InvalidRequestException("Error en al acceso al fichero", (Throwable)ex);
        }
    }

    public void fullExtent() throws InvalidRequestException {
        Envelope e = this.lyrs.getFullEnvelope();
        Extent extent = RasterLocator.getManager().getDataStructFactory().createExtent(e.getMinimum(0), e.getMaximum(1), e.getMaximum(0), e.getMinimum(1));
        this.initRequest(extent);
    }

    @Override
    public void setDrawParams(BufferedImage img, Rectangle2D extBuf) {
        if (this.lyrs != null) {
            super.setDrawParams(img, extBuf);
        }
    }
}

