/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.crs.gui;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;
import org.cresques.cts.IProjection;
import org.gvsig.andami.ProjectionContainerManager;
import org.gvsig.crs.CrsWkt;
import org.gvsig.crs.ICrs;
import org.gvsig.crs.gui.CRSMainTrPanel;
import org.gvsig.crs.persistence.CrsData;
import org.gvsig.crs.persistence.RecentCRSsPersistence;

public class CRSSelectionTrDialog
extends JPanel {
    private static final long serialVersionUID = 1L;
    JPanel contentPane = null;
    ICrs curProj = null;
    private IProjection lastProj = null;

    public CRSSelectionTrDialog(ICrs proj) {
        super(false);
        this.curProj = proj;
        if (this.curProj != null && this.curProj.getSourceTransformationParams() == null && this.curProj.getTargetTransformationParams() == null) {
            CrsData crsData = new CrsData(proj.getCrsWkt().getAuthority()[0], proj.getCode(), proj.getCrsWkt().getName());
            RecentCRSsPersistence persistence = new RecentCRSsPersistence();
            persistence.addCrsData(crsData);
        }
        this.inicializate();
    }

    public void inicializate() {
        this.add((Component)this.getContentPanel(), null);
        this.setPreferredSize(new Dimension(650, 350));
    }

    public CRSMainTrPanel getProjPanel() {
        return (CRSMainTrPanel)this.getContentPanel();
    }

    public IProjection getProjection() {
        return this.getProjPanel().getProjection();
    }

    public void setProjection(IProjection proj) {
        this.lastProj = proj;
        this.getProjPanel().setProjection(proj);
    }

    public JPanel getContentPanel() {
        if (this.contentPane == null) {
            IProjection projectionOfActiveView = this.getProjectionOfActiveView();
            if (projectionOfActiveView != null) {
                int target = ((ICrs)projectionOfActiveView).getCode();
                CrsWkt crsWktTarget = ((ICrs)projectionOfActiveView).getCrsWkt();
                if (crsWktTarget.getDatumName().equals("")) {
                    // empty if block
                }
                this.contentPane = new CRSMainTrPanel(target, crsWktTarget, this.curProj);
            } else {
                this.contentPane = new CRSMainTrPanel(this.curProj);
            }
        }
        return this.contentPane;
    }

    private IProjection getProjectionOfActiveView() {
        return (IProjection)ProjectionContainerManager.getCurrentProjection();
    }

    public boolean isOkPressed() {
        return true;
    }
}

