/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.crs.gui.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;
import org.cresques.ui.DefaultDialogPanel;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.crs.CrsException;
import org.gvsig.crs.CrsFactory;
import org.gvsig.crs.ICrs;
import org.gvsig.crs.persistence.RecentTrsPersistence;
import org.gvsig.crs.persistence.TrData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfoCRSPanel
extends DefaultDialogPanel
implements IWindow,
ActionListener {
    public static final Logger logger = LoggerFactory.getLogger(InfoCRSPanel.class);
    private static final long serialVersionUID = 1L;
    private JPanel panelLabels;
    private JTable jTable;
    public DefaultTableModel dtm = null;
    private JScrollPane jScrollPane1 = null;
    private JPanel jPanelbuttons;
    private JButton jButtonOk;
    private ICrs proj;
    private JLabel jLabelProjcs;
    private JLabel jLabelGeogcs;
    private JLabel jLabelDatum;
    private JLabel jLabelSpheroid;
    private JLabel jLabelPrimem;
    private JLabel jLabelProjection;
    private JLabel jLabelUnits;
    private JLabel jLabelUnits_p;
    private JLabel jLabelProjcsdinamic;
    private JLabel jLabelGeogcsdinamic;
    private JLabel jLabelDatumdinamic;
    private JLabel jLabelSpheroiddinamic;
    private JLabel jLabelPrimemdinamic;
    private JLabel jLabelProjectiondinamic;
    private JLabel jLabelUnitsdinamic;
    private JLabel jLabelUnits_pdinamic;
    private JEditorPane jEditorPane = null;
    private JScrollPane jScrollPane = null;
    private String page = "";
    private boolean isTransformation = false;
    private String details = null;
    private String transformationAuthority = null;
    private int transformationCode = -1;
    private String sourceCrs = null;
    private String targetCrs = null;
    private String transformationName = null;

    public InfoCRSPanel(String fuente, int codigo) {
        super(false);
        try {
            this.proj = new CrsFactory().getCRS(fuente + ":" + codigo);
        }
        catch (CrsException e) {
            logger.error("Can't create CRS from autority '" + fuente + "' and code " + codigo + ".", (Throwable)e);
        }
        this.inicializate();
    }

    public InfoCRSPanel(String fuente, int codigo, String trans) {
        super(false);
        try {
            this.proj = new CrsFactory().getCRS(fuente + ":" + codigo);
        }
        catch (CrsException e) {
            logger.error("Can't create CRS from authority '" + fuente + "' and code " + codigo + ".", (Throwable)e);
        }
        if (!trans.equals(PluginServices.getText((Object)this, (String)"sin_transformacion"))) {
            this.isTransformation = true;
            this.details = trans;
            RecentTrsPersistence trPersistence = new RecentTrsPersistence();
            TrData[] crsTrDataArray = trPersistence.getArrayOfTrData();
            for (int iRow = crsTrDataArray.length - 1; iRow >= 0; --iRow) {
                if (!this.details.equals(crsTrDataArray[iRow].getAuthority() + ":" + crsTrDataArray[iRow].getCode() + " <--> " + crsTrDataArray[iRow].getDetails())) continue;
                this.transformationAuthority = crsTrDataArray[iRow].getAuthority();
                this.transformationCode = crsTrDataArray[iRow].getCode();
                this.sourceCrs = crsTrDataArray[iRow].getCrsSource();
                this.targetCrs = crsTrDataArray[iRow].getCrsTarget();
                this.transformationName = crsTrDataArray[iRow].getName();
                this.details = crsTrDataArray[iRow].getDetails();
            }
        }
        this.inicializate();
    }

    private void inicializate() {
        this.setLayout(new BorderLayout());
        JPanel p = new JPanel(new BorderLayout());
        p.setBorder(new EmptyBorder(0, 10, 0, 10));
        this.createPage();
        p.add(this.getJScrollPane());
        this.add(p, "Center");
        this.add(this.getJPanelButtons(), "South");
    }

    private JPanel getPanel() {
        if (this.panelLabels == null) {
            this.panelLabels = new JPanel();
            this.panelLabels.setLayout(new GridLayout(4, 2));
            JPanel p00 = new JPanel(new FlowLayout(0, 10, 5));
            p00.add(this.getJLabelProjcs());
            p00.add(this.getJLabelProjcsDinamic());
            JPanel p01 = new JPanel(new FlowLayout(0, 10, 5));
            p01.add(this.getJLabelGeogcs());
            p01.add(this.getJLabelGeogcsDinamic());
            JPanel p10 = new JPanel(new FlowLayout(0, 10, 5));
            p10.add(this.getJLabelDatum());
            p10.add(this.getJLabelDatumDinamic());
            JPanel p11 = new JPanel(new FlowLayout(0, 10, 5));
            p11.add(this.getJLabelSpheroid());
            p11.add(this.getJLabelSpheroidDinamic());
            JPanel p20 = new JPanel(new FlowLayout(0, 10, 5));
            p20.add(this.getJLabelPrimen());
            p20.add(this.getJLabelPrimenDinamic());
            JPanel p21 = new JPanel(new FlowLayout(0, 10, 5));
            p21.add(this.getJLabelUnits());
            p21.add(this.getJLabelUnitsDinamic());
            JPanel p30 = new JPanel(new FlowLayout(0, 10, 5));
            p30.add(this.getJLabelProjection());
            p30.add(this.getJLabelProjectionDinamic());
            JPanel p31 = new JPanel(new FlowLayout(0, 10, 5));
            p31.add(this.getJLabelUnits_p());
            p31.add(this.getJLabelUnits_pDinamic());
            this.panelLabels.add(p00);
            this.panelLabels.add(p01);
            this.panelLabels.add(p10);
            this.panelLabels.add(p11);
            this.panelLabels.add(p20);
            this.panelLabels.add(p21);
            this.panelLabels.add(p30);
            this.panelLabels.add(p31);
        }
        return this.panelLabels;
    }

    private JPanel getJPanelButtons() {
        if (this.jPanelbuttons == null) {
            this.jPanelbuttons = new JPanel();
            this.jPanelbuttons.setLayout(new FlowLayout(2, 10, 10));
            this.jPanelbuttons.add((Component)this.getJButtonOk(), null);
        }
        return this.jPanelbuttons;
    }

    private JButton getJButtonOk() {
        if (this.jButtonOk == null) {
            this.jButtonOk = new JButton();
            this.jButtonOk.setText(PluginServices.getText((Object)this, (String)"ok"));
            this.jButtonOk.setPreferredSize(new Dimension(100, 25));
            this.jButtonOk.setMnemonic('O');
            this.jButtonOk.setToolTipText("Accept");
            this.jButtonOk.addActionListener(this);
        }
        return this.jButtonOk;
    }

    private JLabel getJLabelProjcs() {
        if (this.jLabelProjcs == null) {
            this.jLabelProjcs = new JLabel();
            this.jLabelProjcs.setFont(new Font("Projcs:", 1, 10));
            this.jLabelProjcs.setText(PluginServices.getText((Object)this, (String)"projcs") + ":");
        }
        return this.jLabelProjcs;
    }

    private JLabel getJLabelProjcsDinamic() {
        if (this.jLabelProjcsdinamic == null) {
            this.jLabelProjcsdinamic = new JLabel();
            this.jLabelProjcsdinamic.setFont(new Font("", 0, 10));
            this.jLabelProjcsdinamic.setText(this.proj.getCrsWkt().getProjcs());
        }
        return this.jLabelProjcsdinamic;
    }

    private JLabel getJLabelGeogcs() {
        if (this.jLabelGeogcs == null) {
            this.jLabelGeogcs = new JLabel();
            this.jLabelGeogcs.setFont(new Font("Geogcs:", 1, 10));
            this.jLabelGeogcs.setText(PluginServices.getText((Object)this, (String)"geogcs") + ":");
        }
        return this.jLabelGeogcs;
    }

    private JLabel getJLabelGeogcsDinamic() {
        if (this.jLabelGeogcsdinamic == null) {
            this.jLabelGeogcsdinamic = new JLabel();
            this.jLabelGeogcsdinamic.setFont(new Font("", 0, 10));
            this.jLabelGeogcsdinamic.setText(this.proj.getCrsWkt().getGeogcs());
        }
        return this.jLabelGeogcsdinamic;
    }

    private JLabel getJLabelDatum() {
        if (this.jLabelDatum == null) {
            this.jLabelDatum = new JLabel();
            this.jLabelDatum.setFont(new Font("Datum:", 1, 10));
            this.jLabelDatum.setText(PluginServices.getText((Object)this, (String)"datum") + ":");
        }
        return this.jLabelDatum;
    }

    private JLabel getJLabelDatumDinamic() {
        if (this.jLabelDatumdinamic == null) {
            this.jLabelDatumdinamic = new JLabel();
            this.jLabelDatumdinamic.setFont(new Font("", 0, 10));
            this.jLabelDatumdinamic.setText(this.proj.getCrsWkt().getDatumName());
        }
        return this.jLabelDatumdinamic;
    }

    private JLabel getJLabelSpheroid() {
        if (this.jLabelSpheroid == null) {
            this.jLabelSpheroid = new JLabel();
            this.jLabelSpheroid.setFont(new Font("Spheroid", 1, 10));
            this.jLabelSpheroid.setText(PluginServices.getText((Object)this, (String)"spheriod") + ":");
        }
        return this.jLabelSpheroid;
    }

    private JLabel getJLabelSpheroidDinamic() {
        if (this.jLabelSpheroiddinamic == null) {
            String[] sphe = this.proj.getCrsWkt().getSpheroid();
            this.jLabelSpheroiddinamic = new JLabel();
            this.jLabelSpheroiddinamic.setFont(new Font("", 0, 10));
            this.jLabelSpheroiddinamic.setText(sphe[0] + " , " + sphe[1] + " , " + sphe[2]);
        }
        return this.jLabelSpheroiddinamic;
    }

    private JLabel getJLabelPrimen() {
        if (this.jLabelPrimem == null) {
            this.jLabelPrimem = new JLabel();
            this.jLabelPrimem.setFont(new Font("Primen:", 1, 10));
            this.jLabelPrimem.setText(PluginServices.getText((Object)this, (String)"primem") + ":");
        }
        return this.jLabelPrimem;
    }

    private JLabel getJLabelPrimenDinamic() {
        if (this.jLabelPrimemdinamic == null) {
            String[] pri = this.proj.getCrsWkt().getPrimen();
            this.jLabelPrimemdinamic = new JLabel();
            this.jLabelPrimemdinamic.setFont(new Font("", 0, 10));
            this.jLabelPrimemdinamic.setText(pri[0] + " , " + pri[1]);
        }
        return this.jLabelPrimemdinamic;
    }

    private JLabel getJLabelProjection() {
        if (this.jLabelProjection == null) {
            this.jLabelProjection = new JLabel();
            this.jLabelProjection.setFont(new Font("Projection", 1, 10));
            this.jLabelProjection.setText(PluginServices.getText((Object)this, (String)"projection") + ":");
        }
        return this.jLabelProjection;
    }

    private JLabel getJLabelProjectionDinamic() {
        if (this.jLabelProjectiondinamic == null) {
            this.jLabelProjectiondinamic = new JLabel();
            this.jLabelProjectiondinamic.setFont(new Font("", 0, 10));
            this.jLabelProjectiondinamic.setText(this.proj.getCrsWkt().getProjection());
        }
        return this.jLabelProjectiondinamic;
    }

    private JLabel getJLabelUnits() {
        if (this.jLabelUnits == null) {
            this.jLabelUnits = new JLabel();
            this.jLabelUnits.setFont(new Font("Units", 1, 10));
            this.jLabelUnits.setText(PluginServices.getText((Object)this, (String)"units") + ":");
        }
        return this.jLabelUnits;
    }

    private JLabel getJLabelUnitsDinamic() {
        if (this.jLabelUnitsdinamic == null) {
            String[] units = this.proj.getCrsWkt().getUnit();
            this.jLabelUnitsdinamic = new JLabel();
            this.jLabelUnitsdinamic.setPreferredSize(new Dimension(200, 20));
            this.jLabelUnitsdinamic.setFont(new Font("", 0, 10));
            this.jLabelUnitsdinamic.setText(units[0] + " , " + units[1]);
            System.out.println("Unidades:  " + units[0] + " , " + units[1]);
        }
        return this.jLabelUnitsdinamic;
    }

    private JLabel getJLabelUnits_p() {
        if (this.jLabelUnits_p == null) {
            this.jLabelUnits_p = new JLabel();
            this.jLabelUnits_p.setFont(new Font("", 1, 10));
            this.jLabelUnits_p.setText(PluginServices.getText((Object)this, (String)"units_p") + ":");
        }
        return this.jLabelUnits_p;
    }

    private JLabel getJLabelUnits_pDinamic() {
        if (this.jLabelUnits_pdinamic == null) {
            String[] uni_p = this.proj.getCrsWkt().getUnit_p();
            this.jLabelUnits_pdinamic = new JLabel();
            this.jLabelUnits_pdinamic.setFont(new Font("", 0, 10));
            this.jLabelUnits_pdinamic.setText(uni_p[0] + " , " + uni_p[1]);
        }
        return this.jLabelUnits_pdinamic;
    }

    private JScrollPane getJScrollPane1() {
        if (this.jScrollPane1 == null) {
            this.jScrollPane1 = new JScrollPane();
            this.jScrollPane1.setPreferredSize(new Dimension(400, 150));
            this.jScrollPane1.setViewportView(this.getJTable());
        }
        return this.jScrollPane1;
    }

    private JTable getJTable() {
        if (this.jTable == null) {
            Object[][] data;
            Object[] columnNames = new String[]{PluginServices.getText((Object)this, (String)"nombre"), PluginServices.getText((Object)this, (String)"valor")};
            String[] param_n = this.proj.getCrsWkt().getParam_name();
            String[] param_v = this.proj.getCrsWkt().getParam_value();
            if (param_v != null) {
                data = new Object[param_v.length][2];
                for (int i = 0; i < 2; ++i) {
                    for (int j = 0; j < param_n.length; ++j) {
                        data[j][i] = i == 0 ? param_n[j] : param_v[j];
                    }
                }
            } else {
                data = new Object[1][1];
            }
            this.dtm = new DefaultTableModel(data, columnNames);
            this.jTable = new JTable(this.dtm);
            this.jTable.setCellSelectionEnabled(false);
            this.jTable.setRowSelectionAllowed(true);
            this.jTable.setColumnSelectionAllowed(false);
            this.jTable.setSelectionMode(0);
        }
        return this.jTable;
    }

    public WindowInfo getWindowInfo() {
        WindowInfo m_viewinfo = new WindowInfo(8);
        m_viewinfo.setTitle(PluginServices.getText((Object)this, (String)this.proj.getCrsWkt().getName()));
        m_viewinfo.setWidth(600);
        m_viewinfo.setHeight(500);
        return m_viewinfo;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getJButtonOk()) {
            PluginServices.getMDIManager().closeWindow((IWindow)this);
        }
    }

    private JScrollPane getJScrollPane() {
        this.jScrollPane = new JScrollPane();
        this.jScrollPane.setPreferredSize(new Dimension(300, 450));
        this.jScrollPane.setViewportView(this.getJEditorPane());
        return this.jScrollPane;
    }

    private JEditorPane getJEditorPane() {
        this.jEditorPane = new JEditorPane();
        this.jEditorPane.setEditable(false);
        this.jEditorPane.setContentType("text/html");
        this.jEditorPane.setPreferredSize(new Dimension(300, 450));
        this.jEditorPane.setText(this.page);
        return this.jEditorPane;
    }

    private void createPage() {
        String title = PluginServices.getText((Object)this, (String)"infoCRS");
        this.page = this.page + "<html>  <head>  <title>" + title + "</title> <meta content=\"\"> <style></style> </head> <body>";
        this.page = this.page + "<p align=\"center\"><font size=5><b>" + title.toUpperCase() + "</font></b></p>";
        this.page = this.page + "<br><table width=\"100%\" border=\"0\">  <tr> <td width=\"50%\">" + PluginServices.getText((Object)this, (String)"codeSelectedCrs") + ": " + this.proj.getCode() + "</td> " + "<td width=\"50%\"><div align=\"center\">" + PluginServices.getText((Object)this, (String)"repository") + ": " + this.proj.getCrsWkt().getAuthority()[0] + "</div></td> " + "</tr>";
        String projected = this.proj.getCrsWkt().getProjcs().equals("") ? PluginServices.getText((Object)this, (String)"no") : PluginServices.getText((Object)this, (String)"si");
        this.page = this.page + "<tr> <td width=\"50%\">" + PluginServices.getText((Object)this, (String)"nameSelectedCrs") + ": " + this.proj.getCrsWkt().getName() + "</td> " + "<td width=\"50%\"><div align=\"center\">" + PluginServices.getText((Object)this, (String)"projected") + ": " + projected + "</div></td> " + "</tr>";
        this.page = this.page + "<tr> <td width=\"60%\">" + PluginServices.getText((Object)this, (String)"nameDatum") + ": " + this.proj.getCrsWkt().getDatumName() + "</td> " + "<td width=\"40%\"><div align=\"center\">" + "</div></td> " + "</tr>";
        this.page = this.page + "</table>";
        this.page = this.page + "<br><table width=\"100%\" border=\"2\">  <tr> <td align=\"center\"><b>" + PluginServices.getText((Object)this, (String)"ellipsoid") + ": " + this.proj.getCrsWkt().getSpheroid()[0] + "</b></td> " + "</tr>";
        this.page = this.page + "<tr> <td>" + PluginServices.getText((Object)this, (String)"semiMajorAxis") + "</td> " + "<td><div align=\"center\">" + this.proj.getCrsWkt().getSpheroid()[1] + "</div></td> " + "</tr>";
        this.page = this.page + "<tr> <td>" + PluginServices.getText((Object)this, (String)"invFlattening") + "</td> " + "<td><div align=\"center\">" + this.proj.getCrsWkt().getSpheroid()[2] + "</div></td> " + "</tr>";
        this.page = this.page + "</table>";
        this.page = this.page + "<br><table width=\"100%\" border=\"2\">  <tr> <td align=\"center\"><b>" + PluginServices.getText((Object)this, (String)"primeMeridian") + ": " + this.proj.getCrsWkt().getPrimen()[0] + "</b></td> " + "</tr>";
        this.page = this.page + "<tr> <td>" + PluginServices.getText((Object)this, (String)"greenwichLongitude") + "</td> " + "<td><div align=\"center\">" + this.proj.getCrsWkt().getPrimen()[1] + "</div></td> " + "</tr>";
        this.page = this.page + "</table>";
        if (projected.equals(PluginServices.getText((Object)this, (String)"si"))) {
            this.page = this.page + "<p><font size=4>" + PluginServices.getText((Object)this, (String)"projection") + ": <b>" + this.proj.getCrsWkt().getProjection() + "</b></font></p>";
            this.page = this.page + "<p align=\"center\">" + PluginServices.getText((Object)this, (String)"parameters") + "<table width=\"100%\" border=\"2\">  ";
            for (int i = 0; i < this.proj.getCrsWkt().getParam_name().length; ++i) {
                this.page = this.page + "<tr> <td align=\"center\">" + PluginServices.getText((Object)this, (String)this.proj.getCrsWkt().getParam_name()[i]) + "</td> " + "<td align=\"center\">" + this.proj.getCrsWkt().getParam_value()[i] + "</td> " + "</tr>";
            }
            this.page = this.page + "</table>";
        }
        try {
            this.page = this.page + "<p>" + PluginServices.getText((Object)this, (String)"proj4Chain") + ": " + this.proj.getProj4String() + "</p>";
        }
        catch (CrsException e) {
            logger.error("Can't get proj4 string.", (Throwable)e);
        }
        if (this.isTransformation) {
            this.page = this.page + "<p align=\"center\"><font size=5><b>" + PluginServices.getText((Object)this, (String)"transformation") + "</b></font></p>";
            this.page = this.page + "<p>" + PluginServices.getText((Object)this, (String)"type_transformation") + ": ";
            if (this.transformationAuthority.equals(PluginServices.getText((Object)this, (String)"USR"))) {
                this.page = this.page + PluginServices.getText((Object)this, (String)"user") + "</p>";
            } else if (this.transformationAuthority.equals(PluginServices.getText((Object)this, (String)"EPSG"))) {
                this.page = this.page + PluginServices.getText((Object)this, (String)"EPSG") + ":" + this.transformationCode + "</p>";
                this.page = this.page + "<p>" + PluginServices.getText((Object)this, (String)"name") + ": " + this.transformationName + "</p>";
            } else if (this.transformationAuthority.equals(PluginServices.getText((Object)this, (String)"NADGR"))) {
                this.page = this.page + PluginServices.getText((Object)this, (String)"nadgrids") + "</p>";
            } else if (this.transformationAuthority.equals(PluginServices.getText((Object)this, (String)"COMP"))) {
                this.page = this.page + PluginServices.getText((Object)this, (String)"compound") + "</p>";
            }
            this.page = this.page + "<br><table width=\"100%\" border=\"0\">  <tr> <td align=\"center\">" + PluginServices.getText((Object)this, (String)"source_crs") + ": " + this.sourceCrs + "</td> " + "<td align=\"center\">" + PluginServices.getText((Object)this, (String)"target_crs") + ": " + this.targetCrs + "</td> " + "</tr></table>";
            this.page = this.page + "<p>" + PluginServices.getText((Object)this, (String)"detailsTransformation") + ": " + this.details + "</p>";
        }
        this.page = this.page + "</body> </html>";
    }

    public Object getWindowProfile() {
        return WindowInfo.DIALOG_PROFILE;
    }
}

