/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.crs.gui.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.cresques.cts.IProjection;
import org.gvsig.andami.PluginServices;
import org.gvsig.app.gui.panels.CRSSelectPanel;
import org.gvsig.crs.ICrs;
import org.gvsig.crs.gui.dialog.CSSelectionDialog;
import org.gvsig.crs.gui.dialog.TRSelectionDialog;
import org.gvsig.gui.beans.swing.JButton;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;

public class ProjChooserPanel
extends CRSSelectPanel {
    private static final long serialVersionUID = 1L;
    public ICrs curProj = null;
    private JLabel jLblProj = null;
    private JLabel jLblProjName = null;
    private JButton jBtnChangeProj = null;
    private boolean okPressed = false;
    private String abrev;
    boolean panel = false;
    boolean targetNad = false;
    String dataSource = "EPSG";

    public ProjChooserPanel(IProjection proj) {
        super(proj);
        this.setCurProj(proj);
        this.initialize();
    }

    private void initialize() {
        GridLayout gl = new GridLayout(1, 2);
        this.setLayout(gl);
        this.add(this.getJLblProjName());
        JPanel secondHalf = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridy = 0;
        secondHalf.add((Component)this.getJLblProj(), c);
        c.fill = 0;
        c.weightx = 0.0;
        c.gridx = 1;
        secondHalf.add((Component)this.getJBtnChangeProj(), c);
        this.add(secondHalf);
        this.initBtnChangeProj();
    }

    private void initBtnChangeProj() {
        this.getJBtnChangeProj().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CSSelectionDialog csSelect = null;
                TRSelectionDialog trSelect = null;
                if (!ProjChooserPanel.this.isTransPanelActive()) {
                    ProjChooserPanel.this.okPressed = false;
                    csSelect = new CSSelectionDialog(ProjChooserPanel.this.curProj);
                    csSelect.setProjection((IProjection)ProjChooserPanel.this.curProj);
                    csSelect.initRecents(ProjChooserPanel.this.curProj);
                    ToolsSwingLocator.getWindowManager().showWindow((JComponent)csSelect, ToolsLocator.getI18nManager().getTranslation("nuevo_crs"), WindowManager.MODE.DIALOG);
                    ProjChooserPanel.this.abrev = ProjChooserPanel.this.dataSource + ":" + String.valueOf(ProjChooserPanel.this.curProj.getCode());
                    if (csSelect.isOkPressed()) {
                        ProjChooserPanel.this.curProj = (ICrs)csSelect.getProjection();
                        ProjChooserPanel.this.dataSource = ProjChooserPanel.this.curProj.getCrsWkt().getAuthority()[0];
                        ProjChooserPanel.this.abrev = ProjChooserPanel.this.dataSource + ":" + String.valueOf(ProjChooserPanel.this.curProj.getCode());
                        ProjChooserPanel.this.getJLblProj().setText(ProjChooserPanel.this.dataSource + ":" + String.valueOf(ProjChooserPanel.this.curProj.getCode()));
                        ProjChooserPanel.this.okPressed = true;
                        if (ProjChooserPanel.this.actionListener != null) {
                            ProjChooserPanel.this.actionListener.actionPerformed(e);
                        }
                    } else {
                        ProjChooserPanel.this.getJLblProj().setText(ProjChooserPanel.this.abrev);
                    }
                } else {
                    ProjChooserPanel.this.okPressed = false;
                    trSelect = new TRSelectionDialog(ProjChooserPanel.this.curProj);
                    trSelect.setProjection((IProjection)ProjChooserPanel.this.curProj);
                    trSelect.setLayout(new GridLayout(0, 1));
                    ToolsSwingLocator.getWindowManager().showWindow((JComponent)trSelect, ToolsLocator.getI18nManager().getTranslation("crsAndTransformation"), WindowManager.MODE.DIALOG);
                    ProjChooserPanel.this.setTargetNad(trSelect.getTargetNad());
                    if (trSelect.getProjection() != ProjChooserPanel.this.curProj) {
                        ProjChooserPanel.this.curProj = (ICrs)trSelect.getProjection();
                        ProjChooserPanel.this.dataSource = ProjChooserPanel.this.curProj.getCrsWkt().getAuthority()[0];
                        ProjChooserPanel.this.getJLblProj().setText(ProjChooserPanel.this.dataSource + ":" + String.valueOf(ProjChooserPanel.this.curProj.getCode()));
                        ProjChooserPanel.this.okPressed = true;
                        if (ProjChooserPanel.this.actionListener != null) {
                            ProjChooserPanel.this.actionListener.actionPerformed(e);
                        }
                    } else {
                        ProjChooserPanel.this.refresh();
                    }
                }
            }
        });
    }

    public JLabel getJLblProjName() {
        if (this.jLblProjName == null) {
            this.jLblProjName = new JLabel("Proyeccion actual");
            this.jLblProjName.setText(PluginServices.getText((Object)((Object)this), (String)"proyeccion_actual"));
        }
        return this.jLblProjName;
    }

    public JLabel getJLabel() {
        return this.getJLblProjName();
    }

    public JLabel getJLblProj() {
        if (this.jLblProj == null) {
            this.jLblProj = new JLabel();
        }
        return this.jLblProj;
    }

    public JButton getJBtnChangeProj() {
        if (this.jBtnChangeProj == null) {
            this.jBtnChangeProj = new JButton();
            this.jBtnChangeProj.setText("...");
        }
        return this.jBtnChangeProj;
    }

    public void setTargetNad(boolean tarNad) {
        this.targetNad = tarNad;
    }

    public boolean getTargetNad() {
        return this.targetNad;
    }

    public IProjection getCurProj() {
        return this.curProj;
    }

    public void setCurProj(IProjection curProj) {
        this.curProj = (ICrs)curProj;
        this.refresh();
    }

    private void refresh() {
        if (this.curProj != null) {
            this.dataSource = this.curProj.getCrsWkt().getAuthority()[0];
            String text = this.dataSource + ":" + String.valueOf(this.curProj.getCode());
            this.getJLblProj().setText(text.trim());
        } else {
            this.getJLblProj().setText("");
        }
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }
}

