/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.crs.persistence;

import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class CrsData
implements Comparable,
Persistent {
    private static final String CRSDATA_PERSISTENCE_DEFINITION_NAME = "jCRS_CrsData";
    private String authority = null;
    private int code = 0;
    private String name = null;
    private Date date = null;
    private Properties properties = new Properties();

    public CrsData(String authority, int code, String name) {
        this.authority = authority;
        this.code = code;
        this.name = name;
        this.date = new Date();
    }

    public CrsData(String authority, int code, String name, Date date) {
        this.authority = authority;
        this.code = code;
        this.name = name;
        this.date = date;
    }

    public CrsData() {
    }

    public String getAuthority() {
        return this.authority;
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public Properties getProperies() {
        return this.properties;
    }

    public void setProperies(Properties properies) {
        this.properties = properies;
    }

    public void setAuthority(String authority) {
        this.authority = authority;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getDate() {
        return this.date;
    }

    public void updateLastAccess() {
        this.date = new Date();
    }

    public int compareTo(Object o) {
        CrsData crsData = (CrsData)o;
        return this.date.compareTo(crsData.getDate());
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("date", this.date);
        state.set("name", this.name);
        state.set("authority", this.authority);
        state.set("code", Integer.valueOf(this.code));
        state.set("properies", (Map)this.properties);
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.date = state.getDate("date");
        this.name = state.getString("name");
        this.authority = state.getString("authority");
        this.code = state.getInt("code");
        Map properties = state.getMap("properies");
        this.properties = new Properties();
        this.properties.putAll((Map<?, ?>)properties);
    }

    public static void registerPersistence() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition(CRSDATA_PERSISTENCE_DEFINITION_NAME) == null) {
            DynStruct definition = manager.addDefinition(CrsData.class, CRSDATA_PERSISTENCE_DEFINITION_NAME, "jCRS_CrsData Persistence definition", null, null);
            definition.addDynFieldDate("date").setMandatory(false);
            definition.addDynFieldString("name").setMandatory(false);
            definition.addDynFieldString("authority").setMandatory(false);
            definition.addDynFieldInt("code").setMandatory(false);
            definition.addDynFieldMap("properies").setClassOfItems(String.class).setMandatory(false);
        }
    }
}

