/*
 * Decompiled with CFR 0.152.
 */
package com.github.tbekolay.jnumeric;

import com.github.tbekolay.jnumeric.PyMultiarray;
import com.github.tbekolay.jnumeric.UnaryFunction;
import java.lang.reflect.Array;

final class Log10
extends UnaryFunction {
    final double log10 = Math.log(10.0);

    Log10() {
    }

    @Override
    String docString() {
        return "log10(a [,r]) returns log10(a) and stores the result in r if supplied.\n";
    }

    @Override
    public PyMultiarray Double(PyMultiarray a) {
        for (int i = 0; i < Array.getLength(a.data); ++i) {
            Array.setDouble(a.data, i, Math.log(Array.getDouble(a.data, i)) / this.log10);
        }
        return a;
    }

    @Override
    public PyMultiarray ComplexDouble(PyMultiarray a) {
        for (int i = 0; i < Array.getLength(a.data); i += 2) {
            double re = Array.getDouble(a.data, i);
            double im = Array.getDouble(a.data, i + 1);
            Array.setDouble(a.data, i, Math.log(Math.sqrt(im * im + re * re)) / this.log10);
            Array.setDouble(a.data, i + 1, Math.atan2(im, re) / this.log10);
        }
        return a;
    }
}

